/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.testreader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.testreader.CustomFormatReader;
import org.geotools.api.coverage.grid.GridCoverageWriter;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public final class CustomFormat
extends AbstractGridFormat {
    public static final String CUSTOM_DIMENSION_NAME = "MY_DIMENSION";
    private static final String TYPE_NAME = "org.geoserver.catalog.testreader.CustomFormat";
    static final Logger LOGGER = Logging.getLogger(CustomFormat.class);
    private static final ParameterDescriptor<List> CUSTOM_DIMENSION = DefaultParameterDescriptor.create((String)"MY_DIMENSION", (CharSequence)"Optional list of nonstandard dimension values", List.class, null, (boolean)false);

    public CustomFormat() {
        this.mInfo = new HashMap();
        this.mInfo.put("name", TYPE_NAME);
        this.mInfo.put("description", "Test custom coverage format - only visible with test jars in the classpath");
        this.mInfo.put("docURL", "");
        this.mInfo.put("version", "1.0");
        this.writeParameters = null;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, INPUT_TRANSPARENT_COLOR, CUSTOM_DIMENSION}));
    }

    public boolean accepts(Object source) {
        return this.accepts(source, null);
    }

    public boolean accepts(Object source, Hints hints) {
        File propertiesFile;
        if (!(source instanceof File)) {
            return false;
        }
        File dir = (File)source;
        if (dir.isDirectory() && (propertiesFile = new File(dir, "datastore.properties")).exists()) {
            boolean bl;
            Properties props = new Properties();
            FileInputStream fis = new FileInputStream(propertiesFile);
            try {
                props.load(fis);
                bl = TYPE_NAME.equalsIgnoreCase(props.getProperty("type"));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "", e);
                }
            }
            fis.close();
            return bl;
        }
        return false;
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException();
    }

    public AbstractGridCoverage2DReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public AbstractGridCoverage2DReader getReader(Object source, Hints hints) {
        try {
            return new CustomFormatReader(source, hints);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "", e);
            return null;
        }
    }

    public GridCoverageWriter getWriter(Object source) {
        return this.getWriter(source, null);
    }

    public GridCoverageWriter getWriter(Object source, Hints hints) {
        throw new UnsupportedOperationException("This plugin does not support writing");
    }
}

