/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.catalog.impl.LayerGroupStyleImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.MapInfoImpl;
import org.geoserver.catalog.impl.ResolvingProxy;
import org.geoserver.catalog.impl.ResolvingProxyResolver;
import org.geoserver.catalog.impl.ResourceInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ResolvingProxyResolverTest {
    private Catalog catalog;
    private WorkspaceInfo workspace;
    private NamespaceInfo namespace;
    private DataStoreInfo store;
    private FeatureTypeInfo resource;
    private StyleInfo style;
    private LayerInfo layer;
    private LayerGroupInfo layerGroup;

    @Before
    public void setUp() {
        this.catalog = (Catalog)Mockito.mock(Catalog.class);
        this.workspace = (WorkspaceInfo)Mockito.mock(WorkspaceInfo.class);
        Mockito.when((Object)this.workspace.getId()).thenReturn((Object)"ws-id");
        Mockito.when((Object)this.workspace.getName()).thenReturn((Object)"ws-name");
        this.namespace = (NamespaceInfo)Mockito.mock(NamespaceInfo.class);
        Mockito.when((Object)this.namespace.getId()).thenReturn((Object)"ns-id");
        Mockito.when((Object)this.namespace.getPrefix()).thenReturn((Object)"ns-prefix");
        Mockito.when((Object)this.namespace.getURI()).thenReturn((Object)"ns-uri");
        this.store = (DataStoreInfo)Mockito.mock(DataStoreInfo.class);
        Mockito.when((Object)this.store.getId()).thenReturn((Object)"store-id");
        Mockito.when((Object)this.store.getName()).thenReturn((Object)"store-name");
        Mockito.when((Object)this.store.getWorkspace()).thenReturn((Object)this.workspace);
        this.resource = (FeatureTypeInfo)Mockito.mock(FeatureTypeInfo.class);
        Mockito.when((Object)this.resource.getId()).thenReturn((Object)"resource-id");
        Mockito.when((Object)this.resource.getName()).thenReturn((Object)"resource-name");
        Mockito.when((Object)this.resource.getStore()).thenReturn((Object)this.store);
        Mockito.when((Object)this.resource.getNamespace()).thenReturn((Object)this.namespace);
        if (this.resource instanceof ResourceInfoImpl) {
            ((ResourceInfoImpl)this.resource).setCatalog(this.catalog);
        }
        this.style = (StyleInfo)Mockito.mock(StyleInfo.class);
        Mockito.when((Object)this.style.getId()).thenReturn((Object)"style-id");
        Mockito.when((Object)this.style.getName()).thenReturn((Object)"style-name");
        Mockito.when((Object)this.style.getWorkspace()).thenReturn((Object)this.workspace);
        if (this.style instanceof StyleInfoImpl) {
            ((StyleInfoImpl)this.style).setCatalog(this.catalog);
        }
        this.layer = (LayerInfo)Mockito.mock(LayerInfo.class);
        Mockito.when((Object)this.layer.getId()).thenReturn((Object)"layer-id");
        Mockito.when((Object)this.layer.getName()).thenReturn((Object)"layer-name");
        Mockito.when((Object)this.layer.getResource()).thenReturn((Object)this.resource);
        Mockito.when((Object)this.layer.getDefaultStyle()).thenReturn((Object)this.style);
        LinkedHashSet<StyleInfo> styles = new LinkedHashSet<StyleInfo>();
        styles.add(this.style);
        Mockito.when((Object)this.layer.getStyles()).thenReturn(styles);
        this.layerGroup = (LayerGroupInfo)Mockito.mock(LayerGroupInfo.class);
        Mockito.when((Object)this.layerGroup.getId()).thenReturn((Object)"layergroup-id");
        Mockito.when((Object)this.layerGroup.getName()).thenReturn((Object)"layergroup-name");
        Mockito.when((Object)this.layerGroup.getWorkspace()).thenReturn((Object)this.workspace);
        Mockito.when((Object)this.layerGroup.getRootLayer()).thenReturn((Object)this.layer);
        Mockito.when((Object)this.layerGroup.getRootLayerStyle()).thenReturn((Object)this.style);
        List<PublishedInfo> layers = Arrays.asList(this.layer);
        List<StyleInfo> styles2 = Arrays.asList(this.style);
        Mockito.when((Object)this.layerGroup.getLayers()).thenReturn(layers);
        Mockito.when((Object)this.layerGroup.getStyles()).thenReturn(styles2);
        LayerGroupStyle groupStyle = (LayerGroupStyle)Mockito.mock(LayerGroupStyle.class);
        Mockito.when((Object)groupStyle.getLayers()).thenReturn(layers);
        Mockito.when((Object)groupStyle.getStyles()).thenReturn(styles2);
        Mockito.when((Object)this.layerGroup.getLayerGroupStyles()).thenReturn(Arrays.asList(groupStyle));
        Mockito.when((Object)this.catalog.getWorkspace(this.workspace.getId())).thenReturn((Object)this.workspace);
        Mockito.when((Object)this.catalog.getNamespace(this.namespace.getId())).thenReturn((Object)this.namespace);
        Mockito.when((Object)this.catalog.getStore(this.store.getId(), StoreInfo.class)).thenReturn((Object)this.store);
        Mockito.when((Object)((DataStoreInfo)this.catalog.getStore(this.store.getId(), DataStoreInfo.class))).thenReturn((Object)this.store);
        Mockito.when((Object)this.catalog.getDataStore(this.store.getId())).thenReturn((Object)this.store);
        Mockito.when((Object)this.catalog.getResource(this.resource.getId(), ResourceInfo.class)).thenReturn((Object)this.resource);
        Mockito.when((Object)((FeatureTypeInfo)this.catalog.getResource(this.resource.getId(), FeatureTypeInfo.class))).thenReturn((Object)this.resource);
        Mockito.when((Object)this.catalog.getFeatureType(this.resource.getId())).thenReturn((Object)this.resource);
        Mockito.when((Object)this.catalog.getLayer(this.layer.getId())).thenReturn((Object)this.layer);
        Mockito.when((Object)this.catalog.getStyle(this.style.getId())).thenReturn((Object)this.style);
        Mockito.when((Object)this.catalog.getLayerGroup(this.layerGroup.getId())).thenReturn((Object)this.layerGroup);
    }

    @Test
    public void testResolveWorkspace() {
        ResolvingProxyResolver.resolve((CatalogInfo)this.workspace, (Catalog)this.catalog);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.catalog});
    }

    @Test
    public void testResolveNamespace() {
        ResolvingProxyResolver.resolve((CatalogInfo)this.namespace, (Catalog)this.catalog);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.catalog});
    }

    @Test
    public void testResolveStore() {
        WorkspaceInfo proxy = (WorkspaceInfo)ResolvingProxy.create((String)this.workspace.getId(), WorkspaceInfo.class);
        this.store = new DataStoreInfoImpl();
        this.store.setWorkspace(proxy);
        ResolvingProxyResolver.resolve((CatalogInfo)this.store, (Catalog)this.catalog);
        ((Catalog)Mockito.verify((Object)this.catalog)).getWorkspace(this.workspace.getId());
        Assert.assertSame((Object)this.workspace, (Object)this.store.getWorkspace());
        Assert.assertSame((Object)this.catalog, (Object)this.store.getCatalog());
    }

    @Test
    public void testResolveStoreMissingWorkspacePreservesProxy() {
        WorkspaceInfo proxy = (WorkspaceInfo)ResolvingProxy.create((String)"missing", WorkspaceInfo.class);
        Mockito.when((Object)this.catalog.getWorkspace("missing")).thenReturn(null);
        this.store = new DataStoreInfoImpl();
        this.store.setWorkspace(proxy);
        Assert.assertSame((Object)proxy, (Object)this.store.getWorkspace());
        ResolvingProxyResolver.resolve((CatalogInfo)this.store, (Catalog)this.catalog);
        ((Catalog)Mockito.verify((Object)this.catalog)).getWorkspace("missing");
        Assert.assertSame((Object)proxy, (Object)this.store.getWorkspace());
    }

    @Test
    public void testResolveResource() {
        StoreInfo proxyStore = (StoreInfo)ResolvingProxy.create((String)this.store.getId(), DataStoreInfo.class);
        NamespaceInfo proxyNamespace = (NamespaceInfo)ResolvingProxy.create((String)this.namespace.getId(), NamespaceInfo.class);
        FeatureTypeInfoImpl resourceWithProxies = new FeatureTypeInfoImpl();
        resourceWithProxies.setStore(proxyStore);
        resourceWithProxies.setNamespace(proxyNamespace);
        ResolvingProxyResolver.resolve((CatalogInfo)resourceWithProxies, (Catalog)this.catalog);
        ((Catalog)Mockito.verify((Object)this.catalog)).getDataStore(this.store.getId());
        ((Catalog)Mockito.verify((Object)this.catalog)).getNamespace(this.namespace.getId());
        Assert.assertSame((Object)this.store, (Object)resourceWithProxies.getStore());
        Assert.assertSame((Object)this.namespace, (Object)resourceWithProxies.getNamespace());
    }

    @Test
    public void testResolveResourceMissingRefs() {
        StoreInfo proxyStore = (StoreInfo)ResolvingProxy.create((String)"missing-store", DataStoreInfo.class);
        NamespaceInfo proxyNamespace = (NamespaceInfo)ResolvingProxy.create((String)"missing-ns", NamespaceInfo.class);
        FeatureTypeInfoImpl resourceWithProxies = new FeatureTypeInfoImpl();
        resourceWithProxies.setStore(proxyStore);
        resourceWithProxies.setNamespace(proxyNamespace);
        ResolvingProxyResolver.resolve((CatalogInfo)resourceWithProxies, (Catalog)this.catalog);
        ((Catalog)Mockito.verify((Object)this.catalog)).getDataStore("missing-store");
        ((Catalog)Mockito.verify((Object)this.catalog)).getNamespace("missing-ns");
        Assert.assertSame((Object)proxyStore, (Object)resourceWithProxies.getStore());
        Assert.assertSame((Object)proxyNamespace, (Object)resourceWithProxies.getNamespace());
    }

    @Test
    public void testResolveLayer() {
        FeatureTypeInfo proxyResource = (FeatureTypeInfo)ResolvingProxy.create((String)"resource-id", FeatureTypeInfo.class);
        StyleInfo proxyStyle = (StyleInfo)ResolvingProxy.create((String)"style-id", StyleInfo.class);
        LayerInfoImpl layerWithProxies = new LayerInfoImpl();
        layerWithProxies.setResource((ResourceInfo)proxyResource);
        layerWithProxies.setDefaultStyle(proxyStyle);
        layerWithProxies.getStyles().add(proxyStyle);
        ResolvingProxyResolver.resolve((CatalogInfo)layerWithProxies, (Catalog)this.catalog);
        Assert.assertSame((Object)this.resource, (Object)layerWithProxies.getResource());
        Assert.assertSame((Object)this.style, (Object)layerWithProxies.getDefaultStyle());
        Assert.assertEquals(Set.of(this.style), (Object)layerWithProxies.getStyles());
        ((Catalog)Mockito.verify((Object)this.catalog)).getFeatureType("resource-id");
        ((Catalog)Mockito.verify((Object)this.catalog, (VerificationMode)Mockito.times((int)2))).getStyle("style-id");
    }

    @Test
    public void testResolveLayerPreservesMissingResourceAndDefaultStyle() {
        FeatureTypeInfo proxyResource = (FeatureTypeInfo)ResolvingProxy.create((String)"missing-resource-id", FeatureTypeInfo.class);
        StyleInfo proxyStyle = (StyleInfo)ResolvingProxy.create((String)"missing-style-id", StyleInfo.class);
        LayerInfoImpl layerWithProxies = new LayerInfoImpl();
        layerWithProxies.setResource((ResourceInfo)proxyResource);
        layerWithProxies.setDefaultStyle(proxyStyle);
        ResolvingProxyResolver.resolve((CatalogInfo)layerWithProxies, (Catalog)this.catalog);
        Assert.assertSame((Object)proxyResource, (Object)layerWithProxies.getResource());
        Assert.assertSame((Object)proxyStyle, (Object)layerWithProxies.getDefaultStyle());
    }

    @Test
    public void testResolveLayerNullifiesMissingStyles() {
        StyleInfo proxyStyle = (StyleInfo)ResolvingProxy.create((String)"missing-style-id", StyleInfo.class);
        LayerInfoImpl layerWithProxies = new LayerInfoImpl();
        layerWithProxies.getStyles().add(proxyStyle);
        ResolvingProxyResolver.resolve((CatalogInfo)layerWithProxies, (Catalog)this.catalog);
        HashSet<Object> expected = new HashSet<Object>();
        expected.add(null);
        Assert.assertEquals(expected, (Object)layerWithProxies.getStyles());
    }

    @Test
    public void testResolveLayerWithNullProxies() {
        LayerInfoImpl layerWithNullProxies = new LayerInfoImpl();
        layerWithNullProxies.setResource(null);
        layerWithNullProxies.setDefaultStyle(null);
        layerWithNullProxies.getStyles().add(null);
        ResolvingProxyResolver.resolve((CatalogInfo)layerWithNullProxies, (Catalog)this.catalog);
        Assert.assertNull((Object)layerWithNullProxies.getResource());
        Assert.assertNull((Object)layerWithNullProxies.getDefaultStyle());
        HashSet<Object> expected = new HashSet<Object>();
        expected.add(null);
        Assert.assertEquals(expected, (Object)layerWithNullProxies.getStyles());
    }

    @Test
    public void testResolveLayerGroup() {
        WorkspaceInfo proxyWorkspace = (WorkspaceInfo)ResolvingProxy.create((String)"ws-id", WorkspaceInfo.class);
        LayerInfo proxyLayer = (LayerInfo)ResolvingProxy.create((String)"layer-id", LayerInfo.class);
        StyleInfo proxyStyle = (StyleInfo)ResolvingProxy.create((String)"style-id", StyleInfo.class);
        LayerGroupInfoImpl layerGroupWithProxies = new LayerGroupInfoImpl();
        layerGroupWithProxies.setWorkspace(proxyWorkspace);
        layerGroupWithProxies.setRootLayer(proxyLayer);
        layerGroupWithProxies.setRootLayerStyle(proxyStyle);
        layerGroupWithProxies.getLayers().add(proxyLayer);
        layerGroupWithProxies.getStyles().add(proxyStyle);
        LayerGroupStyleImpl groupStyle = new LayerGroupStyleImpl();
        groupStyle.getLayers().add(proxyLayer);
        groupStyle.getStyles().add(proxyStyle);
        layerGroupWithProxies.getLayerGroupStyles().add(groupStyle);
        ResolvingProxyResolver.resolve((CatalogInfo)layerGroupWithProxies, (Catalog)this.catalog);
        Assert.assertSame((Object)this.workspace, (Object)layerGroupWithProxies.getWorkspace());
        Assert.assertSame((Object)this.layer, (Object)layerGroupWithProxies.getRootLayer());
        Assert.assertSame((Object)this.style, (Object)layerGroupWithProxies.getRootLayerStyle());
        Assert.assertEquals(List.of(this.layer), (Object)layerGroupWithProxies.getLayers());
        Assert.assertEquals(List.of(this.style), (Object)layerGroupWithProxies.getStyles());
        LayerGroupStyle lgs = (LayerGroupStyle)layerGroupWithProxies.getLayerGroupStyles().get(0);
        Assert.assertEquals(List.of(this.layer), (Object)lgs.getLayers());
        Assert.assertEquals(List.of(this.style), (Object)lgs.getStyles());
    }

    @Test
    public void testResolveLayerGroupPreservesMissingWorkspace() {
        WorkspaceInfo proxyWorkspace = (WorkspaceInfo)ResolvingProxy.create((String)"missing-ws-id", WorkspaceInfo.class);
        LayerGroupInfoImpl layerGroupWithProxies = new LayerGroupInfoImpl();
        layerGroupWithProxies.setWorkspace(proxyWorkspace);
        ResolvingProxyResolver.resolve((CatalogInfo)layerGroupWithProxies, (Catalog)this.catalog);
        Assert.assertSame((Object)proxyWorkspace, (Object)layerGroupWithProxies.getWorkspace());
    }

    @Test
    public void testResolveLayerGroupStylesSpecialCase() {
        LayerGroupInfo proxyLayerGroup = (LayerGroupInfo)ResolvingProxy.create((String)"missing-layergroup-id", LayerGroupInfo.class);
        StyleInfo proxyStyle = (StyleInfo)ResolvingProxy.create((String)"another-style-id", StyleInfo.class);
        LayerGroupInfoImpl layerGroupWithProxies = new LayerGroupInfoImpl();
        layerGroupWithProxies.getLayers().add(proxyLayerGroup);
        layerGroupWithProxies.getStyles().add(proxyStyle);
        ResolvingProxyResolver.resolve((CatalogInfo)layerGroupWithProxies, (Catalog)this.catalog);
        StyleInfoImpl expected = new StyleInfoImpl();
        expected.setName("another-style-id");
        Assert.assertEquals(List.of(expected), (Object)layerGroupWithProxies.getStyles());
    }

    @Test
    public void testResolveLayerGroupStylesNull() {
        LayerGroupInfo proxyLayerGroup = (LayerGroupInfo)ResolvingProxy.create((String)"missing-layergroup-id", LayerGroupInfo.class);
        LayerGroupInfoImpl layerGroupWithProxies = new LayerGroupInfoImpl();
        layerGroupWithProxies.getLayers().add(proxyLayerGroup);
        layerGroupWithProxies.getStyles().add(null);
        ResolvingProxyResolver.resolve((CatalogInfo)layerGroupWithProxies, (Catalog)this.catalog);
        ArrayList<Object> expected = new ArrayList<Object>();
        expected.add(null);
        Assert.assertEquals(expected, (Object)layerGroupWithProxies.getStyles());
    }

    @Test
    public void testResolveStyle() {
        WorkspaceInfo proxyWorkspace = (WorkspaceInfo)ResolvingProxy.create((String)"ws-id", WorkspaceInfo.class);
        Mockito.when((Object)this.catalog.getWorkspace("missing")).thenReturn(null);
        StyleInfoImpl styleWithProxy = new StyleInfoImpl();
        styleWithProxy.setWorkspace(proxyWorkspace);
        ResolvingProxyResolver.resolve((CatalogInfo)styleWithProxy, (Catalog)this.catalog);
        ((Catalog)Mockito.verify((Object)this.catalog)).getWorkspace("ws-id");
        Assert.assertSame((Object)this.workspace, (Object)styleWithProxy.getWorkspace());
        Assert.assertSame((Object)this.catalog, (Object)styleWithProxy.getCatalog());
    }

    @Test
    public void testResolveStyleKeepsMissingProxy() {
        WorkspaceInfo proxyWorkspace = (WorkspaceInfo)ResolvingProxy.create((String)"missing", WorkspaceInfo.class);
        Mockito.when((Object)this.catalog.getWorkspace("missing")).thenReturn(null);
        StyleInfoImpl styleWithProxy = new StyleInfoImpl();
        styleWithProxy.setWorkspace(proxyWorkspace);
        ResolvingProxyResolver.resolve((CatalogInfo)styleWithProxy, (Catalog)this.catalog);
        ((Catalog)Mockito.verify((Object)this.catalog)).getWorkspace("missing");
        Assert.assertSame((Object)proxyWorkspace, (Object)styleWithProxy.getWorkspace());
        Assert.assertSame((Object)this.catalog, (Object)styleWithProxy.getCatalog());
    }

    @Test
    public void testResolveLayerGroupStylesWithSpecialCase() {
        LayerGroupInfo proxyLayerGroup = (LayerGroupInfo)ResolvingProxy.create((String)"layergroup-id", LayerGroupInfo.class);
        StyleInfo proxyStyle = (StyleInfo)ResolvingProxy.create((String)"layergroup-style-name", StyleInfo.class);
        List<PublishedInfo> layers = Arrays.asList(proxyLayerGroup);
        List<StyleInfo> styles = Arrays.asList(proxyStyle);
        LayerGroupInfoImpl testLayerGroup = new LayerGroupInfoImpl();
        testLayerGroup.setLayers(layers);
        testLayerGroup.setStyles(styles);
        ResolvingProxyResolver.resolve((CatalogInfo)testLayerGroup, (Catalog)this.catalog);
        StyleInfo resolvedStyle = (StyleInfo)testLayerGroup.getStyles().get(0);
        Assert.assertNotNull((Object)resolvedStyle);
        Assert.assertEquals((Object)"layergroup-style-name", (Object)resolvedStyle.getName());
    }

    @Test
    public void testResolveMapInfo() {
        ResolvingProxyResolver.resolve((CatalogInfo)new MapInfoImpl(), (Catalog)this.catalog);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.catalog});
    }

    @Test
    public void testUnknownCatalognfo() {
        ResolvingProxyResolver.resolve((CatalogInfo)((CatalogInfo)Mockito.mock(CatalogInfo.class)), (Catalog)this.catalog);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.catalog});
    }
}

