/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.junit.Assert;
import org.junit.Test;

public class ReaderDimensionAccessorTest {
    private static SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    @Test
    public void testMixedTimeExtraction() throws IOException, ParseException {
        MockDimensionReader reader = new MockDimensionReader();
        reader.metadata.put("HAS_TIME_DOMAIN", "true");
        reader.metadata.put("TIME_DOMAIN", "2016-02-23T03:00:00.000Z/2016-02-23T03:00:00.000Z/PT1S,2016-02-23T06:00:00.000Z,2016-02-23T09:00:00.000Z/2016-02-23T12:00:00.000Z/PT1S");
        ReaderDimensionsAccessor accessor = new ReaderDimensionsAccessor((GridCoverage2DReader)reader);
        TreeSet domain = accessor.getTimeDomain();
        Assert.assertEquals((long)3L, (long)domain.size());
        Iterator it = domain.iterator();
        Date firstEntry = (Date)it.next();
        Assert.assertEquals((Object)accessor.getTimeFormat().parse("2016-02-23T03:00:00.000Z"), (Object)firstEntry);
        Date secondEntry = (Date)it.next();
        Assert.assertEquals((Object)accessor.getTimeFormat().parse("2016-02-23T06:00:00.000Z"), (Object)secondEntry);
        DateRange thirdEntry = (DateRange)it.next();
        Assert.assertEquals((Object)accessor.getTimeFormat().parse("2016-02-23T09:00:00.000Z"), (Object)thirdEntry.getMinValue());
        Assert.assertEquals((Object)accessor.getTimeFormat().parse("2016-02-23T12:00:00.000Z"), (Object)thirdEntry.getMaxValue());
    }

    @Test
    public void testMixedElevationExtraction() throws IOException {
        MockDimensionReader reader = new MockDimensionReader();
        reader.metadata.put("HAS_ELEVATION_DOMAIN", "true");
        reader.metadata.put("ELEVATION_DOMAIN", "0/0/0,10,15/20/1");
        ReaderDimensionsAccessor accessor = new ReaderDimensionsAccessor((GridCoverage2DReader)reader);
        TreeSet domain = accessor.getElevationDomain();
        Assert.assertEquals((long)3L, (long)domain.size());
        Iterator it = domain.iterator();
        Number firstEntry = (Number)it.next();
        Assert.assertEquals((double)0.0, (double)firstEntry.doubleValue(), (double)0.0);
        Number secondEntry = (Number)it.next();
        Assert.assertEquals((double)10.0, (double)secondEntry.doubleValue(), (double)0.0);
        NumberRange thirdEntry = (NumberRange)it.next();
        Assert.assertEquals((double)15.0, (double)thirdEntry.getMinimum(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)thirdEntry.getMaximum(), (double)0.0);
    }

    @Test
    public void testCustomTimeDimensionConvertion() throws IOException, ParseException {
        MockDimensionReader reader = new MockDimensionReader();
        reader.metadata.put("HAS_MYDIM_DOMAIN", "true");
        reader.metadata.put("MYDIM_DOMAIN_DATATYPE", "java.util.Date");
        ReaderDimensionsAccessor accessor = new ReaderDimensionsAccessor((GridCoverage2DReader)reader);
        List converted = accessor.convertDimensionValue("MYDIM", Arrays.asList("2001-05-01T00:00:00.000Z", "2001-05-02T00:00:00.000Z", "2001-05-03T00:00:00.000Z"));
        Assert.assertEquals((long)3L, (long)converted.size());
        Assert.assertEquals((Object)DF.parse("2001-05-01 00:00:00"), converted.get(0));
        Assert.assertEquals((Object)DF.parse("2001-05-02 00:00:00"), converted.get(1));
        Assert.assertEquals((Object)DF.parse("2001-05-03 00:00:00"), converted.get(2));
    }

    @Test
    public void testCustomDepthDimensionConvertion() throws IOException, ParseException {
        MockDimensionReader reader = new MockDimensionReader();
        reader.metadata.put("HAS_MYDIM_DOMAIN", "true");
        reader.metadata.put("MYDIM_DOMAIN_DATATYPE", "java.lang.Double");
        ReaderDimensionsAccessor accessor = new ReaderDimensionsAccessor((GridCoverage2DReader)reader);
        List converted = accessor.convertDimensionValue("MYDIM", Arrays.asList("10/20"));
        Assert.assertEquals((long)1L, (long)converted.size());
        NumberRange expected = new NumberRange(Double.class, (Number)10.0, (Number)20.0);
        Assert.assertEquals((Object)expected, converted.get(0));
    }

    @Test
    public void testCustomCloudCoverDimensionConvertion() throws IOException, ParseException {
        MockDimensionReader reader = new MockDimensionReader();
        reader.metadata.put("HAS_MYDIM_DOMAIN", "true");
        reader.metadata.put("MYDIM_DOMAIN_DATATYPE", "java.lang.Integer");
        ReaderDimensionsAccessor accessor = new ReaderDimensionsAccessor((GridCoverage2DReader)reader);
        List converted = accessor.convertDimensionValue("MYDIM", Arrays.asList("75/100"));
        Assert.assertEquals((long)1L, (long)converted.size());
        NumberRange expected = new NumberRange(Double.class, (Number)75.0, (Number)100.0);
        Assert.assertEquals((Object)expected, converted.get(0));
    }

    @Test
    public void testHasAnyTime() throws Exception {
        MockDimensionReader reader = new MockDimensionReader();
        reader.metadata.put("HAS_TIME_DOMAIN", "true");
        reader.metadata.put("TIME_DOMAIN", "2016-02-23T03:00:00.000Z/2016-02-23T03:00:00.000Z/PT1S,2016-02-23T06:00:00.000Z,2016-02-23T09:00:00.000Z/2016-02-23T12:00:00.000Z/PT1S");
        ReaderDimensionsAccessor accessor = new ReaderDimensionsAccessor((GridCoverage2DReader)reader);
        SimpleDateFormat format = accessor.getTimeFormat();
        ReaderDimensionAccessorTest.assertHasTimes(accessor, format, "2016-02-23T06:00:00.000Z");
        ReaderDimensionAccessorTest.assertHasTimes(accessor, format, "2016-02-23T10:00:00.000Z");
        DateRange rangeBelow = new DateRange(format.parse("2016-02-23T00:00:00.000Z"), format.parse("2016-02-23T05:00:00.000Z"));
        Assert.assertTrue((boolean)accessor.hasAnyTime(Arrays.asList(rangeBelow)));
        DateRange rangeAbove = new DateRange(format.parse("2016-02-23T11:00:00.000Z"), format.parse("2016-02-23T15:00:00.000Z"));
        Assert.assertTrue((boolean)accessor.hasAnyTime(Arrays.asList(rangeAbove)));
        ReaderDimensionAccessorTest.assertNoTimes(accessor, format, "2016-02-23T02:00:00.000Z");
        ReaderDimensionAccessorTest.assertNoTimes(accessor, format, "2016-02-23T05:00:00.000Z");
        ReaderDimensionAccessorTest.assertNoTimes(accessor, format, "2016-02-23T23:00:00.000Z");
        DateRange rangeBefore = new DateRange(format.parse("2016-02-22T00:00:00.000Z"), format.parse("2016-02-22T23:00:00.000Z"));
        Assert.assertFalse((boolean)accessor.hasAnyTime(Arrays.asList(rangeBefore)));
        DateRange rangeMid = new DateRange(format.parse("2016-02-23T04:00:00.000Z"), format.parse("2016-02-23T05:00:00.000Z"));
        Assert.assertFalse((boolean)accessor.hasAnyTime(Arrays.asList(rangeMid)));
        DateRange rangeAfter = new DateRange(format.parse("2016-02-24T00:00:00.000Z"), format.parse("2016-02-24T23:00:00.000Z"));
        Assert.assertFalse((boolean)accessor.hasAnyTime(Arrays.asList(rangeAfter)));
    }

    private static void assertHasTimes(ReaderDimensionsAccessor accessor, SimpleDateFormat format, String source) throws IOException, ParseException {
        Assert.assertTrue((boolean)accessor.hasAnyTime(Arrays.asList(format.parse(source))));
    }

    private static void assertNoTimes(ReaderDimensionsAccessor accessor, SimpleDateFormat format, String source) throws IOException, ParseException {
        Assert.assertFalse((boolean)accessor.hasAnyTime(Arrays.asList(format.parse(source))));
    }

    @Test
    public void testHasAnyElevation() throws Exception {
        MockDimensionReader reader = new MockDimensionReader();
        reader.metadata.put("HAS_ELEVATION_DOMAIN", "true");
        reader.metadata.put("ELEVATION_DOMAIN", "0/0/0,10,15/20/1");
        ReaderDimensionsAccessor accessor = new ReaderDimensionsAccessor((GridCoverage2DReader)reader);
        Assert.assertTrue((boolean)accessor.hasAnyElevation(Arrays.asList(10.0)));
        Assert.assertTrue((boolean)accessor.hasAnyElevation(Arrays.asList(16.0)));
        NumberRange rangeBelow = new NumberRange(Double.class, (Number)-3.0, (Number)3.0);
        Assert.assertTrue((boolean)accessor.hasAnyElevation(Arrays.asList(rangeBelow)));
        NumberRange rangeAbove = new NumberRange(Double.class, (Number)17.0, (Number)23.0);
        Assert.assertTrue((boolean)accessor.hasAnyElevation(Arrays.asList(rangeAbove)));
        Assert.assertFalse((boolean)accessor.hasAnyElevation(Arrays.asList(-3.0)));
        Assert.assertFalse((boolean)accessor.hasAnyElevation(Arrays.asList(5.0)));
        Assert.assertFalse((boolean)accessor.hasAnyElevation(Arrays.asList(23.0)));
        NumberRange rangeBefore = new NumberRange(Double.class, (Number)-3.0, (Number)-1.0);
        Assert.assertFalse((boolean)accessor.hasAnyElevation(Arrays.asList(rangeBefore)));
        NumberRange rangeMid = new NumberRange(Double.class, (Number)5.0, (Number)7.0);
        Assert.assertFalse((boolean)accessor.hasAnyElevation(Arrays.asList(rangeMid)));
        NumberRange rangeAfter = new NumberRange(Double.class, (Number)23.0, (Number)27.0);
        Assert.assertFalse((boolean)accessor.hasAnyElevation(Arrays.asList(rangeAfter)));
    }

    static {
        DF.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    static class MockDimensionReader
    extends AbstractGridCoverage2DReader {
        Map<String, String> metadata = new HashMap<String, String>();

        MockDimensionReader() {
        }

        public Format getFormat() {
            return null;
        }

        public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
            return null;
        }

        public String[] getMetadataNames() {
            Set<String> keys = this.metadata.keySet();
            return keys.toArray(new String[keys.size()]);
        }

        public String getMetadataValue(String coverageName, String name) {
            return super.getMetadataValue(name);
        }

        public String getMetadataValue(String name) {
            return this.metadata.get(name);
        }
    }
}

