/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.CatalogVisitorAdapter;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.ModificationProxy;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.junit.Test;

public class ModificationProxyTest {
    @Test
    public void testRewrapNoProxyIdentity() throws Exception {
        TestBeanImpl bean = new TestBeanImpl("Mr. Bean", "Uhh", "Bean");
        TestBean result = (TestBean)ModificationProxy.rewrap((Object)bean, b -> b, TestBean.class);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.sameInstance((Object)bean));
    }

    @Test
    public void testRewrapNoProxyInnerChange() throws Exception {
        TestBeanImpl bean = new TestBeanImpl("Mr. Bean", "Uhh", "Bean");
        TestBeanImpl newBean = new TestBeanImpl("Johnny English", "Not", "Bond");
        TestBean result = (TestBean)ModificationProxy.rewrap((Object)bean, b -> newBean, TestBean.class);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.sameInstance((Object)newBean));
    }

    @Test
    public void testRewrapEmptyProxyIdentity() throws Exception {
        TestBeanImpl bean = new TestBeanImpl("Mr. Bean", "Uhh", "Bean");
        TestBean proxy = (TestBean)ModificationProxy.create((Object)bean, TestBean.class);
        TestBean result = (TestBean)ModificationProxy.rewrap((Object)proxy, b -> b, TestBean.class);
        MatcherAssert.assertThat((Object)result, ModificationProxyTest.modProxy(Matchers.sameInstance((Object)bean)));
        MatcherAssert.assertThat((Object)result.getValue(), (Matcher)Matchers.equalTo((Object)"Mr. Bean"));
        MatcherAssert.assertThat(result.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Uhh", "Bean"}));
    }

    @Test
    public void testRewrapChangedProxyIdentity() throws Exception {
        TestBeanImpl bean = new TestBeanImpl("Mr. Bean", "Uhh", "Bean");
        TestBean proxy = (TestBean)ModificationProxy.create((Object)bean, TestBean.class);
        proxy.setValue("Edmond Blackadder");
        proxy.setListValue(Arrays.asList("Cunning", "Plan"));
        TestBean result = (TestBean)ModificationProxy.rewrap((Object)proxy, b -> b, TestBean.class);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)proxy)));
        MatcherAssert.assertThat((Object)result, ModificationProxyTest.modProxy(Matchers.sameInstance((Object)bean)));
        MatcherAssert.assertThat((Object)result.getValue(), (Matcher)Matchers.equalTo((Object)"Edmond Blackadder"));
        MatcherAssert.assertThat(result.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Cunning", "Plan"}));
        MatcherAssert.assertThat((Object)bean.getValue(), (Matcher)Matchers.equalTo((Object)"Mr. Bean"));
        MatcherAssert.assertThat(bean.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Uhh", "Bean"}));
    }

    @Test
    public void testRewrapChangedProxyInnerChange() throws Exception {
        TestBeanImpl bean = new TestBeanImpl("Mr. Bean", "Uhh", "Bean");
        TestBeanImpl newBean = new TestBeanImpl("Johnny English", "Not", "Bond");
        TestBean proxy = (TestBean)ModificationProxy.create((Object)bean, TestBean.class);
        proxy.setValue("Edmond Blackadder");
        proxy.setListValue(Arrays.asList("Cunning", "Plan"));
        TestBean result = (TestBean)ModificationProxy.rewrap((Object)proxy, b -> newBean, TestBean.class);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)proxy)));
        MatcherAssert.assertThat((Object)result, ModificationProxyTest.modProxy(Matchers.sameInstance((Object)newBean)));
        MatcherAssert.assertThat((Object)result.getValue(), (Matcher)Matchers.equalTo((Object)"Edmond Blackadder"));
        MatcherAssert.assertThat(result.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Cunning", "Plan"}));
        MatcherAssert.assertThat((Object)bean.getValue(), (Matcher)Matchers.equalTo((Object)"Mr. Bean"));
        MatcherAssert.assertThat(bean.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Uhh", "Bean"}));
        MatcherAssert.assertThat((Object)newBean.getValue(), (Matcher)Matchers.equalTo((Object)"Johnny English"));
        MatcherAssert.assertThat(newBean.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Not", "Bond"}));
    }

    @Test
    public void testRewrapEmptyProxyInnerChange() throws Exception {
        TestBeanImpl bean = new TestBeanImpl("Mr. Bean", "Uhh", "Bean");
        TestBeanImpl newBean = new TestBeanImpl("Johnny English", "Not", "Bond");
        TestBean proxy = (TestBean)ModificationProxy.create((Object)bean, TestBean.class);
        TestBean result = (TestBean)ModificationProxy.rewrap((Object)proxy, b -> newBean, TestBean.class);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)proxy)));
        MatcherAssert.assertThat((Object)result, ModificationProxyTest.modProxy(Matchers.sameInstance((Object)newBean)));
        MatcherAssert.assertThat((Object)result.getValue(), (Matcher)Matchers.equalTo((Object)"Johnny English"));
        MatcherAssert.assertThat(result.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Not", "Bond"}));
        MatcherAssert.assertThat((Object)bean.getValue(), (Matcher)Matchers.equalTo((Object)"Mr. Bean"));
        MatcherAssert.assertThat(bean.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Uhh", "Bean"}));
        MatcherAssert.assertThat((Object)newBean.getValue(), (Matcher)Matchers.equalTo((Object)"Johnny English"));
        MatcherAssert.assertThat(newBean.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Not", "Bond"}));
    }

    @Test
    public void testRewrapCommitToNew() throws Exception {
        TestBeanImpl bean = new TestBeanImpl("Mr. Bean", "Uhh", "Bean");
        TestBeanImpl newBean = new TestBeanImpl("Johnny English", "Not", "Bond");
        TestBean proxy = (TestBean)ModificationProxy.create((Object)bean, TestBean.class);
        proxy.setValue("Edmond Blackadder");
        proxy.setListValue(Arrays.asList("Cunning", "Plan"));
        TestBean result = (TestBean)ModificationProxy.rewrap((Object)proxy, b -> newBean, TestBean.class);
        ModificationProxy.handler((Object)result).commit();
        MatcherAssert.assertThat((Object)bean.getValue(), (Matcher)Matchers.equalTo((Object)"Mr. Bean"));
        MatcherAssert.assertThat(bean.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Uhh", "Bean"}));
        MatcherAssert.assertThat((Object)newBean.getValue(), (Matcher)Matchers.equalTo((Object)"Edmond Blackadder"));
        MatcherAssert.assertThat(newBean.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Cunning", "Plan"}));
    }

    @Test
    public void testCatalogVisitorCalledWithProxyObject() {
        CatalogFactory factory = new CatalogImpl().getFactory();
        this.testCatalogVisitor(factory.createNamespace(), NamespaceInfo.class);
        this.testCatalogVisitor(factory.createWorkspace(), WorkspaceInfo.class);
        this.testCatalogVisitor(factory.createCoverageStore(), CoverageStoreInfo.class);
        this.testCatalogVisitor(factory.createDataStore(), DataStoreInfo.class);
        this.testCatalogVisitor(factory.createWebMapServer(), WMSStoreInfo.class);
        this.testCatalogVisitor(factory.createWebMapTileServer(), WMTSStoreInfo.class);
        this.testCatalogVisitor(factory.createCoverage(), CoverageInfo.class);
        this.testCatalogVisitor(factory.createFeatureType(), FeatureTypeInfo.class);
        this.testCatalogVisitor(factory.createWMSLayer(), WMSLayerInfo.class);
        this.testCatalogVisitor(factory.createWMTSLayer(), WMTSLayerInfo.class);
        this.testCatalogVisitor(factory.createLayer(), LayerInfo.class);
        this.testCatalogVisitor(factory.createLayerGroup(), LayerGroupInfo.class);
        this.testCatalogVisitor(factory.createStyle(), StyleInfo.class);
    }

    private <T extends CatalogInfo> void testCatalogVisitor(T info, Class<T> type) {
        CatalogInfo proxy = (CatalogInfo)ModificationProxy.create(info, type);
        CatalogInfo visited = this.visitAndCapture(proxy, type);
        MatcherAssert.assertThat((Object)visited, (Matcher)Matchers.sameInstance((Object)proxy));
    }

    private <T extends CatalogInfo> T visitAndCapture(T proxy, Class<T> type) {
        final AtomicReference captured = new AtomicReference();
        CatalogVisitorAdapter visitor = new CatalogVisitorAdapter(){

            public void visit(WorkspaceInfo workspace) {
                captured.set(workspace);
            }

            public void visit(NamespaceInfo namespace) {
                captured.set(namespace);
            }

            public void visit(DataStoreInfo dataStore) {
                captured.set(dataStore);
            }

            public void visit(CoverageStoreInfo coverageStore) {
                captured.set(coverageStore);
            }

            public void visit(WMSStoreInfo wmsStore) {
                captured.set(wmsStore);
            }

            public void visit(WMTSStoreInfo wmtsStore) {
                captured.set(wmtsStore);
            }

            public void visit(FeatureTypeInfo featureType) {
                captured.set(featureType);
            }

            public void visit(CoverageInfo coverage) {
                captured.set(coverage);
            }

            public void visit(WMSLayerInfo wmsLayer) {
                captured.set(wmsLayer);
            }

            public void visit(WMTSLayerInfo wmtsLayer) {
                captured.set(wmtsLayer);
            }

            public void visit(LayerInfo layer) {
                captured.set(layer);
            }

            public void visit(StyleInfo style) {
                captured.set(style);
            }

            public void visit(LayerGroupInfo layerGroup) {
                captured.set(layerGroup);
            }
        };
        proxy.accept((CatalogVisitor)visitor);
        return (T)((CatalogInfo)type.cast(captured.get()));
    }

    public static <T> Matcher<T> modProxy(final Matcher<T> objectMatcher) {
        return new BaseMatcher<T>(){

            public boolean matches(Object item) {
                ModificationProxy handler = ModificationProxy.handler((Object)item);
                if (handler == null) {
                    return false;
                }
                return objectMatcher.matches(handler.getProxyObject());
            }

            public void describeTo(Description description) {
                description.appendText("ModificationProxy wrapping ").appendDescriptionOf((SelfDescribing)objectMatcher);
            }
        };
    }

    static class TestBeanImpl
    implements TestBean {
        String value;
        List<String> listValue;

        public TestBeanImpl(String value, List<String> listValue) {
            this.value = value;
            this.listValue = new ArrayList<String>(listValue);
        }

        public TestBeanImpl(String value, String ... listValues) {
            this(value, Arrays.asList(listValues));
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public List<String> getListValue() {
            return this.listValue;
        }

        @Override
        public void setListValue(List<String> listValue) {
            this.listValue = listValue;
        }
    }

    static interface TestBean {
        public String getValue();

        public void setValue(String var1);

        public List<String> getListValue();

        public void setListValue(List<String> var1);
    }
}

