/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.LocalWorkspaceCatalog;
import org.geoserver.catalog.util.CloseableIteratorAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.SettingsInfo;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.security.decorators.SecuredLayerGroupInfo;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.feature.NameImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalWorkspaceCatalogTest {
    LocalWorkspaceCatalog catalog;

    @Before
    public void setUp() throws Exception {
        WorkspaceInfo ws1 = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        EasyMock.expect((Object)ws1.getName()).andReturn((Object)"ws1").anyTimes();
        EasyMock.replay((Object[])new Object[]{ws1});
        NamespaceInfo ns1 = (NamespaceInfo)EasyMock.createNiceMock(NamespaceInfo.class);
        EasyMock.expect((Object)ns1.getPrefix()).andReturn((Object)"ws1").anyTimes();
        EasyMock.expect((Object)ns1.getURI()).andReturn((Object)"ws1").anyTimes();
        EasyMock.replay((Object[])new Object[]{ns1});
        WorkspaceInfo ws2 = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        EasyMock.expect((Object)ws2.getName()).andReturn((Object)"ws2").anyTimes();
        EasyMock.replay((Object[])new Object[]{ws2});
        NamespaceInfo ns2 = (NamespaceInfo)EasyMock.createNiceMock(NamespaceInfo.class);
        EasyMock.expect((Object)ns2.getPrefix()).andReturn((Object)"ws2").anyTimes();
        EasyMock.expect((Object)ns2.getURI()).andReturn((Object)"ws2").anyTimes();
        EasyMock.replay((Object[])new Object[]{ns2});
        StyleInfo s1 = (StyleInfo)EasyMock.createNiceMock(StyleInfo.class);
        EasyMock.expect((Object)s1.getName()).andReturn((Object)"s1").anyTimes();
        EasyMock.expect((Object)s1.getWorkspace()).andReturn((Object)ws1).anyTimes();
        EasyMock.replay((Object[])new Object[]{s1});
        StyleInfo s2 = (StyleInfo)EasyMock.createNiceMock(StyleInfo.class);
        EasyMock.expect((Object)s2.getName()).andReturn((Object)"s2").anyTimes();
        EasyMock.expect((Object)s2.getWorkspace()).andReturn((Object)ws2).anyTimes();
        EasyMock.replay((Object[])new Object[]{s2});
        LayerGroupInfo lg1 = (LayerGroupInfo)EasyMock.createNiceMock(LayerGroupInfo.class);
        EasyMock.expect((Object)lg1.getName()).andReturn((Object)"lg1").anyTimes();
        EasyMock.expect((Object)lg1.getWorkspace()).andReturn((Object)ws1).anyTimes();
        EasyMock.replay((Object[])new Object[]{lg1});
        SecuredLayerGroupInfo slg1 = new SecuredLayerGroupInfo(lg1, null, Collections.emptyList(), Collections.emptyList());
        LayerGroupInfo lg2 = (LayerGroupInfo)EasyMock.createNiceMock(LayerGroupInfo.class);
        EasyMock.expect((Object)lg2.getName()).andReturn((Object)"lg2").anyTimes();
        EasyMock.expect((Object)lg2.getWorkspace()).andReturn((Object)ws2).anyTimes();
        EasyMock.replay((Object[])new Object[]{lg2});
        FeatureTypeInfo ft1 = (FeatureTypeInfo)EasyMock.createNiceMock(FeatureTypeInfo.class);
        EasyMock.expect((Object)ft1.getName()).andReturn((Object)"l1").anyTimes();
        EasyMock.expect((Object)ft1.getNamespace()).andReturn((Object)ns1).anyTimes();
        EasyMock.replay((Object[])new Object[]{ft1});
        LayerInfo l1 = (LayerInfo)EasyMock.createNiceMock(LayerInfo.class);
        EasyMock.expect((Object)l1.getName()).andReturn((Object)"ws1:l1").anyTimes();
        EasyMock.expect((Object)l1.getResource()).andReturn((Object)ft1).anyTimes();
        EasyMock.replay((Object[])new Object[]{l1});
        FeatureTypeInfo ft2 = (FeatureTypeInfo)EasyMock.createNiceMock(FeatureTypeInfo.class);
        EasyMock.expect((Object)ft2.getName()).andReturn((Object)"l2").anyTimes();
        EasyMock.expect((Object)ft2.getNamespace()).andReturn((Object)ns2).anyTimes();
        EasyMock.replay((Object[])new Object[]{ft2});
        LayerInfo l2 = (LayerInfo)EasyMock.createNiceMock(LayerInfo.class);
        EasyMock.expect((Object)l2.getName()).andReturn((Object)"ws2:l2").anyTimes();
        EasyMock.expect((Object)l2.getResource()).andReturn((Object)ft2).anyTimes();
        EasyMock.replay((Object[])new Object[]{l2});
        LayerInfo lc1 = (LayerInfo)EasyMock.createNiceMock(LayerInfo.class);
        EasyMock.expect((Object)lc1.getName()).andReturn((Object)"ws1:lc").anyTimes();
        EasyMock.expect((Object)lc1.getResource()).andReturn((Object)ft1).anyTimes();
        EasyMock.replay((Object[])new Object[]{lc1});
        LayerInfo lc2 = (LayerInfo)EasyMock.createNiceMock(LayerInfo.class);
        EasyMock.expect((Object)lc2.getName()).andReturn((Object)"ws2:lc").anyTimes();
        EasyMock.expect((Object)lc2.getResource()).andReturn((Object)ft2).anyTimes();
        EasyMock.replay((Object[])new Object[]{lc2});
        Catalog cat = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)cat.getWorkspaces()).andReturn(Arrays.asList(ws1, ws2)).anyTimes();
        EasyMock.expect((Object)cat.getWorkspaceByName("ws1")).andReturn((Object)ws1).anyTimes();
        EasyMock.expect((Object)cat.getWorkspaceByName("ws2")).andReturn((Object)ws2).anyTimes();
        EasyMock.expect((Object)cat.getNamespaceByPrefix("ws1")).andReturn((Object)ns1).anyTimes();
        EasyMock.expect((Object)cat.getNamespaceByPrefix("ws2")).andReturn((Object)ns2).anyTimes();
        EasyMock.expect((Object)cat.getStyleByName("ws1", "s1")).andReturn((Object)s1).anyTimes();
        EasyMock.expect((Object)cat.getStyleByName(ws1, "s1")).andReturn((Object)s1).anyTimes();
        EasyMock.expect((Object)cat.getStyleByName("s1")).andReturn(null).anyTimes();
        EasyMock.expect((Object)cat.getStyleByName("ws2", "s2")).andReturn((Object)s1).anyTimes();
        EasyMock.expect((Object)cat.getStyleByName(ws2, "s2")).andReturn((Object)s1).anyTimes();
        EasyMock.expect((Object)cat.getStyleByName("s2")).andReturn(null).anyTimes();
        EasyMock.expect((Object)cat.getLayerGroupByName("ws1", "lg1")).andReturn((Object)lg1).anyTimes();
        EasyMock.expect((Object)cat.getLayerGroupByName("ws1", "slg1")).andReturn((Object)slg1).anyTimes();
        EasyMock.expect((Object)cat.getLayerGroupByName(ws1, "lg1")).andReturn((Object)lg1).anyTimes();
        EasyMock.expect((Object)cat.getLayerGroupByName("ws1:lg1")).andReturn((Object)lg1).anyTimes();
        EasyMock.expect((Object)cat.getLayerGroupByName("ws1:slg1")).andReturn((Object)lg1).anyTimes();
        EasyMock.expect((Object)cat.getLayerGroupByName("lg1")).andReturn(null).anyTimes();
        EasyMock.expect((Object)cat.getLayerGroupByName("slg1")).andReturn(null).anyTimes();
        EasyMock.expect((Object)cat.getLayerGroupByName("ws2", "lg2")).andReturn((Object)lg2).anyTimes();
        EasyMock.expect((Object)cat.getLayerGroupByName(ws2, "lg2")).andReturn((Object)lg2).anyTimes();
        EasyMock.expect((Object)cat.getLayerGroupByName("ws2:lg2")).andReturn((Object)lg2).anyTimes();
        EasyMock.expect((Object)cat.getLayerGroupByName("lg2")).andReturn(null).anyTimes();
        EasyMock.expect((Object)cat.getLayerByName((Name)new NameImpl("ws1", "l1"))).andReturn((Object)l1).anyTimes();
        EasyMock.expect((Object)cat.getLayerByName("l1")).andReturn(null).anyTimes();
        EasyMock.expect((Object)cat.getLayerByName((Name)new NameImpl("ws2", "l2"))).andReturn((Object)l2).anyTimes();
        EasyMock.expect((Object)cat.getLayerByName("l2")).andReturn(null).anyTimes();
        EasyMock.expect((Object)cat.getLayerByName((Name)new NameImpl("ws1", "lc"))).andReturn((Object)lc1).anyTimes();
        EasyMock.expect((Object)cat.getLayerByName((Name)new NameImpl("ws2", "lc"))).andReturn((Object)lc2).anyTimes();
        EasyMock.expect((Object)cat.getLayerByName("lc")).andReturn((Object)lc1).anyTimes();
        ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>(2);
        layers.add(l1);
        layers.add(l2);
        layers.add(lc1);
        layers.add(lc2);
        EasyMock.expect((Object)cat.getLayers()).andReturn(layers).anyTimes();
        ArrayList layers2 = new ArrayList(layers);
        layers2.add(null);
        EasyMock.expect((Object)cat.list(LayerInfo.class, (Filter)Filter.INCLUDE, null, null, null)).andReturn((Object)new CloseableIteratorAdapter(layers2.iterator())).anyTimes();
        EasyMock.replay((Object[])new Object[]{cat});
        this.catalog = new LocalWorkspaceCatalog(cat);
    }

    @After
    public void tearDown() {
        LocalWorkspace.remove();
    }

    @Test
    public void testGetStyleByName() throws Exception {
        Assert.assertNull((Object)this.catalog.getStyleByName("s1"));
        Assert.assertNull((Object)this.catalog.getStyleByName("s2"));
        WorkspaceInfo ws1 = this.catalog.getWorkspaceByName("ws1");
        WorkspaceInfo ws2 = this.catalog.getWorkspaceByName("ws2");
        LocalWorkspace.set((WorkspaceInfo)ws1);
        Assert.assertNotNull((Object)this.catalog.getStyleByName("s1"));
        Assert.assertNull((Object)this.catalog.getStyleByName("s2"));
        LocalWorkspace.remove();
        Assert.assertNull((Object)this.catalog.getStyleByName("s1"));
        Assert.assertNull((Object)this.catalog.getStyleByName("s2"));
        LocalWorkspace.set((WorkspaceInfo)ws2);
        Assert.assertNull((Object)this.catalog.getStyleByName("s1"));
        Assert.assertNotNull((Object)this.catalog.getStyleByName("s2"));
        LocalWorkspace.remove();
        Assert.assertNull((Object)this.catalog.getStyleByName("s1"));
        Assert.assertNull((Object)this.catalog.getStyleByName("s2"));
    }

    @Test
    public void testGetLayerGroupByName() throws Exception {
        Assert.assertNull((Object)this.catalog.getLayerGroupByName("lg1"));
        Assert.assertNull((Object)this.catalog.getLayerGroupByName("lg2"));
        WorkspaceInfo ws1 = this.catalog.getWorkspaceByName("ws1");
        WorkspaceInfo ws2 = this.catalog.getWorkspaceByName("ws2");
        LocalWorkspace.set((WorkspaceInfo)ws1);
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName("lg1"));
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName("ws1:lg1"));
        Assert.assertNull((Object)this.catalog.getLayerGroupByName("lg2"));
        LayerGroupInfo slg1 = this.catalog.getLayerGroupByName("slg1");
        Assert.assertNotNull((Object)slg1);
        MatcherAssert.assertThat((Object)slg1, (Matcher)CoreMatchers.instanceOf(LayerGroupInfo.class));
        LocalWorkspace.remove();
        Assert.assertNull((Object)this.catalog.getLayerGroupByName("lg1"));
        Assert.assertNull((Object)this.catalog.getLayerGroupByName("lg2"));
        LocalWorkspace.set((WorkspaceInfo)ws2);
        Assert.assertNull((Object)this.catalog.getLayerGroupByName("lg1"));
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName("ws2:lg2"));
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName("lg2"));
        LocalWorkspace.remove();
        Assert.assertNull((Object)this.catalog.getLayerGroupByName("lg1"));
        Assert.assertNull((Object)this.catalog.getLayerGroupByName("lg2"));
    }

    @Test
    public void testGetLayerByName() throws Exception {
        Assert.assertNull((Object)this.catalog.getLayerByName("l1"));
        Assert.assertNull((Object)this.catalog.getLayerByName("l2"));
        WorkspaceInfo ws1 = this.catalog.getWorkspaceByName("ws1");
        WorkspaceInfo ws2 = this.catalog.getWorkspaceByName("ws2");
        LocalWorkspace.set((WorkspaceInfo)ws1);
        Assert.assertNotNull((Object)this.catalog.getLayerByName("l1"));
        Assert.assertNull((Object)this.catalog.getLayerByName("l2"));
        LocalWorkspace.remove();
        LocalWorkspace.set((WorkspaceInfo)ws2);
        Assert.assertNull((Object)this.catalog.getLayerByName("l1"));
        Assert.assertNotNull((Object)this.catalog.getLayerByName("l2"));
        LocalWorkspace.remove();
        Assert.assertNull((Object)this.catalog.getLayerByName("l1"));
        Assert.assertNull((Object)this.catalog.getLayerByName("l2"));
    }

    @Test
    public void testGetLayersWithSameName() throws Exception {
        LayerInfo layerInfo1 = this.catalog.getLayerByName((Name)new NameImpl("ws1", "lc"));
        ResourceInfo resource1 = layerInfo1.getResource();
        NamespaceInfo namespace1 = resource1.getNamespace();
        String nsPrefix1 = namespace1.getPrefix();
        LayerInfo layerInfo2 = this.catalog.getLayerByName((Name)new NameImpl("ws2", "lc"));
        ResourceInfo resource2 = layerInfo2.getResource();
        NamespaceInfo namespace2 = resource2.getNamespace();
        String nsPrefix2 = namespace2.getPrefix();
        Assert.assertEquals((String)"Invalid namespace prefix", (Object)"ws1", (Object)nsPrefix1);
        Assert.assertEquals((String)"Invalid namespace prefix", (Object)"ws2", (Object)nsPrefix2);
    }

    @Test
    public void testGetNonPrefixedLayerNames() {
        boolean includePrefix = false;
        boolean setLocalWorkspace = true;
        boolean createGeoServer = true;
        this.assertPrefixInclusion(includePrefix, setLocalWorkspace, createGeoServer);
    }

    @Test
    public void testGetNoGeoserverPrefixedLayerNameBehaviour() {
        boolean includePrefix = false;
        boolean setLocalWorkspace = true;
        boolean createGeoServer = false;
        this.assertPrefixInclusion(includePrefix, setLocalWorkspace, createGeoServer);
    }

    @Test
    public void testGetNoGeoserverLocalWorkspacePrefixedLayerNameBehaviour() {
        boolean includePrefix = true;
        boolean setLocalWorkspace = false;
        boolean createGeoServer = false;
        this.assertPrefixInclusion(includePrefix, setLocalWorkspace, createGeoServer);
    }

    @Test
    public void testGetNoLocalWorkspacePrefixedLayerNameBehaviour() {
        boolean includePrefix = true;
        boolean setLocalWorkspace = false;
        boolean createGeoServer = true;
        this.assertPrefixInclusion(includePrefix, setLocalWorkspace, createGeoServer);
    }

    @Test
    public void testGetPrefixedLayerNames() {
        boolean includePrefix = true;
        boolean setLocalWorkspace = true;
        boolean createGeoServer = true;
        this.assertPrefixInclusion(includePrefix, setLocalWorkspace, createGeoServer);
    }

    private void assertPrefixInclusion(boolean includePrefix, boolean setLocalWorkspace, boolean createGeoServer) {
        if (createGeoServer) {
            SettingsInfo settings = (SettingsInfo)EasyMock.createNiceMock(SettingsInfo.class);
            EasyMock.expect((Object)settings.isLocalWorkspaceIncludesPrefix()).andReturn((Object)includePrefix).anyTimes();
            EasyMock.replay((Object[])new Object[]{settings});
            GeoServer geoServer = (GeoServer)EasyMock.createNiceMock(GeoServer.class);
            EasyMock.expect((Object)geoServer.getSettings()).andReturn((Object)settings).anyTimes();
            EasyMock.replay((Object[])new Object[]{geoServer});
            this.catalog.setGeoServer(geoServer);
        }
        if (setLocalWorkspace) {
            WorkspaceInfo workspaceByName = this.catalog.getWorkspaceByName("ws1");
            LocalWorkspace.set((WorkspaceInfo)workspaceByName);
        }
        this.checkLayerNamePrefixInclusion(includePrefix, this.catalog.getLayers().iterator());
        this.checkLayerNamePrefixInclusion(includePrefix, (Iterator<LayerInfo>)this.catalog.list(LayerInfo.class, (Filter)Filter.INCLUDE));
    }

    private void checkLayerNamePrefixInclusion(boolean includePrefix, Iterator<LayerInfo> layers) {
        while (layers.hasNext()) {
            LayerInfo layerInfo = layers.next();
            if (layerInfo == null) continue;
            String message = includePrefix ? layerInfo.getName() + " should contain a : because the prefix should have been kept" : layerInfo.getName() + " should contain not a : because the prefix should have been removed";
            Assert.assertEquals((String)message, (Object)includePrefix, (Object)layerInfo.getName().contains(":"));
        }
    }
}

