/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.catalog.impl.LayerGroupStyleImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class LayerGroupStyleListenerTest
extends GeoServerSystemTestSupport {
    @Test
    public void testContainedLayerGroupStyleNameChangeOnUpdate() throws Exception {
        this.buildLayerGroup("testStyleRenaming", LayerGroupInfo.Mode.OPAQUE_CONTAINER);
        LayerGroupInfo groupInfo = this.getCatalog().getLayerGroupByName("testStyleRenaming");
        LayerGroupStyleImpl groupStyle = new LayerGroupStyleImpl();
        StyleInfoImpl styleName = new StyleInfoImpl(this.getCatalog());
        styleName.setName("changeGroupStyle");
        groupStyle.setName((StyleInfo)styleName);
        groupStyle.getStyles().add(this.getCatalog().getStyleByName("BasicPolygons"));
        groupStyle.getLayers().add(this.getCatalog().getLayerByName("cite:BasicPolygons"));
        groupInfo.getLayerGroupStyles().add(groupStyle);
        this.getCatalog().save(groupInfo);
        this.buildLayerGroup("testStyleRenamingContainer", LayerGroupInfo.Mode.SINGLE);
        LayerGroupInfo container = this.getCatalog().getLayerGroupByName("testStyleRenamingContainer");
        LayerGroupStyleImpl containerStyle = new LayerGroupStyleImpl();
        StyleInfoImpl containerStyleName = new StyleInfoImpl(this.getCatalog());
        containerStyleName.setName("containerStyle");
        containerStyle.setName((StyleInfo)containerStyleName);
        containerStyle.getStyles().add(styleName);
        containerStyle.getLayers().add(groupInfo);
        container.getLayerGroupStyles().add(containerStyle);
        this.getCatalog().save(container);
        this.buildLayerGroup("testStyleRenamingContainer2", LayerGroupInfo.Mode.OPAQUE_CONTAINER);
        LayerGroupInfo container2 = this.getCatalog().getLayerGroupByName(container.prefixedName());
        container2.getLayers().add(groupInfo);
        container2.getStyles().add(styleName);
        this.getCatalog().save(container2);
        StyleInfo name = (StyleInfo)((LayerGroupStyle)container.getLayerGroupStyles().get(0)).getStyles().get(0);
        Assert.assertEquals((Object)"changeGroupStyle", (Object)name.getName());
        name = (StyleInfo)container2.getStyles().get(1);
        Assert.assertEquals((Object)"changeGroupStyle", (Object)name.getName());
        groupInfo = this.getCatalog().getLayerGroupByName(groupInfo.prefixedName());
        ((LayerGroupStyle)groupInfo.getLayerGroupStyles().get(0)).getName().setName("changed");
        this.getCatalog().save(groupInfo);
        container = this.getCatalog().getLayerGroupByName(container.prefixedName());
        name = (StyleInfo)((LayerGroupStyle)container.getLayerGroupStyles().get(0)).getStyles().get(0);
        Assert.assertEquals((Object)"changed", (Object)name.getName());
        container2 = this.getCatalog().getLayerGroupByName(container2.prefixedName());
        name = (StyleInfo)container2.getStyles().get(1);
        Assert.assertEquals((Object)"changed", (Object)name.getName());
    }

    private void buildLayerGroup(String groupName, LayerGroupInfo.Mode mode) throws Exception {
        Catalog catalog = this.getCatalog();
        String lakes = MockData.BASIC_POLYGONS.getLocalPart();
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.setName(groupName);
        lg.setMode(mode);
        lg.getLayers().add(catalog.getLayerByName(lakes));
        CatalogBuilder builder = new CatalogBuilder(catalog);
        builder.calculateLayerGroupBounds(lg);
        catalog.add(lg);
    }
}

