/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.Collections;
import java.util.Locale;
import java.util.function.Consumer;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geotools.api.util.InternationalString;
import org.geotools.util.GrowableInternationalString;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FeatureTypeInfoImplTest {
    Catalog catalog;

    @Before
    public void setUp() throws Exception {
        GeoServerExtensionsHelper.setIsSpringContext(false);
        this.catalog = new CatalogImpl();
    }

    @Test
    public void testEqualsWithAttributes() {
        CatalogFactory factory = this.catalog.getFactory();
        FeatureTypeInfoImpl ft1 = (FeatureTypeInfoImpl)factory.createFeatureType();
        FeatureTypeInfoImpl ft2 = (FeatureTypeInfoImpl)factory.createFeatureType();
        ft1.setName("featureType");
        ft2.setName("featureType");
        AttributeTypeInfo at1 = factory.createAttribute();
        AttributeTypeInfo at2 = factory.createAttribute();
        at1.setName("attribute");
        at2.setName("attribute");
        at1.setFeatureType((FeatureTypeInfo)ft1);
        at2.setFeatureType((FeatureTypeInfo)ft2);
        ft1.setAttributes(Collections.singletonList(at1));
        ft2.setAttributes(Collections.singletonList(at2));
        Assert.assertEquals((Object)ft1, (Object)ft2);
        Assert.assertEquals((Object)at1.getName(), (Object)at1.getSource());
        Assert.assertEquals((Object)at1.getSource(), (Object)at2.getSource());
        Assert.assertEquals((Object)at1, (Object)at2);
        Assert.assertEquals((long)at1.hashCode(), (long)at2.hashCode());
        at1.setSource(at1.getSource());
        Assert.assertEquals((Object)at1, (Object)at2);
        Assert.assertEquals((long)at1.hashCode(), (long)at2.hashCode());
        Assert.assertTrue((boolean)at1.isNillable());
        Assert.assertTrue((boolean)at2.isNillable());
        at1.setNillable(true);
        Assert.assertEquals((Object)at1, (Object)at2);
        Assert.assertEquals((long)at1.hashCode(), (long)at2.hashCode());
    }

    @Test
    public void testI18nSetters() {
        CatalogFactory factory = this.catalog.getFactory();
        FeatureTypeInfoImpl ft1 = (FeatureTypeInfoImpl)factory.createFeatureType();
        ft1.setAbstract("test");
        ft1.setInternationalAbstract(null);
        Assert.assertNull((Object)ft1.getInternationalAbstract());
        ft1.setInternationalTitle(null);
        Assert.assertNull((Object)ft1.getInternationalTitle());
    }

    @Test
    public void testEqualityI18nTitle() throws Exception {
        FeatureTypeInfoImpl f1 = new FeatureTypeInfoImpl();
        FeatureTypeInfoImpl f2 = new FeatureTypeInfoImpl();
        Consumer<FeatureTypeInfoImpl> initer = f -> {
            GrowableInternationalString title = new GrowableInternationalString("default language");
            title.add(Locale.ITALIAN, "lingua italiana");
            f.setInternationalTitle((InternationalString)title);
        };
        initer.accept(f1);
        initer.accept(f2);
        Assert.assertEquals((Object)f1, (Object)f2);
    }

    @Test
    public void testEqualityI18nAbstract() throws Exception {
        FeatureTypeInfoImpl f1 = new FeatureTypeInfoImpl();
        FeatureTypeInfoImpl f2 = new FeatureTypeInfoImpl();
        Consumer<FeatureTypeInfoImpl> initer = f -> {
            GrowableInternationalString abs = new GrowableInternationalString("default language");
            abs.add(Locale.ITALIAN, "lingua italiana");
            f.setInternationalAbstract((InternationalString)abs);
        };
        initer.accept(f1);
        initer.accept(f2);
        Assert.assertEquals((Object)f1, (Object)f2);
    }
}

