/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.io.IOException;
import java.util.List;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CascadeVisitorAbstractTest;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.catalog.impl.LayerGroupStyleImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geotools.api.filter.Filter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class CascadeDeleteVisitorTest
extends CascadeVisitorAbstractTest {
    @After
    public void resetChanges() throws IOException {
        LayerGroupInfo group;
        this.revertLayer(CiteTestData.LAKES);
        this.revertLayer(CiteTestData.BRIDGES);
        this.revertLayer(CiteTestData.FORESTS);
        this.revertLayer(CiteTestData.BUILDINGS);
        Catalog catalog = this.getCatalog();
        StyleInfo style = catalog.getStyleByName("wsStyle");
        if (style != null) {
            catalog.remove(style);
        }
        if ((group = catalog.getLayerGroupByName("nestGroup")) != null) {
            catalog.remove(group);
        }
        if ((group = catalog.getLayerGroupByName("lakesGroup")) != null) {
            catalog.remove(group);
        }
        this.setupExtras((SystemTestData)this.getTestData(), catalog);
    }

    @Test
    public void testCascadeLayer() {
        Catalog catalog = this.getCatalog();
        String name = this.toString(CiteTestData.LAKES);
        LayerInfo layer = catalog.getLayerByName(name);
        Assert.assertNotNull((Object)layer);
        CascadeDeleteVisitor visitor = new CascadeDeleteVisitor(catalog);
        visitor.visit(layer);
        LayerGroupInfo group = catalog.getLayerGroupByName("lakesGroup");
        Assert.assertEquals((long)2L, (long)group.getLayers().size());
        Assert.assertFalse((boolean)group.getLayers().contains(layer));
    }

    @Test
    public void testCascadeLayerGroup() {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo layerGroup = catalog.getLayerGroupByName("lakesGroup");
        Assert.assertNotNull((Object)layerGroup);
        CascadeDeleteVisitor visitor = new CascadeDeleteVisitor(catalog);
        visitor.visit(layerGroup);
        LayerGroupInfo nestedGroup = catalog.getLayerGroupByName("nestGroup");
        Assert.assertNotNull((Object)nestedGroup);
        Assert.assertEquals((long)1L, (long)nestedGroup.getLayers().size());
        Assert.assertEquals((long)1L, (long)nestedGroup.getStyles().size());
    }

    @Test
    public void testCascadeLayerDuplicate() {
        Catalog catalog = this.getCatalog();
        String name = this.toString(CiteTestData.LAKES);
        LayerInfo layer = catalog.getLayerByName(name);
        Assert.assertNotNull((Object)layer);
        LayerGroupInfo group = catalog.getLayerGroupByName("lakesGroup");
        group.getLayers().add(layer);
        group.getStyles().add(null);
        catalog.save(group);
        CascadeDeleteVisitor visitor = new CascadeDeleteVisitor(catalog);
        visitor.visit(layer);
        group = catalog.getLayerGroupByName("lakesGroup");
        Assert.assertEquals((long)2L, (long)group.getLayers().size());
        Assert.assertFalse((boolean)group.getLayers().contains(layer));
    }

    @Test
    public void testCascadeStore() {
        Catalog catalog = this.getCatalog();
        DataStoreInfo store = (DataStoreInfo)catalog.getLayerByName(this.getLayerId(CiteTestData.LAKES)).getResource().getStore();
        new CascadeDeleteVisitor(catalog).visit(store);
        Assert.assertEquals((long)0L, (long)catalog.count(LayerInfo.class, (Filter)Filter.INCLUDE));
        Assert.assertEquals((long)0L, (long)catalog.count(ResourceInfo.class, (Filter)Filter.INCLUDE));
        Assert.assertEquals((long)0L, (long)catalog.count(StoreInfo.class, (Filter)Filter.INCLUDE));
        Assert.assertEquals((long)0L, (long)catalog.count(LayerGroupInfo.class, (Filter)Filter.INCLUDE));
    }

    @Test
    public void testCascadeWorkspace() {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo ws = catalog.getWorkspaceByName(CiteTestData.CITE_PREFIX);
        new CascadeDeleteVisitor(catalog).visit(ws);
        Assert.assertNull((Object)catalog.getNamespaceByPrefix(CiteTestData.CITE_PREFIX));
        Assert.assertEquals((long)0L, (long)catalog.count(LayerInfo.class, (Filter)Filter.INCLUDE));
        Assert.assertEquals((long)0L, (long)catalog.count(ResourceInfo.class, (Filter)Filter.INCLUDE));
        Assert.assertEquals((long)0L, (long)catalog.count(StoreInfo.class, (Filter)Filter.INCLUDE));
        Assert.assertEquals((long)0L, (long)catalog.count(LayerGroupInfo.class, (Filter)Filter.INCLUDE));
        Assert.assertEquals((long)0L, (long)catalog.getStylesByWorkspace(CiteTestData.CITE_PREFIX).size());
        Assert.assertNull((Object)catalog.getStyleByName("wsStyle"));
    }

    @Test
    public void testCascadeStyle() {
        Catalog catalog = this.getCatalog();
        StyleInfo style = catalog.getStyleByName(CiteTestData.LAKES.getLocalPart());
        Assert.assertNotNull((Object)style);
        new CascadeDeleteVisitor(catalog).visit(style);
        Assert.assertNull((Object)catalog.getStyleByName(CiteTestData.LAKES.getLocalPart()));
        LayerInfo layer = catalog.getLayerByName(this.getLayerId(CiteTestData.LAKES));
        Assert.assertEquals((Object)"polygon", (Object)layer.getDefaultStyle().getName());
    }

    @Test
    public void testCascadeLayerInGroupStyles() {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = catalog.getLayerGroupByName("lakesGroup");
        LayerGroupStyleImpl groupStyle = new LayerGroupStyleImpl();
        StyleInfoImpl groupStyleName = new StyleInfoImpl(catalog);
        groupStyleName.setName("cascadeDeleteTest");
        groupStyle.setName((StyleInfo)groupStyleName);
        String name = this.toString(CiteTestData.LAKES);
        String bridges = this.toString(CiteTestData.BRIDGES);
        LayerInfo layer = catalog.getLayerByName(name);
        Assert.assertNotNull((Object)layer);
        groupStyle.getLayers().add(layer);
        LayerInfo bridgesLi = catalog.getLayerByName(bridges);
        groupStyle.getLayers().add(bridgesLi);
        groupStyle.getStyles().add(null);
        groupStyle.getStyles().add(null);
        group.getLayerGroupStyles().add(groupStyle);
        catalog.save(group);
        CascadeDeleteVisitor visitor = new CascadeDeleteVisitor(catalog);
        visitor.visit(layer);
        group = catalog.getLayerGroupByName("lakesGroup");
        List styleLayers = ((LayerGroupStyle)group.getLayerGroupStyles().get(0)).getLayers();
        Assert.assertEquals((long)1L, (long)styleLayers.size());
        Assert.assertEquals((Object)bridgesLi, styleLayers.get(0));
        visitor.visit(bridgesLi);
        group = catalog.getLayerGroupByName("lakesGroup");
        Assert.assertEquals((long)0L, (long)group.getLayerGroupStyles().size());
    }

    @Test
    public void testCascadeStylesInLayerGroupStyles() {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = catalog.getLayerGroupByName("lakesGroup");
        LayerGroupStyleImpl groupStyle = new LayerGroupStyleImpl();
        StyleInfoImpl groupStyleName = new StyleInfoImpl(catalog);
        groupStyleName.setName("cascadeDeleteTest");
        groupStyle.setName((StyleInfo)groupStyleName);
        String name = this.toString(CiteTestData.LAKES);
        LayerInfo layer = catalog.getLayerByName(name);
        StyleInfo lakeStyle = catalog.getStyleByName("wsStyle");
        layer.getStyles().add(lakeStyle);
        catalog.save(layer);
        layer = catalog.getLayerByName(name);
        Assert.assertNotNull((Object)layer);
        groupStyle.getLayers().add(layer);
        groupStyle.getLayers().add(layer);
        groupStyle.getStyles().add(lakeStyle);
        groupStyle.getStyles().add(lakeStyle);
        group.getLayerGroupStyles().add(groupStyle);
        catalog.save(group);
        CascadeDeleteVisitor visitor = new CascadeDeleteVisitor(catalog);
        visitor.visit(lakeStyle);
        group = catalog.getLayerGroupByName("lakesGroup");
        List styleLayers = ((LayerGroupStyle)group.getLayerGroupStyles().get(0)).getStyles();
        Assert.assertEquals((long)2L, (long)styleLayers.size());
        Assert.assertEquals((Object)CiteTestData.LAKES.getLocalPart(), (Object)((StyleInfo)styleLayers.get(0)).getName());
        Assert.assertEquals((Object)CiteTestData.LAKES.getLocalPart(), (Object)((StyleInfo)styleLayers.get(0)).getName());
    }
}

