/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.TransformFeatureTypeCallback;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.util.InternationalString;
import org.geotools.util.SimpleInternationalString;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransformFeatureTypeCallbackTest
extends GeoServerSystemTestSupport {
    private static final String BOOLEAN_PROPERTY = "booleanProperty";
    private TransformFeatureTypeCallback transformer;
    private Catalog catalog;
    FeatureTypeInfo fti;
    SimpleFeatureSource notWrappedFs;

    @Before
    public void setUp() throws Exception {
        this.transformer = new TransformFeatureTypeCallback();
        this.catalog = this.getCatalog();
        this.fti = this.catalog.getFeatureTypeByName(this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE));
        this.notWrappedFs = (SimpleFeatureSource)this.fti.getFeatureSource(null, null);
    }

    @Test
    public void testForDescription() throws Exception {
        SimpleFeatureType notWrappedSchema = (SimpleFeatureType)this.notWrappedFs.getSchema();
        Assert.assertNull((Object)notWrappedSchema.getDescriptor(BOOLEAN_PROPERTY).getType().getDescription());
        List<AttributeTypeInfo> filteredAttributes = this.fti.attributes().stream().map(at -> {
            if (BOOLEAN_PROPERTY.equals(at.getName())) {
                at.setDescription((InternationalString)new SimpleInternationalString("A boolean property"));
            }
            return at;
        }).collect(Collectors.toList());
        SimpleFeatureType wrappedSchema = this.getWrappedFeatureType(this.notWrappedFs, filteredAttributes);
        Assert.assertEquals((Object)"A boolean property", (Object)wrappedSchema.getDescriptor(BOOLEAN_PROPERTY).getType().getDescription().toString());
    }

    @Test
    public void testBlankDescriptionIsNull() throws Exception {
        List<AttributeTypeInfo> filteredAttributes = this.fti.attributes().stream().map(at -> {
            if (BOOLEAN_PROPERTY.equals(at.getName())) {
                at.setDescription((InternationalString)new SimpleInternationalString(""));
            }
            return at;
        }).collect(Collectors.toList());
        SimpleFeatureType wrappedSchema = this.getWrappedFeatureType(this.notWrappedFs, filteredAttributes);
        Assert.assertNull((Object)wrappedSchema.getDescriptor(BOOLEAN_PROPERTY).getType().getDescription());
    }

    private SimpleFeatureType getWrappedFeatureType(SimpleFeatureSource notWrappedFs, List<AttributeTypeInfo> filteredAttributes) throws IOException {
        FeatureTypeInfoImpl resource = new FeatureTypeInfoImpl(null);
        resource.setName("alias");
        resource.setAttributes(filteredAttributes);
        SimpleFeatureSource wrappedFs = (SimpleFeatureSource)this.transformer.wrapFeatureSource((FeatureTypeInfo)resource, (FeatureSource)notWrappedFs);
        SimpleFeatureType wrappedSchema = (SimpleFeatureType)wrappedFs.getSchema();
        return wrappedSchema;
    }
}

