/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ValidationException;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FeatureTypeCustomizationTest
extends GeoServerSystemTestSupport {
    private static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    private static final Filter ID_03 = FF.id(new FeatureId[]{FF.featureId("PrimitiveGeoFeature.f003")});
    private static final String BOOLEAN_PROPERTY = "booleanProperty";
    private static final String CURVE_PROPERTY = "curveProperty";
    private static final String TRUE_OR_FALSE = "trueOrFalse";

    @Before
    public void resetFeatureTypes() throws IOException {
        this.revertLayer(CiteTestData.PRIMITIVEGEOFEATURE);
    }

    @Test
    public void testHideAttributes() throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE));
        HashSet<String> exclude = new HashSet<String>(Arrays.asList(CURVE_PROPERTY, "uriProperty"));
        List filteredAttributes = fti.attributes().stream().filter(at -> !exclude.contains(at.getName())).collect(Collectors.toList());
        fti.getAttributes().clear();
        fti.getAttributes().addAll(filteredAttributes);
        catalog.save((ResourceInfo)fti);
        FeatureType schema = fti.getFeatureType();
        Assert.assertNull((Object)schema.getDescriptor(CURVE_PROPERTY));
        Assert.assertNotNull((Object)schema.getDescriptor("name"));
        SimpleFeatureSource fs = (SimpleFeatureSource)fti.getFeatureSource(null, null);
        Assert.assertEquals((Object)fs.getSchema(), (Object)schema);
        SimpleFeature feature = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures(ID_03));
        Assert.assertNull((Object)feature.getAttribute(CURVE_PROPERTY));
        Assert.assertEquals((Object)"name-f003", (Object)feature.getAttribute("name"));
        MatcherAssert.assertThat((Object)fs, (Matcher)CoreMatchers.instanceOf(SimpleFeatureStore.class));
    }

    @Test
    public void testChangeBinding() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE));
        List filteredAttributes = fti.attributes().stream().map(at -> {
            if (BOOLEAN_PROPERTY.equals(at.getName())) {
                at.setBinding(String.class);
            }
            return at;
        }).collect(Collectors.toList());
        fti.getAttributes().clear();
        fti.getAttributes().addAll(filteredAttributes);
        catalog.save((ResourceInfo)fti);
        FeatureType schema = fti.getFeatureType();
        Assert.assertNotNull((Object)schema.getDescriptor(CURVE_PROPERTY));
        PropertyDescriptor booleanProperty = schema.getDescriptor(BOOLEAN_PROPERTY);
        Assert.assertNotNull((Object)booleanProperty);
        Assert.assertEquals(String.class, (Object)booleanProperty.getType().getBinding());
        SimpleFeatureSource fs = (SimpleFeatureSource)fti.getFeatureSource(null, null);
        Assert.assertEquals((Object)fs.getSchema(), (Object)schema);
        SimpleFeature feature = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures(ID_03));
        Assert.assertNotNull((Object)feature.getAttribute(CURVE_PROPERTY));
        Assert.assertEquals((Object)"name-f003", (Object)feature.getAttribute("name"));
        Assert.assertEquals((Object)"true", (Object)feature.getAttribute(BOOLEAN_PROPERTY));
        MatcherAssert.assertThat((Object)fs, (Matcher)CoreMatchers.instanceOf(SimpleFeatureStore.class));
    }

    @Test
    public void testRename() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE));
        List filteredAttributes = fti.attributes().stream().map(at -> {
            if (BOOLEAN_PROPERTY.equals(at.getName())) {
                at.setName(TRUE_OR_FALSE);
                at.setSource(BOOLEAN_PROPERTY);
            }
            return at;
        }).collect(Collectors.toList());
        fti.getAttributes().clear();
        fti.getAttributes().addAll(filteredAttributes);
        catalog.save((ResourceInfo)fti);
        FeatureType schema = fti.getFeatureType();
        Assert.assertNull((Object)schema.getDescriptor(BOOLEAN_PROPERTY));
        PropertyDescriptor trueFalseProperty = schema.getDescriptor(TRUE_OR_FALSE);
        Assert.assertNotNull((Object)trueFalseProperty);
        Assert.assertEquals(Boolean.class, (Object)trueFalseProperty.getType().getBinding());
        SimpleFeatureSource fs = (SimpleFeatureSource)fti.getFeatureSource(null, null);
        Assert.assertEquals((Object)fs.getSchema(), (Object)schema);
        SimpleFeature feature = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures(ID_03));
        Assert.assertEquals((Object)"name-f003", (Object)feature.getAttribute("name"));
        Assert.assertNull((Object)feature.getAttribute(BOOLEAN_PROPERTY));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)feature.getAttribute(TRUE_OR_FALSE));
        MatcherAssert.assertThat((Object)fs, (Matcher)CoreMatchers.instanceOf(SimpleFeatureStore.class));
    }

    @Test
    public void testExpression() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE));
        ArrayList<AttributeTypeInfo> attributes = new ArrayList<AttributeTypeInfo>(fti.attributes());
        AttributeTypeInfo prefixedNameAttribute = catalog.getFactory().createAttribute();
        String PREFIXED_NAME = "prefixedName";
        prefixedNameAttribute.setName("prefixedName");
        prefixedNameAttribute.setSource("Concatenate('gs-', name)");
        attributes.add(prefixedNameAttribute);
        fti.getAttributes().clear();
        fti.getAttributes().addAll(attributes);
        catalog.save((ResourceInfo)fti);
        FeatureType schema = fti.getFeatureType();
        PropertyDescriptor prefixedProperty = schema.getDescriptor("prefixedName");
        Assert.assertNotNull((Object)prefixedProperty);
        Assert.assertEquals(String.class, (Object)prefixedProperty.getType().getBinding());
        SimpleFeatureSource fs = (SimpleFeatureSource)fti.getFeatureSource(null, null);
        Assert.assertEquals((Object)fs.getSchema(), (Object)schema);
        SimpleFeature feature = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures(ID_03));
        Assert.assertEquals((Object)"name-f003", (Object)feature.getAttribute("name"));
        Assert.assertEquals((Object)"gs-name-f003", (Object)feature.getAttribute("prefixedName"));
        PropertyIsEqualTo filter = FF.equals((Expression)FF.property("prefixedName"), (Expression)FF.literal((Object)"gs-name-f003"));
        SimpleFeature filteredFeature = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures((Filter)filter));
        Assert.assertEquals((Object)"name-f003", (Object)filteredFeature.getAttribute("name"));
        MatcherAssert.assertThat((Object)fs, (Matcher)CoreMatchers.instanceOf(SimpleFeatureStore.class));
    }

    @Test
    public void testDuplicateAttributes() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE));
        ArrayList<AttributeTypeInfo> attributes = new ArrayList<AttributeTypeInfo>(fti.attributes());
        AttributeTypeInfo duplicate = catalog.getFactory().createAttribute();
        String name = ((AttributeTypeInfo)attributes.get(0)).getName();
        duplicate.setName(name);
        attributes.add(duplicate);
        fti.getAttributes().clear();
        fti.getAttributes().addAll(attributes);
        try {
            catalog.save((ResourceInfo)fti);
        }
        catch (ValidationException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"multiple definitions"), CoreMatchers.containsString((String)"description")}));
        }
    }

    @Test
    public void testInvalidCQL() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE));
        ArrayList<AttributeTypeInfo> attributes = new ArrayList<AttributeTypeInfo>(fti.attributes());
        AttributeTypeInfo wrongExpression = catalog.getFactory().createAttribute();
        wrongExpression.setName("wrongCQL");
        wrongExpression.setSource("Concatenate(name, 'incomplete)");
        attributes.add(wrongExpression);
        fti.getAttributes().clear();
        fti.getAttributes().addAll(attributes);
        try {
            catalog.save((ResourceInfo)fti);
        }
        catch (ValidationException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Invalid CQL"));
        }
    }

    @Test
    public void testAttributeNotFound() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE));
        ArrayList<AttributeTypeInfo> attributes = new ArrayList<AttributeTypeInfo>(fti.attributes());
        AttributeTypeInfo attributeNotThere = catalog.getFactory().createAttribute();
        attributeNotThere.setName("test");
        attributeNotThere.setSource("Concatenate(one, two, 'suffix')");
        attributes.add(attributeNotThere);
        fti.getAttributes().clear();
        fti.getAttributes().addAll(attributes);
        try {
            catalog.save((ResourceInfo)fti);
        }
        catch (ValidationException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"attributes unavailable"), CoreMatchers.containsString((String)"one, two")}));
        }
    }

    @Test
    public void testInvalidConversion() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE));
        ArrayList attributes = new ArrayList(fti.attributes());
        ((AttributeTypeInfo)attributes.get(0)).setBinding(MyOddBinding.class);
        fti.getAttributes().clear();
        fti.getAttributes().addAll(attributes);
        try {
            catalog.save((ResourceInfo)fti);
        }
        catch (ValidationException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"unable to convert"), CoreMatchers.containsString((String)"java.lang.String"), CoreMatchers.containsString((String)"$MyOddBinding")}));
        }
    }

    private final class MyOddBinding {
        private MyOddBinding() {
        }
    }
}

