/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.IsolatedWorkspacesTest;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ows.LocalWorkspace;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public final class CatalogIsolatedWorkspacesTest
extends IsolatedWorkspacesTest {
    @Test
    public void addWorkspacesWithSameNamespace() {
        this.createWorkspace("test_a1", "https://www.test_a.com", false);
        this.executeAndValidateException(() -> this.createWorkspace("test_a1", "https://www.test_a.com", false), IllegalArgumentException.class, "Namespace with prefix 'test_a1' already exists");
        this.executeAndValidateException(() -> this.createWorkspace("test_a2", "https://www.test_a.com", false), IllegalArgumentException.class, "Namespace with URI 'https://www.test_a.com' already exists.");
        this.createWorkspace("test_a3", "https://www.test_a.com", true);
    }

    @Test
    public void retrievingNamespacesFromCatalog() {
        Catalog catalog = this.getCatalog();
        this.createWorkspace("test_b1", "https://www.test_b.com", true);
        this.checkNamespace(catalog.getNamespaceByPrefix("test_b1"), "test_b1", "https://www.test_b.com", true);
        MatcherAssert.assertThat((Object)catalog.getNamespaceByURI("https://www.test_b.com"), (Matcher)Matchers.nullValue());
        this.createWorkspace("test_b2", "https://www.test_b.com", false);
        this.checkWorkspace(catalog.getWorkspaceByName("test_b1"), "test_b1", true);
        this.checkWorkspace(catalog.getWorkspaceByName("test_b2"), "test_b2", false);
        this.checkNamespace(catalog.getNamespaceByPrefix("test_b1"), "test_b1", "https://www.test_b.com", true);
        this.checkNamespace(catalog.getNamespaceByPrefix("test_b2"), "test_b2", "https://www.test_b.com", false);
        this.checkNamespace(catalog.getNamespaceByURI("https://www.test_b.com"), "test_b2", "https://www.test_b.com", false);
    }

    @Test
    public void retrievingNamespacesFromCatalogInVirtualService() {
        Catalog catalog = this.getCatalog();
        this.createWorkspace("test_c1", "https://www.test_c.com", true);
        this.createWorkspace("test_c2", "https://www.test_c.com", false);
        this.checkNamespace(catalog.getNamespaceByURI("https://www.test_c.com"), "test_c2", "https://www.test_c.com", false);
        WorkspaceInfo workspace = catalog.getWorkspaceByName("test_c1");
        MatcherAssert.assertThat((Object)workspace, (Matcher)Matchers.notNullValue());
        LocalWorkspace.set((WorkspaceInfo)workspace);
        this.checkNamespace(catalog.getNamespaceByURI("https://www.test_c.com"), "test_c1", "https://www.test_c.com", true);
    }

    @Test
    public void updateWorkspacesIsolation() {
        this.createWorkspace("test_d1", "https://www.test_d.com", true);
        this.createWorkspace("test_d2", "https://www.test_d.com", true);
        this.updateWorkspaceIsolationState("test_d1", false);
        this.executeAndValidateException(() -> this.updateWorkspaceIsolationState("test_d2", false), IllegalArgumentException.class, "Namespace with URI 'https://www.test_d.com' already exists");
        this.updateWorkspaceIsolationState("test_d1", true);
        this.updateWorkspaceIsolationState("test_d2", false);
    }

    @Test
    public void retrieveLayersFromIsolatedWorkspace() {
        Catalog catalog = this.getCatalog();
        this.createWorkspace("test_e1", "https://www.test_e.com", false);
        this.createWorkspace("test_e2", "https://www.test_e.com", true);
        WorkspaceInfo workspace1 = catalog.getWorkspaceByName("test_e1");
        NamespaceInfo namespace1 = catalog.getNamespaceByPrefix("test_e1");
        WorkspaceInfo workspace2 = catalog.getWorkspaceByName("test_e2");
        NamespaceInfo namespace2 = catalog.getNamespaceByPrefix("test_e2");
        LayerInfo clonedLayer1 = this.cloneVectorLayerIntoWorkspace(workspace1, namespace1, "Lines", "layer_e");
        LayerInfo clonedLayer2 = this.cloneVectorLayerIntoWorkspace(workspace2, namespace2, "Points", "layer_e");
        MatcherAssert.assertThat((Object)clonedLayer1.getId(), (Matcher)Matchers.not((Object)clonedLayer2.getId()));
        LayerInfo layer1 = catalog.getLayerByName("test_e1:layer_e");
        MatcherAssert.assertThat((Object)layer1, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)layer1.getId(), (Matcher)Matchers.is((Object)clonedLayer1.getId()));
        LayerInfo layer2 = catalog.getLayerByName("test_e3:layer_e");
        MatcherAssert.assertThat((Object)layer2, (Matcher)Matchers.nullValue());
    }
}

