/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.CascadeRemovalReporter;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.ResourcePoolTest;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.config.GeoServerConfigPersister;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.decorators.SecuredLayerGroupInfo;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.SystemTest;
import org.geoserver.test.TestSetup;
import org.geoserver.test.TestSetupFrequency;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.Version;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.locationtech.jts.geom.Point;
import org.springframework.context.ApplicationContext;

@Category(value={SystemTest.class})
@TestSetup(run=TestSetupFrequency.REPEAT)
public class CatalogIntegrationTest
extends GeoServerSystemTestSupport {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        File root;
        File defaultWorkspace;
        super.setUpTestData(testData);
        testData.setUpDefaultRasterLayers();
        GeoServerExtensions extension = (GeoServerExtensions)GeoServerExtensions.bean(GeoServerExtensions.class);
        if (extension == null) {
            GeoServerExtensionsHelper.init((ApplicationContext)applicationContext);
        }
        if ((defaultWorkspace = new File(root = testData.getDataDirectoryRoot(), "workspaces/default.xml")).exists()) {
            defaultWorkspace.delete();
        }
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws IOException {
        Catalog catalog = this.getCatalog();
        testData.addStyle("singleStyleGroup", "singleStyleGroup.sld", CatalogIntegrationTest.class, catalog);
        testData.addStyle("multiStyleGroup", "multiStyleGroup.sld", CatalogIntegrationTest.class, catalog);
        testData.addStyle("recursiveStyleGroup", "recursiveStyleGroup.sld", CatalogIntegrationTest.class, catalog);
        testData.addStyle("relative", "se_relativepath.sld", ResourcePoolTest.class, catalog);
        StyleInfo style = catalog.getStyleByName("relative");
        style.setFormatVersion(new Version("1.1.0"));
        catalog.save(style);
        File images = new File(testData.getDataDirectoryRoot(), "styles/images");
        Assert.assertTrue((boolean)images.mkdir());
        File image = new File("./src/test/resources/org/geoserver/catalog/rockFillSymbol.png");
        Assert.assertTrue((boolean)image.exists());
        FileUtils.copyFileToDirectory((File)image, (File)images);
        File svg = new File("./src/test/resources/org/geoserver/catalog/square16.svg");
        Assert.assertTrue((boolean)svg.exists());
        FileUtils.copyFileToDirectory((File)svg, (File)images);
        CatalogFactory factory = catalog.getFactory();
        WorkspaceInfo secondaryWs = factory.createWorkspace();
        secondaryWs.setName("secondary");
        NamespaceInfo secondaryNs = factory.createNamespace();
        secondaryNs.setPrefix("secondary");
        secondaryNs.setURI("http://www.geoserver.org/secondary");
        catalog.add(secondaryWs);
        catalog.add(secondaryNs);
    }

    @Test
    public void testWorkspaceRemoveAndReadd() {
        Catalog catalog = this.getCatalog();
        NamespaceInfo defaultNamespace = catalog.getDefaultNamespace();
        WorkspaceInfo defaultWs = catalog.getDefaultWorkspace();
        List workspaces = catalog.getWorkspaces();
        CascadeDeleteVisitor visitor = new CascadeDeleteVisitor(catalog);
        for (WorkspaceInfo ws : workspaces) {
            visitor.visit(ws);
        }
        Assert.assertEquals((long)0L, (long)catalog.getWorkspaces().size());
        Assert.assertEquals((long)0L, (long)catalog.getNamespaces().size());
        catalog.add(defaultNamespace);
        catalog.add(defaultWs);
        Assert.assertEquals((long)1L, (long)catalog.getWorkspaces().size());
        Assert.assertEquals((long)1L, (long)catalog.getNamespaces().size());
        Assert.assertNotNull((Object)catalog.getNamespaceByURI(defaultNamespace.getURI()));
    }

    @Test
    public void testNamespaceWorkspaceListenerAttached() throws Exception {
        Catalog catalog = this.getCatalog();
        NamespaceInfo ns = catalog.getNamespaceByPrefix(MockData.CITE_PREFIX);
        String newName = "XYWZ1234";
        ns.setPrefix(newName);
        catalog.save(ns);
        Assert.assertNotNull((Object)catalog.getWorkspaceByName(newName));
        Assert.assertNotNull((Object)catalog.getNamespaceByPrefix(newName));
        int listenersBefore = catalog.getListeners().size();
        this.getGeoServer().reload();
        int listenersAfter = catalog.getListeners().size();
        Assert.assertEquals((long)listenersBefore, (long)listenersAfter);
        ns = catalog.getNamespaceByPrefix(newName);
        ns.setPrefix(MockData.CITE_PREFIX);
        catalog.save(ns);
        Assert.assertNotNull((Object)catalog.getWorkspaceByName(MockData.CITE_PREFIX));
        int countCleaner = 0;
        int countPersister = 0;
        for (CatalogListener listener : catalog.getListeners()) {
            if (listener instanceof ResourcePool.CacheClearingListener) {
                ++countCleaner;
                continue;
            }
            if (!(listener instanceof GeoServerConfigPersister)) continue;
            ++countPersister;
        }
        Assert.assertEquals((long)1L, (long)countCleaner);
        Assert.assertEquals((long)1L, (long)countPersister);
    }

    @Test
    public void modificationProxySerializeTest() throws Exception {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo ws = catalog.getWorkspaceByName(MockData.CITE_PREFIX);
        WorkspaceInfo ws2 = this.serialize(ws);
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)ws), (Object)ModificationProxy.unwrap((Object)ws2));
        NamespaceInfo ns = catalog.getNamespaceByPrefix(MockData.CITE_PREFIX);
        NamespaceInfo ns2 = this.serialize(ns);
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)ns), (Object)ModificationProxy.unwrap((Object)ns2));
        DataStoreInfo ds = catalog.getDataStoreByName(MockData.CITE_PREFIX);
        DataStoreInfo ds2 = this.serialize(ds);
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)ds), (Object)ModificationProxy.unwrap((Object)ds2));
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)ds.getWorkspace()), (Object)ModificationProxy.unwrap((Object)ds2.getWorkspace()));
        CoverageStoreInfo cs = catalog.getCoverageStoreByName(MockData.TASMANIA_DEM.getLocalPart());
        CoverageStoreInfo cs2 = this.serialize(cs);
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)cs), (Object)ModificationProxy.unwrap((Object)cs2));
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)cs.getWorkspace()), (Object)ModificationProxy.unwrap((Object)cs2.getWorkspace()));
        FeatureTypeInfo ft = catalog.getFeatureTypeByName(this.getLayerId(MockData.BRIDGES));
        FeatureTypeInfo ft2 = this.serialize(ft);
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)ft), (Object)ModificationProxy.unwrap((Object)ft2));
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)ft.getStore()), (Object)ModificationProxy.unwrap((Object)ft2.getStore()));
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        CoverageInfo ci2 = this.serialize(ci);
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)ci), (Object)ModificationProxy.unwrap((Object)ci2));
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)ci.getStore()), (Object)ModificationProxy.unwrap((Object)ci.getStore()));
        StyleInfo streamsStyle = catalog.getStyleByName("Streams");
        StyleInfo si2 = this.serialize(streamsStyle);
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)streamsStyle), (Object)ModificationProxy.unwrap((Object)si2));
        LayerInfo li = catalog.getLayerByName(this.getLayerId(MockData.BRIDGES));
        li.getStyles().add(streamsStyle);
        catalog.save(li);
        LayerInfo li2 = this.serialize(li);
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)li), (Object)ModificationProxy.unwrap((Object)li2));
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)li.getResource()), (Object)ModificationProxy.unwrap((Object)li2.getResource()));
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)li.getDefaultStyle()), (Object)ModificationProxy.unwrap((Object)li2.getDefaultStyle()));
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)((StyleInfo)li.getStyles().iterator().next())), (Object)ModificationProxy.unwrap((Object)((StyleInfo)li2.getStyles().iterator().next())));
        CatalogBuilder cb = new CatalogBuilder(catalog);
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.getLayers().add(catalog.getLayerByName(this.getLayerId(MockData.ROAD_SEGMENTS)));
        lg.getLayers().add(catalog.getLayerByName(this.getLayerId(MockData.PONDS)));
        lg.getStyles().add(null);
        lg.getStyles().add(null);
        cb.calculateLayerGroupBounds(lg);
        lg.setName("test-lg");
        catalog.add(lg);
        lg = catalog.getLayerGroupByName("test-lg");
        if (lg instanceof SecuredLayerGroupInfo) {
            lg = (LayerGroupInfo)((SecuredLayerGroupInfo)lg).unwrap(LayerGroupInfo.class);
        }
        LayerGroupInfo lg2 = this.serialize(lg);
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)lg), (Object)ModificationProxy.unwrap((Object)lg2));
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)((PublishedInfo)lg.getLayers().get(0))), (Object)ModificationProxy.unwrap((Object)((PublishedInfo)lg2.getLayers().get(0))));
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)((PublishedInfo)lg.getLayers().get(1))), (Object)ModificationProxy.unwrap((Object)((PublishedInfo)lg2.getLayers().get(1))));
        LayerInfo lim = catalog.getLayerByName(this.getLayerId(MockData.BRIDGES));
        lim.setDefaultStyle(streamsStyle);
        lim.getStyles().add(streamsStyle);
        LayerInfo lim2 = this.serialize(lim);
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)lim.getDefaultStyle()), (Object)ModificationProxy.unwrap((Object)lim2.getDefaultStyle()));
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)((StyleInfo)lim.getStyles().iterator().next())), (Object)ModificationProxy.unwrap((Object)((StyleInfo)lim2.getStyles().iterator().next())));
        String key = "workspaceKey";
        lim.getMetadata().put(key, (Serializable)ws);
        LayerInfo lim3 = this.serialize(lim);
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)lim), (Object)ModificationProxy.unwrap((Object)lim3));
        Assert.assertSame((Object)ModificationProxy.unwrap((Object)lim.getMetadata().get((Object)key)), (Object)ModificationProxy.unwrap((Object)lim3.getMetadata().get((Object)key)));
    }

    <T> T serialize(T object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(object);
        oos.close();
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        Object cast = ois.readObject();
        return (T)cast;
    }

    @Test
    public void testCascadeDeleteWorkspaceSpecific() throws Exception {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo ws = catalog.getWorkspaceByName(MockData.ROAD_SEGMENTS.getPrefix());
        CatalogBuilder cb = new CatalogBuilder(catalog);
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.getLayers().add(catalog.getLayerByName(this.getLayerId(MockData.ROAD_SEGMENTS)));
        lg.getLayers().add(catalog.getLayerByName(this.getLayerId(MockData.STREAMS)));
        lg.getStyles().add(null);
        lg.getStyles().add(null);
        cb.calculateLayerGroupBounds(lg);
        lg.setName("test-lg");
        lg.setWorkspace(ws);
        catalog.add(lg);
        StyleInfo style = catalog.getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart());
        style.setWorkspace(ws);
        catalog.save(style);
        CascadeRemovalReporter reporter = new CascadeRemovalReporter(catalog);
        ws.accept((CatalogVisitor)reporter);
        List styles = reporter.getObjects(StyleInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE});
        Assert.assertEquals((long)1L, (long)styles.size());
        Assert.assertEquals((Object)style, styles.get(0));
        List groups = reporter.getObjects(LayerGroupInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE});
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)lg, groups.get(0));
        CascadeDeleteVisitor remover = new CascadeDeleteVisitor(catalog);
        ws.accept((CatalogVisitor)remover);
        Assert.assertNull((Object)catalog.getWorkspaceByName(ws.getName()));
        Assert.assertNull((Object)catalog.getStyleByName(style.getName()));
        Assert.assertNull((Object)catalog.getLayerGroupByName(lg.getName()));
    }

    @Test
    public void testReprojectLayerGroup() throws NoSuchAuthorityCodeException, FactoryException, Exception {
        Catalog catalog = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(catalog);
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        LayerInfo l = catalog.getLayerByName(this.getLayerId(MockData.ROAD_SEGMENTS));
        lg.getLayers().add(l);
        lg.getStyles().add(null);
        lg.setName("test-reproject");
        String wkt = "GEOGCS[\"GCS_ATF_Paris\",DATUM[\"D_ATF\",SPHEROID[\"Plessis_1817\",6376523.0,308.64]],PRIMEM[\"Paris\",2.337229166666667],UNIT[\"Grad\",0.01570796326794897]]";
        CoordinateReferenceSystem lCrs = CRS.parseWKT((String)wkt);
        l.getResource().setSRS(null);
        l.getResource().setNativeCRS(lCrs);
        Assert.assertNull((Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)lCrs, (boolean)false));
        CoordinateReferenceSystem lgCrs = CRS.decode((String)"EPSG:4901");
        Assert.assertNotNull((Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)lgCrs, (boolean)false));
        cb.calculateLayerGroupBounds(lg, lgCrs);
        Assert.assertNotNull((Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)lg.getBounds().getCoordinateReferenceSystem(), (boolean)false));
    }

    @Test
    public void testLayerGroupNullLayerOrStyleReferences() throws IOException {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        LayerInfo l = catalog.getLayerByName(this.getLayerId(MockData.ROAD_SEGMENTS));
        StyleInfo s = catalog.getStyleByName("singleStyleGroup");
        lg.setWorkspace(null);
        lg.setName("threeTypeLayerGroup");
        lg.getLayers().add(l);
        lg.getStyles().add(null);
        lg.getLayers().add(null);
        lg.getStyles().add(s);
        lg.getLayers().add(null);
        lg.getStyles().add(null);
        catalog.add(lg);
        LayerGroupInfo resolved = catalog.getLayerGroupByName("threeTypeLayerGroup");
        Assert.assertEquals((long)2L, (long)resolved.layers().size());
        Assert.assertEquals((long)2L, (long)resolved.styles().size());
        Assert.assertEquals((Object)l, resolved.layers().get(0));
        Assert.assertEquals((Object)s.getStyle(), (Object)((StyleInfo)resolved.styles().get(1)).getStyle());
    }

    @Test
    public void testInvalidStyleGroup() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        StyleInfo s = catalog.getStyleByName("polygon");
        lg.setWorkspace(null);
        lg.setName("invalidStyleLayerGroup");
        lg.getLayers().add(null);
        lg.getStyles().add(s);
        try {
            catalog.add(lg);
            Assert.fail((String)"Should not be able to add an invalid style group to the catalog");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Invalid style group: No layer or layer group named 'Default Polygon' found in the catalog", (Object)e.getMessage());
        }
    }

    @Test
    public void testSingleStyleGroup() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        StyleInfo s = catalog.getStyleByName("singleStyleGroup");
        lg.setWorkspace(null);
        lg.setName("singleStyleLayerGroup");
        lg.getLayers().add(null);
        lg.getStyles().add(s);
        catalog.add(lg);
        LayerGroupInfo resolved = catalog.getLayerGroupByName("singleStyleLayerGroup");
        Assert.assertEquals((long)1L, (long)resolved.layers().size());
        Assert.assertEquals((long)1L, (long)resolved.styles().size());
        Assert.assertEquals((Object)s.getStyle(), (Object)((StyleInfo)resolved.styles().get(0)).getStyle());
        new LayerGroupHelper(lg).calculateBounds();
        Assert.assertEquals((Object)catalog.getLayerByName(this.getLayerId(MockData.STREAMS)).getResource().getLatLonBoundingBox(), (Object)lg.getBounds());
    }

    @Test
    public void testMultiStyleGroup() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        StyleInfo s = catalog.getStyleByName("multiStyleGroup");
        LayerGroupInfo nestedLg = catalog.getFactory().createLayerGroup();
        nestedLg.setName("nestedLayerGroup");
        nestedLg.getLayers().add(catalog.getLayerByName(this.getLayerId(MockData.PONDS)));
        nestedLg.getLayers().add(catalog.getLayerByName(this.getLayerId(MockData.BUILDINGS)));
        nestedLg.getStyles().add(null);
        nestedLg.getStyles().add(null);
        catalog.add(nestedLg);
        lg.setWorkspace(null);
        lg.setName("multiStyleLayerGroup");
        lg.getLayers().add(null);
        lg.getStyles().add(s);
        catalog.add(lg);
        LayerGroupInfo resolved = catalog.getLayerGroupByName("multiStyleLayerGroup");
        List layers = resolved.layers();
        List styles = resolved.styles();
        Assert.assertEquals((long)6L, (long)layers.size());
        Assert.assertEquals((long)6L, (long)styles.size());
        Assert.assertEquals((Object)catalog.getLayerByName(this.getLayerId(MockData.STREAMS)), layers.get(0));
        Assert.assertTrue((boolean)(((Rule)((FeatureTypeStyle)((StyleInfo)styles.get(0)).getStyle().featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0) instanceof LineSymbolizer));
        Assert.assertEquals((Object)catalog.getLayerByName(this.getLayerId(MockData.ROAD_SEGMENTS)), layers.get(1));
        Assert.assertTrue((boolean)(((Rule)((FeatureTypeStyle)((StyleInfo)styles.get(1)).getStyle().featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0) instanceof LineSymbolizer));
        Assert.assertEquals((Object)catalog.getLayerByName(this.getLayerId(MockData.ROAD_SEGMENTS)), layers.get(2));
        Assert.assertEquals((Object)catalog.getStyleByName("line").getStyle(), (Object)((StyleInfo)styles.get(2)).getStyle());
        Assert.assertEquals((Object)catalog.getLayerByName(this.getLayerId(MockData.PONDS)), layers.get(3));
        Assert.assertEquals((Object)catalog.getLayerByName(this.getLayerId(MockData.BUILDINGS)), layers.get(4));
        SimpleFeature inlineFeature = (SimpleFeature)((FeatureTypeInfo)((LayerInfo)layers.get(5)).getResource()).getFeatureSource(null, null).getFeatures().features().next();
        Assert.assertTrue((boolean)(inlineFeature.getDefaultGeometry() instanceof Point));
        Assert.assertEquals((Object)"POINT (115.741666667 -64.6583333333)", (Object)((Point)inlineFeature.getDefaultGeometry()).toText());
        Assert.assertTrue((boolean)(((Rule)((FeatureTypeStyle)((StyleInfo)styles.get(5)).getStyle().featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0) instanceof PointSymbolizer));
        new LayerGroupHelper(lg).calculateBounds();
        Assert.assertEquals((Object)new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), (Object)lg.getBounds());
    }

    @Test
    public void testRecursiveStyleGroup() throws IOException {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        StyleInfo s = catalog.getStyleByName("recursiveStyleGroup");
        lg.setWorkspace(null);
        lg.setName("recursiveLayerGroup");
        lg.getLayers().add(null);
        lg.getStyles().add(s);
        try {
            catalog.add(lg);
            Assert.fail((String)"Should not be able to add invalid layer group to catalog");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameWorspaceAfterReload() throws Exception {
        this.getGeoServer().reload();
        Catalog catalog = this.getCatalog();
        WorkspaceInfo ws = catalog.getDefaultWorkspace();
        String name = ws.getName();
        try {
            String newName = "renamed_" + name;
            ws.setName(newName);
            catalog.save(ws);
            WorkspaceInfo wsRenamed = this.getCatalog().getWorkspaceByName(newName);
            Assert.assertNotNull((Object)wsRenamed);
            Assert.assertEquals((Object)newName, (Object)wsRenamed.getName());
            NamespaceInfo nsRenamed = this.getCatalog().getNamespaceByPrefix(newName);
            Assert.assertNotNull((Object)nsRenamed);
            Assert.assertEquals((Object)newName, (Object)nsRenamed.getName());
            this.getGeoServer().reload();
            catalog = this.getCatalog();
            WorkspaceInfo wsRenamed2 = catalog.getWorkspaceByName(newName);
            Assert.assertNotNull((Object)wsRenamed2);
            Assert.assertEquals((Object)newName, (Object)wsRenamed.getName());
            NamespaceInfo nsRenamed2 = this.getCatalog().getNamespaceByPrefix(newName);
            Assert.assertNotNull((Object)nsRenamed2);
            Assert.assertEquals((Object)newName, (Object)nsRenamed2.getName());
            Assert.assertNull((Object)catalog.getWorkspaceByName(name));
        }
        finally {
            ws.setName(name);
            catalog.save(ws);
        }
    }

    @Test
    public void testReloadDefaultStyles() throws Exception {
        Resource styles = this.getDataDirectory().getStyles(new String[0]);
        styles.list().stream().filter(r -> r.getType() == Resource.Type.RESOURCE && r.name().contains("point")).forEach(r -> r.delete());
        this.getGeoServer().reload();
        StyleInfo point = this.getCatalog().getStyleByName("point");
        Assert.assertNotNull((Object)point);
    }

    @Test
    public void testChangeStyleWorkspaceRelativeResources() throws Exception {
        Catalog catalog = this.getCatalog();
        StyleInfo style = catalog.getStyleByName("relative");
        WorkspaceInfo secondaryWs = catalog.getWorkspaceByName("secondary");
        style.setWorkspace(secondaryWs);
        catalog.save(style);
        Resource relativeImage = this.getDataDirectory().getStyles(secondaryWs, new String[]{"images", "rockFillSymbol.png"});
        Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)relativeImage.getType());
        Resource relativeSvg = this.getDataDirectory().getStyles(secondaryWs, new String[]{"images", "square16.svg"});
        Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)relativeSvg.getType());
    }

    @Test
    public void testStyleMetadataMap() throws Exception {
        Catalog catalog = this.getCatalog();
        StyleInfo style = catalog.getStyleByName("Lakes");
        style.getMetadata().put("timeToLive", (Serializable)((Object)"500"));
        catalog.save(style);
        StyleInfo styletoCheck = catalog.getStyleByName("Lakes");
        Assert.assertEquals((long)1L, (long)styletoCheck.getMetadata().size());
        Assert.assertNotNull((Object)styletoCheck.getMetadata().get((Object)"timeToLive"));
        String timeToLive = (String)((Object)styletoCheck.getMetadata().get((Object)"timeToLive"));
        Assert.assertEquals((Object)"500", (Object)timeToLive);
    }

    @Test
    public void testStyleMetadataMapNotNull() throws Exception {
        Catalog catalog = this.getCatalog();
        StyleInfo styletoCheck = catalog.getStyleByName("relative");
        Assert.assertNotNull((Object)styletoCheck.getMetadata());
        Assert.assertEquals((long)0L, (long)styletoCheck.getMetadata().size());
    }

    @Test
    public void testStyleMetadataMapUpdates() throws Exception {
        this.setupInitialStyleToUpdate();
        Catalog catalog = this.getCatalog();
        StyleInfo styletoCheck = catalog.getStyleByName("Lakes");
        Assert.assertEquals((long)2L, (long)styletoCheck.getMetadata().size());
        styletoCheck.getMetadata().remove((Object)"timeToLive");
        catalog.save(styletoCheck);
        styletoCheck = catalog.getStyleByName("Lakes");
        Assert.assertEquals((long)1L, (long)styletoCheck.getMetadata().size());
        Assert.assertNull((Object)styletoCheck.getMetadata().get((Object)"timeToLive"));
    }

    private void setupInitialStyleToUpdate() {
        Catalog catalog = this.getCatalog();
        StyleInfo style = catalog.getStyleByName("Lakes");
        style.getMetadata().put("timeToLive", (Serializable)((Object)"500"));
        style.getMetadata().put("maxCacheEntries", (Serializable)((Object)"20"));
        catalog.save(style);
    }
}

