/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.util.Date;
import junit.framework.TestCase;
import org.geoserver.catalog.AcceptableRange;
import org.geotools.util.DateRange;
import org.junit.Test;

public class AcceptableRangeTest {
    public static final long DAY_IN_MS = 86400000L;

    @Test
    public void testSymmetricTimeRange() throws Exception {
        AcceptableRange range = AcceptableRange.getAcceptableRange((String)"P1D", Date.class);
        TestCase.assertEquals((Object)86400000L, (Object)range.getBefore());
        TestCase.assertEquals((Object)86400000L, (Object)range.getAfter());
        Date value = new Date();
        DateRange searchRange = (DateRange)range.getSearchRange((Object)value);
        TestCase.assertEquals((long)86400000L, (long)(value.getTime() - searchRange.getMinValue().getTime()));
        TestCase.assertEquals((long)86400000L, (long)(searchRange.getMaxValue().getTime() - value.getTime()));
    }

    @Test
    public void testPastTimeRange() throws Exception {
        AcceptableRange range = AcceptableRange.getAcceptableRange((String)"P1D/P0D", Date.class);
        TestCase.assertEquals((Object)86400000L, (Object)range.getBefore());
        TestCase.assertEquals((Object)0L, (Object)range.getAfter());
        Date value = new Date();
        DateRange searchRange = (DateRange)range.getSearchRange((Object)value);
        TestCase.assertEquals((long)86400000L, (long)(value.getTime() - searchRange.getMinValue().getTime()));
        TestCase.assertEquals((long)0L, (long)(searchRange.getMaxValue().getTime() - value.getTime()));
    }

    @Test
    public void testFutureTimeRange() throws Exception {
        AcceptableRange range = AcceptableRange.getAcceptableRange((String)"P0D/P1D", Date.class);
        TestCase.assertEquals((Object)0L, (Object)range.getBefore());
        TestCase.assertEquals((Object)86400000L, (Object)range.getAfter());
        Date value = new Date();
        DateRange searchRange = (DateRange)range.getSearchRange((Object)value);
        TestCase.assertEquals((long)0L, (long)(value.getTime() - searchRange.getMinValue().getTime()));
        TestCase.assertEquals((long)86400000L, (long)(searchRange.getMaxValue().getTime() - value.getTime()));
    }
}

