/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.crs;

import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geotools.api.referencing.operation.CoordinateOperationAuthorityFactory;
import org.geotools.referencing.factory.epsg.CoordinateOperationFactoryUsingWKT;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.vfny.geoserver.crs.GeoserverOverridingWKTFactory;

public class GeoserverWKTOperationFactory
extends CoordinateOperationFactoryUsingWKT
implements CoordinateOperationAuthorityFactory {
    public GeoserverWKTOperationFactory() {
        super(null, 100);
    }

    public GeoserverWKTOperationFactory(Hints userHints) {
        super(userHints, 100);
    }

    protected URL getDefinitionsURL() {
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        if (loader != null) {
            Resource definition = loader.get("user_projections/epsg_operations.properties");
            if (definition.getType() == Resource.Type.RESOURCE) {
                File file = definition.file();
                URL url = URLs.fileToUrl((File)file);
                if (url != null) {
                    return url;
                }
                LOGGER.log(Level.SEVERE, "Had troubles converting file name to URL");
            } else {
                LOGGER.info(definition.path() + " was not found, using the default set of coordinate operation overrides (normally empty)");
            }
        }
        return GeoserverOverridingWKTFactory.class.getResource("epsg_operations.properties");
    }
}

