/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.geoserver.security.impl.GeoServerRole;

public class RoleStoreHelper {
    public TreeMap<String, GeoServerRole> roleMap = new TreeMap();
    public TreeMap<String, SortedSet<GeoServerRole>> group_roleMap = new TreeMap();
    public TreeMap<String, SortedSet<GeoServerRole>> user_roleMap = new TreeMap();
    public HashMap<GeoServerRole, GeoServerRole> role_parentMap = new HashMap();

    public void clearMaps() {
        this.roleMap.clear();
        this.role_parentMap.clear();
        this.group_roleMap.clear();
        this.user_roleMap.clear();
    }

    public Map<String, String> getParentMappings() throws IOException {
        HashMap<String, String> parentMap = new HashMap<String, String>();
        for (GeoServerRole role : this.roleMap.values()) {
            GeoServerRole parentRole = this.role_parentMap.get(role);
            parentMap.put(role.getAuthority(), parentRole == null ? null : parentRole.getAuthority());
        }
        return Collections.unmodifiableMap(parentMap);
    }

    public SortedSet<GeoServerRole> getRoles() throws IOException {
        TreeSet<GeoServerRole> result = new TreeSet<GeoServerRole>();
        result.addAll(this.roleMap.values());
        return Collections.unmodifiableSortedSet(result);
    }

    public SortedSet<GeoServerRole> getRolesForUser(String username) throws IOException {
        SortedSet<GeoServerRole> roles = this.user_roleMap.get(username);
        if (roles == null) {
            roles = new TreeSet<GeoServerRole>();
        }
        return Collections.unmodifiableSortedSet(roles);
    }

    public SortedSet<GeoServerRole> getRolesForGroup(String groupname) throws IOException {
        SortedSet<GeoServerRole> roles = this.group_roleMap.get(groupname);
        if (roles == null) {
            roles = new TreeSet<GeoServerRole>();
        }
        return Collections.unmodifiableSortedSet(roles);
    }

    public GeoServerRole getParentRole(GeoServerRole role) throws IOException {
        return this.role_parentMap.get(role);
    }

    public GeoServerRole getRoleByName(String role) throws IOException {
        return this.roleMap.get(role);
    }

    public SortedSet<String> getGroupNamesForRole(GeoServerRole role) throws IOException {
        TreeSet<String> result = new TreeSet<String>();
        for (Map.Entry<String, SortedSet<GeoServerRole>> entry : this.group_roleMap.entrySet()) {
            if (!entry.getValue().contains(role)) continue;
            result.add(entry.getKey());
        }
        return Collections.unmodifiableSortedSet(result);
    }

    public SortedSet<String> getUserNamesForRole(GeoServerRole role) throws IOException {
        TreeSet<String> result = new TreeSet<String>();
        for (Map.Entry<String, SortedSet<GeoServerRole>> entry : this.user_roleMap.entrySet()) {
            if (!entry.getValue().contains(role)) continue;
            result.add(entry.getKey());
        }
        return Collections.unmodifiableSortedSet(result);
    }

    public int getRoleCount() throws IOException {
        return this.roleMap.size();
    }
}

