/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.geoserver.security.GeoServerRoleConverter;
import org.geoserver.security.impl.GeoServerRole;
import org.springframework.security.core.GrantedAuthority;

public class GeoServerRoleConverterImpl
implements GeoServerRoleConverter {
    private String roleDelimiterString = ";";
    private String roleParameterDelimiterString = ",";
    private String roleParameterStartString = "(";
    private String roleParameterEndString = ")";
    private String roleParameterAssignmentString = "=";
    private boolean checked = false;

    public String getRoleDelimiterString() {
        return this.roleDelimiterString;
    }

    public void setRoleDelimiterString(String roleDelimiterString) {
        this.roleDelimiterString = roleDelimiterString;
        this.checked = false;
    }

    public String getRoleParameterDelimiterString() {
        return this.roleParameterDelimiterString;
    }

    public void setRoleParameterDelimiterString(String roleParameterDelimiterString) {
        this.roleParameterDelimiterString = roleParameterDelimiterString;
        this.checked = false;
    }

    public String getRoleParameterStartString() {
        return this.roleParameterStartString;
    }

    public void setRoleParameterStartString(String roleParameterStartString) {
        this.roleParameterStartString = roleParameterStartString;
        this.checked = false;
    }

    public String getRoleParameterEndString() {
        return this.roleParameterEndString;
    }

    public void setRoleParameterEndString(String roleParameterEndString) {
        this.roleParameterEndString = roleParameterEndString;
        this.checked = false;
    }

    public String getRoleParameterAssignmentString() {
        return this.roleParameterAssignmentString;
    }

    public void setRoleParameterAssignmentString(String roleParameterAssignmentString) {
        this.roleParameterAssignmentString = roleParameterAssignmentString;
        this.checked = false;
    }

    @Override
    public String convertRoleToString(GeoServerRole role) {
        this.checkDelimiters();
        StringBuffer buff = new StringBuffer();
        this.writeRole(buff, role);
        return buff.toString();
    }

    protected void writeRole(StringBuffer buff, GeoServerRole role) {
        buff.append(role.getAuthority());
        Properties props = role.getProperties();
        if (props == null || props.isEmpty()) {
            return;
        }
        buff.append(this.getRoleParameterStartString());
        boolean firstTime = true;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (firstTime) {
                firstTime = false;
            } else {
                buff.append(this.getRoleParameterDelimiterString());
            }
            buff.append(entry.getKey()).append(this.getRoleParameterAssignmentString());
            buff.append(entry.getValue() == null ? "" : entry.getValue());
        }
        buff.append(this.getRoleParameterEndString());
    }

    @Override
    public String convertRolesToString(Collection<? extends GrantedAuthority> roles) {
        this.checkDelimiters();
        StringBuffer buff = new StringBuffer();
        boolean firstTime = true;
        for (GrantedAuthority grantedAuthority : roles) {
            if (firstTime) {
                firstTime = false;
            } else {
                buff.append(this.getRoleDelimiterString());
            }
            this.writeRole(buff, (GeoServerRole)grantedAuthority);
        }
        return buff.toString();
    }

    protected List<String> splitString(String theString, String delim) {
        ArrayList<String> result = new ArrayList<String>();
        int startIndex = 0;
        while (true) {
            int index;
            if ((index = theString.indexOf(delim, startIndex)) == -1) break;
            result.add(theString.substring(startIndex, index));
            startIndex = index + delim.length();
        }
        result.add(theString.substring(startIndex));
        return result;
    }

    @Override
    public Collection<GeoServerRole> convertRolesFromString(String rolesString, String userName) {
        this.checkDelimiters();
        ArrayList<GeoServerRole> roles = new ArrayList<GeoServerRole>();
        List<String> working = this.splitString(rolesString, this.getRoleDelimiterString());
        for (String roleString : working) {
            GeoServerRole role = this.convertRoleFromString(roleString, userName);
            if (role == null) continue;
            roles.add(role);
        }
        return roles;
    }

    @Override
    public GeoServerRole convertRoleFromString(String roleString, String userName) {
        if (roleString == null) {
            return null;
        }
        if ((roleString = roleString.trim()).isEmpty()) {
            return null;
        }
        this.checkDelimiters();
        List<String> working = this.splitString(roleString.trim(), this.getRoleParameterStartString());
        GeoServerRole result = new GeoServerRole(working.get(0));
        if (working.size() == 1) {
            return result;
        }
        result.setUserName(userName);
        if (!working.get(1).endsWith(this.getRoleParameterEndString())) {
            throw this.createExcpetion(roleString + " does not end with " + this.getRoleParameterEndString());
        }
        int index = working.get(1).lastIndexOf(this.getRoleParameterEndString());
        String roleParamString = working.get(1).substring(0, index).trim();
        working = this.splitString(roleParamString, this.getRoleParameterDelimiterString());
        for (String kvp : working) {
            List<String> tmp = this.splitString(kvp.trim(), this.getRoleParameterAssignmentString());
            if (tmp.size() != 2) {
                throw this.createExcpetion(roleString + " Invalid role string:  " + roleString);
            }
            result.getProperties().put(tmp.get(0).trim(), tmp.get(1).trim());
        }
        return result;
    }

    protected void checkDelimiters() {
        if (this.checked) {
            return;
        }
        if (this.roleDelimiterString == null || this.roleDelimiterString.isEmpty()) {
            throw this.createExcpetion("Missing roleDelimiterString");
        }
        if (this.roleParameterDelimiterString == null || this.roleParameterDelimiterString.isEmpty()) {
            throw this.createExcpetion("Missing roleParameterDelimiterString");
        }
        if (this.roleParameterStartString == null || this.roleParameterStartString.isEmpty()) {
            throw this.createExcpetion("Missing roleParameterStartString");
        }
        if (this.roleParameterEndString == null || this.roleParameterEndString.isEmpty()) {
            throw this.createExcpetion("Missing roleParameterEndString");
        }
        if (this.roleParameterAssignmentString == null || this.roleParameterAssignmentString.isEmpty()) {
            throw this.createExcpetion("Missing roleParameterAssignmentString");
        }
        HashSet<String> set = new HashSet<String>();
        set.add(this.roleDelimiterString);
        set.add(this.roleParameterDelimiterString);
        set.add(this.roleParameterStartString);
        set.add(this.roleParameterEndString);
        set.add(this.roleParameterAssignmentString);
        if (set.size() < 5) {
            throw this.createExcpetion("Delimiters must be unique");
        }
        this.checked = true;
    }

    protected RuntimeException createExcpetion(String msg) {
        return new RuntimeException(msg);
    }
}

