/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.config.SecurityInterceptorFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerCompositeFilter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.access.intercept.AuthorizationFilter;

public class GeoServerSecurityInterceptorFilter
extends GeoServerCompositeFilter {
    private static final AuthorizationDecision ACCESS_GRANTED = new AuthorizationDecision(true);
    private static final AuthorizationDecision ACCESS_DENIED = new AuthorizationDecision(false);
    private static final AuthorizationDecision ACCESS_ABSTAIN = null;

    public void initializeFromConfig(SecurityNamedServiceConfig config, SecurityMetadataSource source) throws IOException {
        super.initializeFromConfig(config);
        SecurityInterceptorFilterConfig siConfig = (SecurityInterceptorFilterConfig)config;
        boolean allowIfAllAbstainDecisions = siConfig.isAllowIfAllAbstainDecisions();
        AuthenticatedAuthorizationManager aam = new AuthenticatedAuthorizationManager(source);
        RoleAuthorizationManager ram = new RoleAuthorizationManager(source);
        AffirmativeAuthorizationManager am = new AffirmativeAuthorizationManager(aam, ram, allowIfAllAbstainDecisions);
        AuthorizationFilter filter = new AuthorizationFilter((AuthorizationManager)am);
        this.getNestedFilters().add((Filter)filter);
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        SecurityInterceptorFilterConfig siConfig = (SecurityInterceptorFilterConfig)config;
        String sourceName = siConfig.getSecurityMetadataSource();
        SecurityMetadataSource source = (SecurityMetadataSource)GeoServerExtensions.bean((String)sourceName);
        this.initializeFromConfig(config, source);
    }

    private static final class AffirmativeAuthorizationManager
    implements AuthorizationManager<HttpServletRequest> {
        private AuthorizationManager<HttpServletRequest> delegate1;
        private AuthorizationManager<HttpServletRequest> delegate2;
        private boolean allowIfAllAbstainDecisions;

        public AffirmativeAuthorizationManager(AuthorizationManager<HttpServletRequest> delegate1, AuthorizationManager<HttpServletRequest> delegate2, boolean allowIfAllAbstainDecisions) {
            this.delegate1 = delegate1;
            this.delegate2 = delegate2;
            this.allowIfAllAbstainDecisions = allowIfAllAbstainDecisions;
        }

        public AuthorizationDecision check(Supplier<Authentication> authentication, HttpServletRequest object) {
            AuthorizationDecision d1 = this.delegate1.check(authentication, (Object)object);
            AuthorizationDecision d2 = this.delegate2.check(authentication, (Object)object);
            if (d1 == null && d2 == null) {
                return this.allowIfAllAbstainDecisions ? ACCESS_GRANTED : ACCESS_DENIED;
            }
            if (d1 != null && d1.isGranted()) {
                return ACCESS_GRANTED;
            }
            if (d2 != null && d2.isGranted()) {
                return ACCESS_GRANTED;
            }
            return ACCESS_DENIED;
        }
    }

    private static final class RoleAuthorizationManager
    implements AuthorizationManager<HttpServletRequest> {
        private SecurityMetadataSource metadata;

        public RoleAuthorizationManager(SecurityMetadataSource metadata) {
            this.metadata = metadata;
        }

        private AuthorizationDecision vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
            if (authentication == null) {
                return ACCESS_DENIED;
            }
            AuthorizationDecision result = ACCESS_ABSTAIN;
            Collection authorities = authentication.getAuthorities();
            for (ConfigAttribute attribute : attributes) {
                if (attribute.getAttribute() == null) continue;
                result = ACCESS_DENIED;
                for (GrantedAuthority authority : authorities) {
                    if (!attribute.getAttribute().equals(authority.getAuthority())) continue;
                    return ACCESS_GRANTED;
                }
            }
            return result;
        }

        public AuthorizationDecision check(Supplier<Authentication> authentication, HttpServletRequest request) {
            Collection attributes = Optional.ofNullable(this.metadata.getAttributes((Object)request)).orElse(Collections.emptySet());
            return this.vote(authentication.get(), request, attributes);
        }
    }

    private static final class AuthenticatedAuthorizationManager
    implements AuthorizationManager<HttpServletRequest> {
        public static final String IS_AUTHENTICATED_FULLY = "IS_AUTHENTICATED_FULLY";
        public static final String IS_AUTHENTICATED_REMEMBERED = "IS_AUTHENTICATED_REMEMBERED";
        public static final String IS_AUTHENTICATED_ANONYMOUSLY = "IS_AUTHENTICATED_ANONYMOUSLY";
        private SecurityMetadataSource metadata;
        private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();

        public AuthenticatedAuthorizationManager(SecurityMetadataSource metadata) {
            this.metadata = metadata;
        }

        private boolean isFullyAuthenticated(Authentication authentication) {
            return !this.authenticationTrustResolver.isAnonymous(authentication) && !this.authenticationTrustResolver.isRememberMe(authentication);
        }

        private boolean supports(ConfigAttribute attribute) {
            return attribute.getAttribute() != null && (IS_AUTHENTICATED_FULLY.equals(attribute.getAttribute()) || IS_AUTHENTICATED_REMEMBERED.equals(attribute.getAttribute()) || IS_AUTHENTICATED_ANONYMOUSLY.equals(attribute.getAttribute()));
        }

        private AuthorizationDecision vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
            AuthorizationDecision result = ACCESS_ABSTAIN;
            for (ConfigAttribute attribute : attributes) {
                if (!this.supports(attribute)) continue;
                result = ACCESS_DENIED;
                if (IS_AUTHENTICATED_FULLY.equals(attribute.getAttribute()) && this.isFullyAuthenticated(authentication)) {
                    return ACCESS_GRANTED;
                }
                if (IS_AUTHENTICATED_REMEMBERED.equals(attribute.getAttribute()) && (this.authenticationTrustResolver.isRememberMe(authentication) || this.isFullyAuthenticated(authentication))) {
                    return ACCESS_GRANTED;
                }
                if (!IS_AUTHENTICATED_ANONYMOUSLY.equals(attribute.getAttribute()) || !this.authenticationTrustResolver.isAnonymous(authentication) && !this.isFullyAuthenticated(authentication) && !this.authenticationTrustResolver.isRememberMe(authentication)) continue;
                return ACCESS_GRANTED;
            }
            return result;
        }

        public AuthorizationDecision check(Supplier<Authentication> authentication, HttpServletRequest request) {
            Collection attributes = Optional.ofNullable(this.metadata.getAttributes((Object)request)).orElse(Collections.emptySet());
            return this.vote(authentication.get(), request, attributes);
        }
    }
}

