/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Logger;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.security.impl.Util;
import org.geotools.util.logging.Logging;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class LockFile {
    protected long lockFileLastModified;
    protected Resource lockFileTarget;
    protected Resource lockFile;
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.xml");

    public LockFile(Resource file) throws IOException {
        this.lockFileTarget = file;
        if (!Resources.exists((Resource)file)) {
            throw new IOException("Cannot lock a not existing file: " + file.path());
        }
        this.lockFile = file.parent().get(this.lockFileTarget.name() + ".lock");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.lockFile.delete()));
    }

    public boolean hasWriteLock() throws IOException {
        return Resources.exists((Resource)this.lockFile) && this.lockFile.lastmodified() == this.lockFileLastModified;
    }

    public boolean hasForeignWriteLock() throws IOException {
        return Resources.exists((Resource)this.lockFile) && this.lockFile.lastmodified() != this.lockFileLastModified;
    }

    public void writeUnLock() {
        if (Resources.exists((Resource)this.lockFile)) {
            if (this.lockFile.lastmodified() == this.lockFileLastModified) {
                this.lockFileLastModified = 0L;
                this.lockFile.delete();
            } else {
                LOGGER.warning("Tried to unlock foreign lock: " + this.lockFile.path());
            }
        } else {
            LOGGER.warning("Tried to unlock not exisiting lock: " + this.lockFile.path());
        }
    }

    public void writeLock() throws IOException {
        if (this.hasWriteLock()) {
            return;
        }
        if (Resources.exists((Resource)this.lockFile)) {
            LOGGER.warning("Cannot obtain  lock: " + this.lockFile.path());
            Properties props = new Properties();
            try (InputStream in = this.lockFile.in();){
                props.load(in);
            }
            throw new IOException(Util.convertPropsToString(props, "Already locked"));
        }
        this.writeLockFileContent(this.lockFile);
        this.lockFileLastModified = this.lockFile.lastmodified();
        LOGGER.info("Successful lock: " + this.lockFile.path());
    }

    protected void writeLockFileContent(Resource lockFile) throws IOException {
        Properties props = new Properties();
        try (OutputStream out = lockFile.out();){
            props.store(out, "Locking info");
            String hostname = "UNKNOWN";
            String ip = "UNKNOWN";
            try {
                InetAddress[] addrs;
                hostname = InetAddress.getLocalHost().getHostName();
                for (InetAddress addr : addrs = InetAddress.getAllByName(hostname)) {
                    if (addr.isLoopbackAddress() || !addr.isSiteLocalAddress()) continue;
                    ip = addr.getHostAddress();
                }
            }
            catch (UnknownHostException addrs) {
                // empty catch block
            }
            props.put("hostname", hostname);
            props.put("ip", ip);
            props.put("location", lockFile.path());
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            props.put("principal", auth == null ? "UNKNOWN" : auth.getName());
            props.store(out, "Locking info");
        }
    }
}

