/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.Response;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.data.DataUtilities;
import org.geotools.data.store.DecoratingDataStore;

public class ReadOnlyDataStore
extends DecoratingDataStore {
    WrapperPolicy policy;

    protected ReadOnlyDataStore(DataStore delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        SimpleFeatureSource fs = super.getFeatureSource(typeName);
        return this.wrapFeatureSource(fs);
    }

    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        SimpleFeatureSource fs = super.getFeatureSource(typeName);
        return this.wrapFeatureSource(fs);
    }

    SimpleFeatureSource wrapFeatureSource(SimpleFeatureSource fs) {
        if (fs == null) {
            return null;
        }
        WrapperPolicy childPolicy = this.buildPolicyForFeatureSource();
        return DataUtilities.simple((FeatureSource)((FeatureSource)SecuredObjects.secure(fs, childPolicy)));
    }

    private WrapperPolicy buildPolicyForFeatureSource() {
        WrapperPolicy childPolicy;
        if (this.policy.getLimits() instanceof VectorAccessLimits) {
            childPolicy = this.policy;
        } else {
            AccessLimits limits = this.policy.getLimits();
            VectorAccessLimits vectorLimits = new VectorAccessLimits(limits.getMode(), null, (Filter)Filter.INCLUDE, null, (Filter)Filter.EXCLUDE);
            childPolicy = this.policy.derive(vectorLimits);
        }
        return childPolicy;
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    public void removeSchema(Name typeName) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    public void removeSchema(String typeName) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    protected RuntimeException notifyUnsupportedOperation() {
        if (this.policy.response == Response.CHALLENGE) {
            return SecureCatalogImpl.unauthorizedAccess();
        }
        return new UnsupportedOperationException("This datastore is read only, service code is supposed to perform writes via FeatureStore instead");
    }
}

