/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.util.List;
import java.util.SortedSet;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.RequestFilterChain;

public abstract class VariableFilterChain
extends RequestFilterChain {
    String interceptorName = "interceptor";
    String exceptionTranslationName = "exception";
    private static final long serialVersionUID = 1L;

    public VariableFilterChain(String ... patterns) {
        super(patterns);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    public abstract SortedSet<String> listFilterCandidates(GeoServerSecurityManager var1) throws IOException;

    @Override
    void createCompiledFilterList(List<String> list2) {
        list2.addAll(this.getFilterNames());
        list2.add(this.exceptionTranslationName);
        list2.add(this.interceptorName);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof VariableFilterChain)) {
            return false;
        }
        VariableFilterChain other = (VariableFilterChain)obj;
        if (this.interceptorName == null && other.interceptorName != null) {
            return false;
        }
        if (this.interceptorName != null && !this.interceptorName.equals(other.interceptorName)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return hash *= this.interceptorName == null ? 1 : this.interceptorName.hashCode();
    }

    public String getInterceptorName() {
        return this.interceptorName;
    }

    public void setInterceptorName(String interceptorName) {
        this.interceptorName = interceptorName;
    }

    @Override
    public boolean canBeRemoved() {
        return true;
    }

    public String getExceptionTranslationName() {
        return this.exceptionTranslationName;
    }

    public void setExceptionTranslationName(String exceptionTranslationName) {
        this.exceptionTranslationName = exceptionTranslationName;
    }
}

