/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.geoserver.security.HTTPMethod;
import org.geotools.util.logging.Logging;
import org.springframework.util.StringUtils;

public abstract class RequestFilterChain
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    String name;
    List<String> patterns;
    List<String> filterNames;
    boolean disabled;
    boolean allowSessionCreation;
    boolean requireSSL;
    boolean matchHTTPMethod;
    Set<HTTPMethod> httpMethods;
    String roleFilterName;

    public RequestFilterChain(String ... patterns) {
        this.patterns = new ArrayList<String>(Arrays.asList(patterns));
        this.filterNames = new ArrayList<String>();
        this.httpMethods = new TreeSet<HTTPMethod>();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public List<String> getFilterNames() {
        return this.filterNames;
    }

    public abstract boolean isConstant();

    public void setFilterNames(String ... filterNames) {
        this.setFilterNames(new ArrayList<String>(Arrays.asList(filterNames)));
    }

    public void setFilterNames(List<String> filterNames) {
        this.filterNames = filterNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.patterns).append(":").append(this.filterNames);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isConstant() ? 1231 : 1237);
        result = 31 * result + (this.isAllowSessionCreation() ? 17 : 19);
        result = 31 * result + (this.isDisabled() ? 23 : 29);
        result = 31 * result + (this.isRequireSSL() ? 31 : 37);
        result = 31 * result + (this.isMatchHTTPMethod() ? 41 : 49);
        result = 31 * (this.roleFilterName == null ? 1 : this.roleFilterName.hashCode());
        result = 31 * result + (this.httpMethods == null ? 0 : this.httpMethods.hashCode());
        result = 31 * result + (this.filterNames == null ? 0 : this.filterNames.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.patterns == null ? 0 : this.patterns.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestFilterChain other = (RequestFilterChain)obj;
        if (this.roleFilterName == null && other.roleFilterName != null) {
            return false;
        }
        if (this.roleFilterName != null && !this.roleFilterName.equals(other.roleFilterName)) {
            return false;
        }
        if (this.isAllowSessionCreation() != other.isAllowSessionCreation()) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        if (this.isRequireSSL() != other.isRequireSSL()) {
            return false;
        }
        if (this.isMatchHTTPMethod() != other.isMatchHTTPMethod()) {
            return false;
        }
        if (this.filterNames == null ? other.filterNames != null : !this.filterNames.equals(other.filterNames)) {
            return false;
        }
        if (this.httpMethods == null ? other.httpMethods != null : !this.httpMethods.equals(other.httpMethods)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.patterns == null ? other.patterns != null : !this.patterns.equals(other.patterns));
    }

    public Object clone() throws CloneNotSupportedException {
        RequestFilterChain chain = (RequestFilterChain)super.clone();
        chain.setFilterNames(new ArrayList<String>(this.filterNames));
        chain.patterns = new ArrayList<String>(this.patterns);
        chain.httpMethods = new TreeSet<HTTPMethod>(this.httpMethods);
        return chain;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public List<String> getCompiledFilterNames() {
        if (this.isDisabled()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.isRequireSSL()) {
            result.add("sslFilter");
        }
        if (this.isAllowSessionCreation()) {
            result.add("contextAsc");
        } else {
            result.add("contextNoAsc");
        }
        if (StringUtils.hasLength((String)this.getRoleFilterName())) {
            result.add(this.getRoleFilterName());
        }
        this.createCompiledFilterList(result);
        return result;
    }

    void createCompiledFilterList(List<String> list2) {
        list2.addAll(this.getFilterNames());
    }

    public boolean isAllowSessionCreation() {
        return this.allowSessionCreation;
    }

    public void setAllowSessionCreation(boolean allowSessionCreation) {
        this.allowSessionCreation = allowSessionCreation;
    }

    public boolean isRequireSSL() {
        return this.requireSSL;
    }

    public void setRequireSSL(boolean requireSSL) {
        this.requireSSL = requireSSL;
    }

    public boolean isMatchHTTPMethod() {
        return this.matchHTTPMethod;
    }

    public void setMatchHTTPMethod(boolean matchHTTPMethod) {
        this.matchHTTPMethod = matchHTTPMethod;
    }

    public Set<HTTPMethod> getHttpMethods() {
        return this.httpMethods;
    }

    public void setHttpMethods(Set<HTTPMethod> httpMethods) {
        this.httpMethods = httpMethods;
    }

    public void setPatterns(List<String> patterns) {
        this.patterns = patterns;
    }

    public String getRoleFilterName() {
        return this.roleFilterName;
    }

    public void setRoleFilterName(String roleFilterName) {
        this.roleFilterName = roleFilterName;
    }

    public abstract boolean canBeRemoved();
}

