/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerHttpFirewall;
import org.geoserver.security.GeoServerRequestMatcher;
import org.geoserver.security.GeoServerSecurityFilterChain;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.HTTPMethod;
import org.geoserver.security.IncludeQueryStringAntPathRequestMatcher;
import org.geoserver.security.RequestFilterChain;
import org.geoserver.security.SecurityManagerListener;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class GeoServerSecurityFilterChainProxy
implements SecurityManagerListener,
ApplicationContextAware,
InitializingBean,
Filter {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    static ThreadLocal<HttpServletRequest> REQUEST = new ThreadLocal();
    public static final String SECURITY_ENABLED_ATTRIBUTE = "org.geoserver.security.enabled";
    private boolean chainsInitialized;
    GeoServerSecurityManager securityManager;
    FilterChainProxy proxy;
    ApplicationContext appContext;

    public GeoServerSecurityFilterChainProxy(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
        this.securityManager.addListener(this);
        this.chainsInitialized = false;
    }

    public static boolean isSecurityEnabledForCurrentRequest() {
        if (REQUEST.get() == null) {
            return true;
        }
        return Boolean.TRUE.equals(REQUEST.get().getAttribute(SECURITY_ENABLED_ATTRIBUTE));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.proxy != null) {
            this.proxy.init(filterConfig);
        } else {
            LOGGER.warning("init() called but proxy not yet configured");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setAttribute(SECURITY_ENABLED_ATTRIBUTE, (Object)Boolean.FALSE);
        REQUEST.set((HttpServletRequest)request);
        try {
            this.proxy.doFilter(request, response, chain);
        }
        finally {
            REQUEST.remove();
        }
    }

    @Override
    public void handlePostChanged(GeoServerSecurityManager securityManager) {
        this.createFilterChain();
    }

    public void afterPropertiesSet() {
        this.createFilterChain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createFilterChain() {
        if (!this.securityManager.isInitialized()) {
            return;
        }
        SecurityManagerConfig config = this.securityManager.getSecurityConfig();
        GeoServerSecurityFilterChain filterChain = new GeoServerSecurityFilterChain(config.getFilterChain());
        filterChain.postConfigure(this.securityManager);
        ArrayList<DefaultSecurityFilterChain> filterChains = new ArrayList<DefaultSecurityFilterChain>();
        for (RequestFilterChain chain : filterChain.getRequestChains()) {
            GeoServerRequestMatcher matcher = this.matcherForChain(chain);
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (String filterName : chain.getCompiledFilterNames()) {
                try {
                    Filter filter = this.lookupFilter(filterName);
                    if (filter == null) {
                        throw new NullPointerException("No filter named " + filterName + " could be found");
                    }
                    filters.add(filter);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Error loading filter: " + filterName, ex);
                }
            }
            filterChains.add(new DefaultSecurityFilterChain((RequestMatcher)matcher, filters));
        }
        GeoServerSecurityFilterChainProxy geoServerSecurityFilterChainProxy = this;
        synchronized (geoServerSecurityFilterChainProxy) {
            if (this.chainsInitialized) {
                for (SecurityFilterChain chain : this.proxy.getFilterChains()) {
                    for (Filter filter : chain.getFilters()) {
                        filter.destroy();
                    }
                }
            }
            this.securityManager.getAuthenticationCache().removeAll();
            this.proxy = new FilterChainProxy(filterChains);
            this.proxy.setFirewall((HttpFirewall)new GeoServerHttpFirewall());
            this.proxy.afterPropertiesSet();
            this.chainsInitialized = true;
        }
    }

    public GeoServerRequestMatcher matcherForChain(RequestFilterChain chain) {
        List<String> tmp;
        Set<HTTPMethod> methods = chain.getHttpMethods();
        if (!chain.isMatchHTTPMethod()) {
            methods = null;
        }
        if ((tmp = chain.getPatterns()) == null) {
            return new GeoServerRequestMatcher(methods, null);
        }
        ArrayList<String> patterns = new ArrayList<String>();
        for (String pattern : tmp) {
            String[] array;
            for (String singlePattern : array = pattern.split(",")) {
                patterns.add(singlePattern);
            }
        }
        RequestMatcher[] matchers = new RequestMatcher[patterns.size()];
        for (int i = 0; i < matchers.length; ++i) {
            matchers[i] = new IncludeQueryStringAntPathRequestMatcher((String)patterns.get(i));
        }
        return new GeoServerRequestMatcher(methods, matchers);
    }

    public Filter lookupFilter(String filterName) throws IOException {
        GeoServerSecurityFilter filter = this.securityManager.loadFilter(filterName);
        if (filter == null) {
            try {
                Object obj = GeoServerExtensions.bean((String)filterName, (ApplicationContext)this.appContext);
                if (obj != null && obj instanceof Filter) {
                    filter = (Filter)obj;
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        return filter;
    }

    public void destroy() {
        this.proxy.destroy();
        this.securityManager.removeListener(this);
    }

    public List<SecurityFilterChain> getFilterChains() {
        return this.proxy.getFilterChains();
    }
}

