/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.filters.GeoServerFilter;
import org.geoserver.ows.util.CaseInsensitiveMap;

public class HTTPHeadersCollector
implements GeoServerFilter {
    public static final ThreadLocal<Map<String, String>> HEADERS = new ThreadLocal();

    public static String getHeader(String header) {
        Map<String, String> headers = HEADERS.get();
        if (headers == null) {
            return null;
        }
        return headers.get(header);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.collectHeaders((HttpServletRequest)request);
            chain.doFilter(request, response);
        }
        finally {
            HEADERS.remove();
        }
    }

    public void collectHeaders(HttpServletRequest request) {
        Enumeration names = request.getHeaderNames();
        CaseInsensitiveMap headers = new CaseInsensitiveMap(new HashMap());
        while (names.hasMoreElements()) {
            String header = (String)names.nextElement();
            String value = request.getHeader(header);
            headers.put(header, value);
        }
        HEADERS.set((Map<String, String>)headers);
    }

    public void destroy() {
    }
}

