/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data;

import java.util.Locale;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.GeoServerDefaultLocale;

public abstract class DefaultLocaleDispatcherCallback<T extends ServiceInfo>
extends AbstractDispatcherCallback {
    protected GeoServer geoServer;

    public DefaultLocaleDispatcherCallback(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public Service serviceDispatched(Request request, Service service) throws ServiceException {
        T serviceInfo = this.getService(request);
        Locale defaultLocale = null;
        if (serviceInfo != null) {
            defaultLocale = serviceInfo.getDefaultLocale();
        }
        if (defaultLocale == null) {
            defaultLocale = this.geoServer.getSettings().getDefaultLocale();
        }
        if (defaultLocale != null) {
            GeoServerDefaultLocale.set(defaultLocale);
        }
        return super.serviceDispatched(request, service);
    }

    public void finished(Request request) {
        GeoServerDefaultLocale.remove();
        super.finished(request);
    }

    protected abstract T getService(Request var1);
}

