/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.impl;

import it.geosolutions.jaiext.ConcurrentOperationRegistry;
import it.geosolutions.jaiext.JAIExt;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.geoserver.config.JAIEXTInfo;
import org.geotools.image.ImageWorker;

public class JAIEXTInfoImpl
implements JAIEXTInfo {
    public static final Set<String> JAI_OPS = new TreeSet<String>();
    private Set<String> jaiOperations = JAI_OPS;
    public static final TreeSet<String> JAIEXT_OPS = new TreeSet();
    private Set<String> jaiExtOperations = JAIEXT_OPS;

    public JAIEXTInfoImpl() {
        if (this.jaiOperations == null) {
            this.jaiOperations = JAI_OPS;
        }
        if (this.jaiExtOperations == null) {
            this.jaiExtOperations = JAIEXT_OPS;
        }
        if (ImageWorker.isJaiExtEnabled()) {
            JAIEXTInfoImpl.populateOperations(this.jaiExtOperations);
        }
    }

    @Override
    public Set<String> getJAIOperations() {
        if (this.jaiOperations == null) {
            this.jaiOperations = JAI_OPS;
        }
        return this.jaiOperations;
    }

    @Override
    public void setJAIOperations(Set<String> operations) {
        this.jaiOperations = new TreeSet<String>(operations);
    }

    @Override
    public Set<String> getJAIEXTOperations() {
        if (this.jaiExtOperations == null) {
            this.jaiExtOperations = JAIEXT_OPS;
        }
        return this.jaiExtOperations;
    }

    @Override
    public void setJAIEXTOperations(Set<String> operations) {
        this.jaiExtOperations = new TreeSet<String>(operations);
    }

    private static void populateOperations(Set<String> jaiExtOp) {
        List jaiextOps = ImageWorker.isJaiExtEnabled() ? JAIExt.getJAIEXTOperations() : JAIExt.getJAIOperations();
        for (ConcurrentOperationRegistry.OperationItem item : jaiextOps) {
            String name = item.getName();
            if (!name.equalsIgnoreCase("algebric") && !name.equalsIgnoreCase("operationConst") && !name.equalsIgnoreCase("Stats") && !JAIExt.isJAIAPI((String)name)) continue;
            jaiExtOp.add(name);
        }
    }

    static {
        JAIExt.initJAIEXT((boolean)ImageWorker.isJaiExtEnabled());
        JAIEXTInfoImpl.populateOperations(JAIEXT_OPS);
    }
}

