/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.datadir;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerConfigPersister;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.ServicePersister;
import org.geoserver.config.datadir.ConfigLoader;
import org.geoserver.config.datadir.DataDirectoryWalker;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerResourceLoader;

class MinimalConfigLoaderSupport {
    private ConfigLoader loader;
    private final GeoServer geoServer;
    private final DataDirectoryWalker fileWalk;

    public MinimalConfigLoaderSupport(ConfigLoader loader) {
        this.loader = loader;
        this.geoServer = loader.geoServer;
        this.fileWalk = loader.fileWalk;
    }

    public void initializeEmptyConfig() {
        this.fileWalk.lock();
        try {
            XStreamPersister xp = this.fileWalk.getXStreamLoader().getPersisterFactory().createXMLPersister();
            RootConfigPersister persister = RootConfigPersister.valueOf(this.geoServer, this.fileWalk.getServiceLoaders(), xp);
            if (this.isGlobalMissing()) {
                this.addMissingGlobalConfig(persister);
            }
            if (this.isLoggingMissing()) {
                this.addMissingLoggingConfig(persister);
            }
            this.synchronizeRootServices(persister);
        }
        finally {
            this.fileWalk.unlock();
        }
    }

    private boolean isLoggingMissing() {
        LoggingInfo logging = this.geoServer.getLogging();
        return logging == null || logging.getLevel() == null || this.fileWalk.gsLogging().isEmpty();
    }

    private boolean isGlobalMissing() {
        GeoServerInfo global = this.geoServer.getGlobal();
        return global == null || this.fileWalk.gsGlobal().isEmpty();
    }

    private void addMissingGlobalConfig(RootConfigPersister persister) {
        Optional<GeoServerInfo> global = this.loader.loadGlobal();
        if (global.isPresent()) {
            this.geoServer.setGlobal(global.orElseThrow());
        } else {
            this.geoServer.addListener(persister);
            GeoServerInfo config = this.geoServer.getFactory().createGlobal();
            this.geoServer.setGlobal(config);
            this.geoServer.removeListener(persister);
        }
    }

    private void addMissingLoggingConfig(RootConfigPersister persister) {
        Optional<LoggingInfo> logging = this.loader.loadLogging();
        if (logging.isPresent()) {
            this.geoServer.setLogging(logging.orElseThrow());
        } else {
            LoggingInfo config = this.geoServer.getFactory().createLogging();
            config.setLevel("DEFAULT_LOGGING");
            config.setLocation("logs/geoserver.log");
            config.setStdOutLogging(true);
            this.geoServer.addListener(persister);
            this.geoServer.setLogging(config);
            this.geoServer.removeListener(persister);
        }
    }

    private void synchronizeRootServices(RootConfigPersister persister) {
        List<XStreamServiceLoader<ServiceInfo>> loaders = this.fileWalk.getServiceLoaders();
        for (XStreamServiceLoader<ServiceInfo> sloader : loaders) {
            this.synchronizeRootService(sloader, persister);
        }
    }

    private void synchronizeRootService(XStreamServiceLoader<ServiceInfo> sloader, RootConfigPersister persister) {
        Path root = this.fileWalk.getRoot();
        boolean exists = Files.exists(root.resolve(sloader.getFilename()), new LinkOption[0]);
        Object inMemory = this.geoServer.getService(sloader.getServiceClass());
        if (null != inMemory) {
            Objects.requireNonNull(inMemory.getId());
        }
        if (exists) {
            ServiceInfo persisted = this.loader.loadRootService(sloader);
            if (inMemory != null) {
                this.geoServer.remove((ServiceInfo)inMemory);
            }
            if (persisted != null) {
                this.geoServer.remove(persisted);
                this.geoServer.add(persisted);
            }
        } else if (inMemory != null) {
            this.geoServer.remove((ServiceInfo)inMemory);
            this.geoServer.addListener(persister);
            this.geoServer.add((ServiceInfo)inMemory);
            this.geoServer.removeListener(persister);
        }
    }

    private static class RootConfigPersister
    extends ConfigurationListenerAdapter {
        private ServicePersister servicePeristerListener;
        private GeoServerConfigPersister configPersisterListener;

        private RootConfigPersister() {
        }

        public static RootConfigPersister valueOf(GeoServer geoServer, List<XStreamServiceLoader<ServiceInfo>> serviceLoaders, XStreamPersister xp) {
            RootConfigPersister rp = new RootConfigPersister();
            rp.servicePeristerListener = new ServicePersister(serviceLoaders, geoServer);
            GeoServerResourceLoader resourceLoader = geoServer.getCatalog().getResourceLoader();
            xp.setCatalog(geoServer.getCatalog());
            rp.configPersisterListener = new GeoServerConfigPersister(resourceLoader, xp);
            return rp;
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return Objects.hash(this.getClass());
        }

        @Override
        public void handlePostGlobalChange(GeoServerInfo global) {
            this.configPersisterListener.handlePostGlobalChange(global);
        }

        @Override
        public void handlePostLoggingChange(LoggingInfo logging) {
            this.configPersisterListener.handlePostLoggingChange(logging);
        }

        @Override
        public void handlePostServiceChange(ServiceInfo service) {
            this.servicePeristerListener.handlePostServiceChange(service);
        }
    }
}

