/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.SpringResourceAdaptor;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.config.PropertyOverrideConfigurer;
import org.springframework.core.io.Resource;

public class GeoServerPropertyOverrideConfigurer
extends PropertyOverrideConfigurer {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.config");
    protected GeoServerDataDirectory data;

    public GeoServerPropertyOverrideConfigurer(GeoServerDataDirectory data) {
        this.data = data;
    }

    public void setLocation(Resource location) {
        try {
            location = SpringResourceAdaptor.relative(location, this.data.getResourceStore());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error reading resource " + location, e);
        }
        super.setLocation(location);
    }

    public void setLocations(Resource[] locations) {
        Resource[] newLocations = new Resource[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            try {
                newLocations[i] = SpringResourceAdaptor.relative(locations[i], this.data.getResourceStore());
                continue;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error reading resource " + locations[i], e);
                newLocations[i] = locations[i];
            }
        }
        super.setLocations(newLocations);
    }

    protected String convertPropertyValue(String property) {
        return property.replace("${GEOSERVER_DATA_DIR}", this.data.root().getPath());
    }
}

