/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.util.CloseableIterator;
import org.geotools.api.filter.Filter;
import org.geotools.util.logging.Logging;

public class CloseableIteratorAdapter<T>
implements CloseableIterator<T> {
    private static final Logger LOGGER = Logging.getLogger(CloseableIteratorAdapter.class);
    protected final Iterator<T> wrapped;
    protected Closeable whatToClose;

    public CloseableIteratorAdapter(Iterator<T> wrapped) {
        this.wrapped = wrapped;
        this.whatToClose = wrapped instanceof Closeable ? (Closeable)((Object)wrapped) : null;
    }

    public CloseableIteratorAdapter(Iterator<T> filteredNotCloseable, Closeable closeMe) {
        this.wrapped = filteredNotCloseable;
        this.whatToClose = closeMe;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.wrapped.hasNext();
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    @Override
    public T next() {
        return this.wrapped.next();
    }

    @Override
    public void remove() {
        this.wrapped.remove();
    }

    @Override
    public void close() {
        try {
            Closeables.close((Closeable)this.whatToClose, (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.whatToClose = null;
        }
    }

    protected void finalize() {
        if (this.whatToClose != null) {
            try {
                this.close();
            }
            finally {
                LOGGER.warning("There is code not closing CloseableIterator!!! Auto closing at finalize().");
            }
        }
    }

    public static <T> CloseableIterator<T> filter(Iterator<T> iterator, Filter filter) {
        Predicate<T> predicate = CloseableIteratorAdapter.filterAdapter(filter);
        return CloseableIteratorAdapter.filter(iterator, predicate);
    }

    public static <T> CloseableIterator<T> filter(Iterator<T> iterator, Predicate<T> predicate) {
        UnmodifiableIterator filteredNotCloseable = Iterators.filter(iterator, predicate);
        Closeable closeable = iterator instanceof Closeable ? (Closeable)((Object)iterator) : null;
        return new CloseableIteratorAdapter<T>(filteredNotCloseable, closeable);
    }

    public static <F, T> CloseableIterator<T> transform(Iterator<F> iterator, Function<? super F, ? extends T> function) {
        Iterator transformedNotCloseable = Iterators.transform(iterator, function);
        Closeable closeable = (Closeable)((Object)(iterator instanceof CloseableIterator ? iterator : null));
        return new CloseableIteratorAdapter<T>(transformedNotCloseable, closeable);
    }

    public static <T> CloseableIterator<T> limit(Iterator<T> iterator, int maxElements) {
        Iterator limitedNotCloseable = Iterators.limit(iterator, (int)maxElements);
        Closeable closeable = iterator instanceof Closeable ? (Closeable)((Object)iterator) : null;
        return new CloseableIteratorAdapter<T>(limitedNotCloseable, closeable);
    }

    public static void close(Iterator<?> iterator) {
        if (iterator instanceof Closeable) {
            try {
                Closeables.close((Closeable)((Closeable)((Object)iterator)), (boolean)false);
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Ignoring exception on CloseableIteratorAdapter.close()", e);
            }
        }
    }

    public static <T> CloseableIterator<T> empty() {
        Iterator empty = Collections.emptyIterator();
        return new CloseableIteratorAdapter(empty);
    }

    private static <T> Predicate<T> filterAdapter(Filter catalogPredicate) {
        return input -> catalogPredicate.evaluate(input);
    }
}

