/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.xml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vfny.geoserver.global.xml.WriterHelper;

public class WriterHelperTest {
    private ByteArrayOutputStream bos;
    private WriterHelper helper;

    @Before
    public void setUp() throws Exception {
        this.bos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(this.bos);
        this.helper = new WriterHelper((Writer)writer);
    }

    @Test
    public void testNoEscape() throws Exception {
        this.helper.textTag("title", "$%()");
        String result = this.bos.toString();
        Assert.assertEquals((Object)"<title>$%()</title>\n", (Object)result);
    }

    @Test
    public void testEscapePlain() throws Exception {
        this.helper.textTag("title", "Test < > & ' \"");
        String result = this.bos.toString();
        Assert.assertEquals((Object)"<title>Test &lt; &gt; &amp; &apos; &quot;</title>\n", (Object)result);
    }

    @Test
    public void testEscapeNewlines() throws Exception {
        this.helper.textTag("title", "<\n>\n");
        String result = this.bos.toString();
        Assert.assertEquals((Object)"<title>&lt;\n&gt;\n</title>\n", (Object)result);
    }
}

