/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.urlchecks;

import java.io.File;
import java.io.InputStream;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.urlchecks.StyleURLChecker;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.data.ows.URLCheckerException;
import org.geotools.data.ows.URLCheckers;
import org.junit.Assert;
import org.junit.Test;

public class StyleURLCheckerTest
extends GeoServerSystemTestSupport {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        testData.addStyle("burg", "burg.sld", GeoServer.class, this.getCatalog());
        try (InputStream is = GeoServer.class.getResourceAsStream("burg02.svg");){
            testData.copyTo(is, "styles/burg02.svg");
        }
        WorkspaceInfo cite = this.getCatalog().getWorkspaceByName(SystemTestData.CITE_PREFIX);
        testData.addStyle(cite, "burg", "burg.sld", GeoServer.class, this.getCatalog());
        this.getDataDirectory().getStyles(cite, new String[0]).dir().mkdirs();
        try (InputStream is = GeoServer.class.getResourceAsStream("burg02.svg");){
            testData.copyTo(is, "workspaces/cite/styles/burg02.svg");
        }
        Assert.assertNotNull((Object)applicationContext.getBean(StyleURLChecker.class));
    }

    @Test
    public void testValidStyleIcons() throws Exception {
        File root = this.getDataDirectory().root();
        URLCheckers.confirm((String)new File(root, "styles/burg02.svg").getPath());
        URLCheckers.confirm((String)new File(root, "workspaces/cite/styles/burg02.svg").getPath());
    }

    @Test
    public void testNonExistingStyleIcons() throws Exception {
        File root = this.getDataDirectory().root();
        URLCheckers.confirm((String)new File(root, "styles/foobar.svg").getPath());
        URLCheckers.confirm((String)new File(root, "workspaces/cite/styles/foobar.svg").getPath());
    }

    @Test
    public void testRelativeOutsideDataDir() throws Exception {
        File icon = new File("./target/test.png");
        StyleURLCheckerTest.assertURLException(icon);
    }

    @Test
    public void testAbsoluteOutsideDataDir() throws Exception {
        File icon = new File("./target/test.png").getCanonicalFile();
        StyleURLCheckerTest.assertURLException(icon);
    }

    @Test
    public void testOutsideDataDirectory() throws Exception {
        File root = this.getDataDirectory().root();
        StyleURLCheckerTest.assertURLException(new File(root, "workspaces/foobar/styles/../../../../test.png"));
        URLCheckers.confirm((String)new File(root, "workspaces/foobar/styles/../../../styles/test.png").getPath());
        StyleURLCheckerTest.assertURLException(new File(root, "styles/../security/data.properties"));
    }

    @Test
    public void testGlobalStylesReference() throws Exception {
        File root = this.getDataDirectory().root();
        URLCheckers.confirm((String)new File(root, "workspaces/foobar/styles/../../../styles/test.png").getPath());
    }

    @Test
    public void testOtherDirectories() throws Exception {
        File root = this.getDataDirectory().root();
        StyleURLCheckerTest.assertURLException(new File(root, "styles/../security/data.properties"));
    }

    private static void assertURLException(File file) {
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)file.getPath()));
    }
}

