/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.HTTPStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.security.impl.AbstractSandboxEnforcerTest;
import org.geotools.util.URLs;
import org.junit.Assert;

public class HTTPStoreSandboxEnforcerTest
extends AbstractSandboxEnforcerTest {
    @Override
    protected void testLocation(StoreInfo store, File location) throws Exception {
        HTTPStoreInfo http = (HTTPStoreInfo)store;
        Assert.assertEquals((Object)location, (Object)URLs.urlToFile((URL)new URL(http.getCapabilitiesURL())));
    }

    @Override
    protected void addStore(String storeName, File location) throws IOException {
        Catalog catalog = this.getCatalog();
        CatalogBuilder builder = new CatalogBuilder(catalog);
        WMSStoreInfo store = builder.buildWMSStore(storeName);
        store.setWorkspace(catalog.getDefaultWorkspace());
        store.setCapabilitiesURL(URLs.fileToUrl((File)location).toExternalForm());
        catalog.add((StoreInfo)store);
    }

    @Override
    protected void modifyStore(String storeName, File location) {
        Catalog catalog = this.getCatalog();
        WMSStoreInfo store = catalog.getWMSStoreByName(storeName);
        store.setCapabilitiesURL(URLs.fileToUrl((File)location).toExternalForm());
        catalog.save((StoreInfo)store);
    }
}

