/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.security.impl.AbstractSandboxEnforcerTest;
import org.geotools.data.property.PropertyDataStoreFactory;
import org.junit.Assert;

public class DataStoreSandboxEnforcerTest
extends AbstractSandboxEnforcerTest {
    @Override
    protected void addStore(String storeName, File location) {
        Catalog catalog = this.getCatalog();
        CatalogBuilder builder = new CatalogBuilder(catalog);
        DataStoreInfo store = builder.buildDataStore(storeName);
        store.setWorkspace(catalog.getDefaultWorkspace());
        store.getConnectionParameters().put("directory", location);
        store.setType(new PropertyDataStoreFactory().getDisplayName());
        catalog.add((StoreInfo)store);
    }

    @Override
    protected void modifyStore(String storeName, File location) {
        Catalog catalog = this.getCatalog();
        DataStoreInfo store = catalog.getDataStoreByName(storeName);
        store.getConnectionParameters().put("directory", location);
        catalog.save((StoreInfo)store);
    }

    @Override
    protected void testLocation(StoreInfo citeStore, File location) {
        Assert.assertEquals((Object)location, citeStore.getConnectionParameters().get("directory"));
    }
}

