/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.impl.DefaultFileAccessManager;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.springframework.context.ApplicationContext;

public class AbstractFileAccessTest
extends GeoServerSystemTestSupport {
    private static final String MISSING = "missing";
    protected static final String ROLE_CITE = "role_" + MockData.CITE_PREFIX;
    protected static final String ROLE_CGF = "role_" + MockData.CGF_PREFIX;
    protected static final String ROLE_CDF = "role_" + MockData.CDF_PREFIX;
    protected static final String ROLE_MISSING = "role_missing";
    protected File sandbox;
    protected File citeFolder;
    protected File cgfFolder;
    protected File cdfFolder;
    protected File missingFolder;
    protected DefaultFileAccessManager fileAccessManager;

    @Before
    public void lookupFileAccessManager() {
        this.fileAccessManager = (DefaultFileAccessManager)GeoServerExtensions.bean(DefaultFileAccessManager.class, (ApplicationContext)applicationContext);
    }

    @Before
    public void cleanupRestrictions() throws Exception {
        GeoServerDataDirectory dd = this.getDataDirectory();
        Resource layerSecurity = dd.get(new String[]{"security/layers.properties"});
        Properties properties = new Properties();
        properties.put("*.*.r", "*");
        properties.put("*.*.w", "*");
        try (OutputStream os = layerSecurity.out();){
            properties.store(os, "everyone can read and write");
        }
        System.clearProperty(DefaultFileAccessManager.GEOSERVER_DATA_SANDBOX);
        DefaultFileAccessManager fam = (DefaultFileAccessManager)GeoServerExtensions.bean(DefaultFileAccessManager.class, (ApplicationContext)applicationContext);
        fam.reload();
    }

    @Before
    public void setupDirectories() throws IOException {
        this.sandbox = new File("./target/sandbox").getCanonicalFile();
        this.citeFolder = new File(this.sandbox, MockData.CITE_PREFIX);
        this.cgfFolder = new File(this.sandbox, MockData.CGF_PREFIX);
        this.cdfFolder = new File(this.sandbox, MockData.CDF_PREFIX);
        this.missingFolder = new File(this.sandbox, MISSING);
        if (!this.citeFolder.exists()) {
            Assert.assertTrue((boolean)this.citeFolder.mkdirs());
        }
        if (!this.cgfFolder.exists()) {
            Assert.assertTrue((boolean)this.cgfFolder.mkdirs());
        }
        if (!this.cdfFolder.exists()) {
            Assert.assertTrue((boolean)this.cdfFolder.mkdirs());
        }
    }

    @Override
    @Before
    public void logout() {
        super.logout();
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        WorkspaceInfo missingWs = catalog.getFactory().createWorkspace();
        missingWs.setName(MISSING);
        catalog.add(missingWs);
        NamespaceInfo missingNs = catalog.getFactory().createNamespace();
        missingNs.setPrefix(MISSING);
        missingNs.setURI("http://www.geoserver.org/missing");
        catalog.add(missingNs);
    }

    protected void configureCiteCgfMissingAccess() throws IOException {
        Resource layerSecurity = this.getDataDirectory().get(new String[]{"security/layers.properties"});
        Properties properties = new Properties();
        properties.put("filesystemSandbox", this.sandbox.getAbsolutePath());
        properties.put("cite.*.a", ROLE_CGF);
        properties.put("cgf.*.a", ROLE_CGF);
        properties.put("missing.*.a", ROLE_MISSING);
        try (OutputStream os = layerSecurity.out();){
            properties.store(os, "sandbox");
            os.flush();
        }
        this.fileAccessManager.reload();
    }

    protected void configureCiteAccess() throws IOException {
        Resource layerSecurity = this.getDataDirectory().get(new String[]{"security/layers.properties"});
        Properties properties = new Properties();
        properties.put("filesystemSandbox", this.sandbox.getAbsolutePath());
        properties.put("cite.*.a", ROLE_CITE);
        try (OutputStream os = layerSecurity.out();){
            properties.store(os, "sandbox");
            os.flush();
        }
        this.fileAccessManager.reload();
    }

    protected void loginCiteCgfMissing() {
        this.login("cite", "pwd", ROLE_CITE, ROLE_CGF, ROLE_MISSING);
    }

    protected void loginAdmin() {
        this.login("admin", "geoserver", GeoServerRole.ADMIN_ROLE.getAuthority());
    }

    protected void loginCite() {
        this.login("cite", "pwd", ROLE_CITE);
    }
}

