/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.lang.reflect.Field;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredDataStoreInfo;
import org.geoserver.security.decorators.SecuredFeatureSource;
import org.geoserver.security.decorators.SecuredFeatureTypeInfo;
import org.geoserver.security.decorators.SecuredResourceInfoTest;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.util.ReflectionUtils;

public class SecuredFeatureTypeInfoTest
extends SecuredResourceInfoTest<FeatureTypeInfo, SecuredFeatureTypeInfo> {
    @Override
    FeatureTypeInfo createDelegate() {
        FeatureTypeInfoImpl info = new FeatureTypeInfoImpl(this.getCatalog());
        info.setStore((StoreInfo)new DataStoreInfoImpl(this.getCatalog()));
        return info;
    }

    @Override
    SecuredFeatureTypeInfo createSecuredDecorator(FeatureTypeInfo delegate) {
        return new SecuredFeatureTypeInfo(delegate, this.policy);
    }

    @Override
    Class<FeatureTypeInfo> getDelegateClass() {
        return FeatureTypeInfo.class;
    }

    @Override
    Class<SecuredFeatureTypeInfo> getSecuredDecoratorClass() {
        return SecuredFeatureTypeInfo.class;
    }

    @Override
    Class<SecuredDataStoreInfo> getSecuredStoreInfoClass() {
        return SecuredDataStoreInfo.class;
    }

    @Override
    int getStackOverflowCount() {
        return 500;
    }

    @Test
    public void testCloneAccessLimits() throws Exception {
        TestVectorAccessLimits limits = new TestVectorAccessLimits();
        WrapperPolicy wp = WrapperPolicy.readOnlyHide((AccessLimits)limits);
        FeatureTypeInfo fti = (FeatureTypeInfo)Mockito.mock(FeatureTypeInfo.class);
        FeatureSource fs = (FeatureSource)Mockito.mock(SimpleFeatureSource.class);
        Mockito.when((Object)fti.getFeatureSource(null, null)).thenReturn((Object)fs);
        SecuredFeatureTypeInfo secured = new SecuredFeatureTypeInfo(fti, wp);
        SecuredFeatureSource securedSource = (SecuredFeatureSource)secured.getFeatureSource(null, null);
        Assert.assertNotNull((Object)securedSource);
        Field policyField = ReflectionUtils.findField(SecuredFeatureSource.class, (String)"policy");
        policyField.setAccessible(true);
        WrapperPolicy fsPolicy = (WrapperPolicy)policyField.get(securedSource);
        MatcherAssert.assertThat((Object)fsPolicy.getLimits(), (Matcher)CoreMatchers.instanceOf(TestVectorAccessLimits.class));
    }

    static class TestVectorAccessLimits
    extends VectorAccessLimits {
        static final Query THE_QUERY = new Query();

        public TestVectorAccessLimits() {
            super(CatalogMode.HIDE, null, null, null, null, null);
        }

        public Query getReadQuery() {
            return THE_QUERY;
        }
    }
}

