/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.csp.predicate;

import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.csp.CSPHttpRequestWrapper;
import org.geoserver.security.csp.predicate.CSPPredicateParameter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class CSPPredicateParameterTest {
    private MockHttpServletRequest request = null;
    private CSPHttpRequestWrapper wrapper = null;

    @Before
    public void setUp() {
        this.request = new MockHttpServletRequest();
        this.wrapper = new CSPHttpRequestWrapper((HttpServletRequest)this.request, null);
    }

    @Test
    public void testConstructorInvalidKeyRegex() {
        Assert.assertThrows(PatternSyntaxException.class, () -> new CSPPredicateParameter("[", ".*"));
    }

    @Test
    public void testConstructorInvalidValueRegex() {
        Assert.assertThrows(PatternSyntaxException.class, () -> new CSPPredicateParameter(".*", "["));
    }

    @Test
    public void testPredicateMatches() {
        CSPPredicateParameter predicate = new CSPPredicateParameter("(?i)^service$", "(?i)^(wms)?$");
        this.request.removeAllParameters();
        Assert.assertTrue((boolean)predicate.test(this.wrapper));
        this.request.removeAllParameters();
        this.request.setParameter("SeRvIcE", "");
        Assert.assertTrue((boolean)predicate.test(this.wrapper));
        this.request.removeAllParameters();
        this.request.setParameter("service", "wms");
        Assert.assertTrue((boolean)predicate.test(this.wrapper));
        this.request.removeAllParameters();
        this.request.setParameter("SERVICE", "WMS");
        Assert.assertTrue((boolean)predicate.test(this.wrapper));
        this.request.removeAllParameters();
        this.request.setParameter("service", "wms");
        this.request.setParameter("SERVICE", "WMS");
        Assert.assertTrue((boolean)predicate.test(this.wrapper));
    }

    @Test
    public void testPredicateNotMatches() {
        CSPPredicateParameter predicate = new CSPPredicateParameter("(?i)^service$", "(?i)^(wms)?$");
        this.request.setParameter("service", "wfs");
        Assert.assertFalse((boolean)predicate.test(this.wrapper));
        this.request.removeAllParameters();
        this.request.setParameter("SERVICE", "WFS");
        Assert.assertFalse((boolean)predicate.test(this.wrapper));
        this.request.removeAllParameters();
        this.request.setParameter("service", "wms");
        this.request.setParameter("SERVICE", "WFS");
        Assert.assertFalse((boolean)predicate.test(this.wrapper));
    }
}

