/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.csp;

import javax.servlet.http.HttpServletResponse;
import org.geoserver.security.csp.CSPConfiguration;
import org.geoserver.security.csp.CSPHttpResponseWrapper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class CSPHttpResponseWrapperTest {
    @Mock
    private HttpServletResponse response;
    private CSPHttpResponseWrapper wrapper;
    private CSPConfiguration config;
    private AutoCloseable closeable;

    @Before
    public void setUp() {
        this.closeable = MockitoAnnotations.openMocks((Object)this);
        this.config = new CSPConfiguration();
        this.config.setReportOnly(false);
        this.wrapper = new CSPHttpResponseWrapper(this.response, this.config);
    }

    @After
    public void tearDown() throws Exception {
        this.closeable.close();
    }

    @Test
    public void testNotCSP() throws Exception {
        this.wrapper.setHeader("Content-Type", "text/plain");
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Content-Type", "text/plain");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).getHeader("Content-Type");
    }

    @Test
    public void testCSPDisabledWithOverride() throws Exception {
        this.config.setEnabled(false);
        this.config.setAllowOverride(true);
        String csp = "base-uri 'self'; default-src 'self';, frame-ancestors 'self';";
        this.wrapper.setHeader("Content-Security-Policy", csp);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).getHeader("Content-Security-Policy");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).getHeader("Content-Security-Policy-Report-Only");
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Content-Security-Policy", csp);
    }

    @Test
    public void testCSPDisabledWithoutOverride() throws Exception {
        this.config.setEnabled(false);
        String csp = "base-uri 'self'; default-src 'self';, frame-ancestors 'self';";
        this.wrapper.setHeader("Content-Security-Policy", csp);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).getHeader("Content-Security-Policy");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).getHeader("Content-Security-Policy-Report-Only");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).setHeader("Content-Security-Policy", csp);
    }

    @Test
    public void testCSPReportDisabledWithOverride() throws Exception {
        this.config.setEnabled(false);
        this.config.setAllowOverride(true);
        String csp = "base-uri 'self'; default-src 'self';, frame-ancestors 'self';";
        this.wrapper.setHeader("Content-Security-Policy-Report-Only", csp);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).getHeader("Content-Security-Policy");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).getHeader("Content-Security-Policy-Report-Only");
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Content-Security-Policy-Report-Only", csp);
    }

    @Test
    public void testCSPReportDisabledWithoutOverride() throws Exception {
        this.config.setEnabled(false);
        String csp = "base-uri 'self'; default-src 'self';, frame-ancestors 'self';";
        this.wrapper.setHeader("Content-Security-Policy-Report-Only", csp);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).getHeader("Content-Security-Policy");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).getHeader("Content-Security-Policy-Report-Only");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).setHeader("Content-Security-Policy-Report-Only", csp);
    }

    @Test
    public void testCSPNotSet() throws Exception {
        String csp = "base-uri 'self'; default-src 'self';, frame-ancestors 'self';";
        this.wrapper.setHeader("Content-Security-Policy", csp);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Content-Security-Policy", csp);
    }

    @Test
    public void testCSPReportNotSet() throws Exception {
        this.config.setReportOnly(true);
        String csp = "base-uri 'self'; default-src 'self';, frame-ancestors 'self';";
        this.wrapper.setHeader("Content-Security-Policy-Report-Only", csp);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Content-Security-Policy-Report-Only", csp);
    }

    @Test
    public void testCSPWithoutMerge() throws Exception {
        String csp2;
        String csp1 = "base-uri 'self'; default-src 'self';, frame-ancestors 'self';";
        String csp3 = csp2 = "base-uri 'none'; default-src 'none';, frame-ancestors 'none';";
        Mockito.when((Object)this.response.getHeader("Content-Security-Policy")).thenReturn((Object)csp1);
        this.wrapper.setHeader("Content-Security-Policy", csp2);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Content-Security-Policy", csp3);
    }

    @Test
    public void testCSPReportWithoutMerge() throws Exception {
        String csp2;
        this.config.setReportOnly(true);
        String csp1 = "base-uri 'self'; default-src 'self';, frame-ancestors 'self';";
        String csp3 = csp2 = "base-uri 'none'; default-src 'none';, frame-ancestors 'none';";
        Mockito.when((Object)this.response.getHeader("Content-Security-Policy-Report-Only")).thenReturn((Object)csp1);
        this.wrapper.setHeader("Content-Security-Policy-Report-Only", csp2);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Content-Security-Policy-Report-Only", csp3);
    }

    @Test
    public void testCSPWithMerge() throws Exception {
        String csp1 = "base-uri 'self'; default-src 'self';, frame-ancestors 'self';";
        String csp2 = "base-uri 'none'; form-action 'none'; default-src 'none';";
        String csp3 = "base-uri 'none'; form-action 'none'; default-src 'none';, frame-ancestors 'self';";
        Mockito.when((Object)this.response.getHeader("Content-Security-Policy")).thenReturn((Object)csp1);
        this.wrapper.setHeader("Content-Security-Policy", csp2);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Content-Security-Policy", csp3);
    }

    @Test
    public void testCSPReportWithMerge() throws Exception {
        this.config.setReportOnly(true);
        String csp1 = "base-uri 'self'; default-src 'self';, frame-ancestors 'self';";
        String csp2 = "base-uri 'none'; form-action 'none'; default-src 'none';";
        String csp3 = "base-uri 'none'; form-action 'none'; default-src 'none';, frame-ancestors 'self';";
        Mockito.when((Object)this.response.getHeader("Content-Security-Policy-Report-Only")).thenReturn((Object)csp1);
        this.wrapper.setHeader("Content-Security-Policy-Report-Only", csp2);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Content-Security-Policy-Report-Only", csp3);
    }

    @Test
    public void testCSPOverride() throws Exception {
        this.config.setAllowOverride(true);
        String csp1 = "base-uri 'self'; default-src 'self';, frame-ancestors 'self';";
        String csp2 = "base-uri 'none'; form-action 'none'; default-src 'none';";
        Mockito.when((Object)this.response.getHeader("Content-Security-Policy")).thenReturn((Object)csp1);
        this.wrapper.setHeader("Content-Security-Policy", csp2);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Content-Security-Policy", csp2);
    }

    @Test
    public void testCSPReportOverride() throws Exception {
        this.config.setAllowOverride(true);
        this.config.setReportOnly(true);
        String csp1 = "base-uri 'self'; default-src 'self';, frame-ancestors 'self';";
        String csp2 = "base-uri 'none'; form-action 'none'; default-src 'none';";
        Mockito.when((Object)this.response.getHeader("Content-Security-Policy-Report-Only")).thenReturn((Object)csp1);
        this.wrapper.setHeader("Content-Security-Policy-Report-Only", csp2);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Content-Security-Policy-Report-Only", csp2);
    }
}

