/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.geoserver.filters.HTTPMethodFilter;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class HTTPMethodFilterTest {
    @Test
    public void testGETRequest() throws Exception {
        MockHttpServletResponse response = this.getResponseByMethod("GET");
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testPOSTRequest() throws Exception {
        MockHttpServletResponse response = this.getResponseByMethod("POST");
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testPUTRequest() throws Exception {
        MockHttpServletResponse response = this.getResponseByMethod("PUT");
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testDELETERequest() throws Exception {
        MockHttpServletResponse response = this.getResponseByMethod("DELETE");
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testHEADRequest() throws Exception {
        MockHttpServletResponse response = this.getResponseByMethod("HEAD");
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testOPTIONSRequest() throws Exception {
        MockHttpServletResponse response = this.getResponseByMethod("OPTIONS");
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testPATCHRequest() throws Exception {
        MockHttpServletResponse response = this.getResponseByMethod("PATCH");
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testInvalidRequest() throws Exception {
        MockHttpServletResponse response = this.getResponseByMethod("PROPFIND");
        Assert.assertEquals((long)405L, (long)response.getStatus());
        response = this.getResponseByMethod("ACL");
        Assert.assertEquals((long)405L, (long)response.getStatus());
        response = this.getResponseByMethod("MKCALENDAR");
        Assert.assertEquals((long)405L, (long)response.getStatus());
        response = this.getResponseByMethod("LINK");
        Assert.assertEquals((long)405L, (long)response.getStatus());
        response = this.getResponseByMethod("BREW");
        Assert.assertEquals((long)405L, (long)response.getStatus());
        response = this.getResponseByMethod("WHEN");
        Assert.assertEquals((long)405L, (long)response.getStatus());
    }

    private MockHttpServletResponse getResponseByMethod(String method) throws ServletException, IOException {
        MockHttpServletRequest request = new MockHttpServletRequest(method, "http://www.geoserver.org");
        MockHttpServletResponse response = new MockHttpServletResponse();
        response.setContentType("text/plain");
        HTTPMethodFilter filter = new HTTPMethodFilter();
        MockFilterChain chain = new MockFilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                ServletOutputStream os = response.getOutputStream();
                os.print("Some random text");
                os.close();
                os.flush();
            }
        };
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        return response;
    }
}

