/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import java.util.ArrayList;
import java.util.Arrays;
import org.geoserver.feature.CompositeFeatureCollection;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.junit.Assert;
import org.junit.Test;

public class CompositeFeatureCollectionTest
extends DataTestCase {
    @Test
    public void testCompositeEmpty() {
        CompositeFeatureCollection fc = new CompositeFeatureCollection(new ArrayList());
        Assert.assertEquals((long)0L, (long)fc.size());
        Assert.assertNull((Object)fc.getBounds());
        Assert.assertNull((Object)DataUtilities.first((FeatureCollection)fc));
    }

    @Test
    public void testComposeOne() {
        CompositeFeatureCollection fc = new CompositeFeatureCollection(Arrays.asList(DataUtilities.collection((SimpleFeature)this.riverFeatures[0])));
        Assert.assertEquals((long)1L, (long)fc.size());
        Assert.assertEquals((Object)new ReferencedEnvelope(5.0, 13.0, 3.0, 7.0, this.riverType.getCoordinateReferenceSystem()), (Object)fc.getBounds());
        Assert.assertEquals((Object)this.riverFeatures[0], (Object)DataUtilities.first((FeatureCollection)fc));
    }

    @Test
    public void testComposeMany() {
        SimpleFeatureCollection roads = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        SimpleFeatureCollection rivers = DataUtilities.collection((SimpleFeature[])this.riverFeatures);
        SimpleFeatureCollection lakes = DataUtilities.collection((SimpleFeature[])this.lakeFeatures);
        CompositeFeatureCollection fc = new CompositeFeatureCollection(Arrays.asList(roads, rivers, lakes));
        Assert.assertEquals((long)6L, (long)fc.size());
        Assert.assertEquals((Object)new ReferencedEnvelope(1.0, 16.0, 0.0, 10.0, this.riverType.getCoordinateReferenceSystem()), (Object)fc.getBounds());
        Assert.assertEquals((Object)this.roadFeatures[0], (Object)DataUtilities.first((FeatureCollection)fc));
    }
}

