/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class XStreamPersisterIntegrationTest
extends GeoServerSystemTestSupport {
    private XStreamPersister persister;

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Before
    public void setupPersister() {
        this.persister = new XStreamPersister();
        this.persister.setEncryptPasswordFields(true);
    }

    @Test
    public void testWmsStorePasswordEncryption() throws Exception {
        WMSStoreInfo wms = this.buildWmsStore();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.persister.save((Object)wms, (OutputStream)out);
        Document dom = this.dom(new ByteArrayInputStream(out.toByteArray()));
        XMLAssert.assertXpathExists((String)"/wmsStore/password", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/wmsStore[password = 'password']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/wmsStore[starts-with(password, 'crypt1:')]", (Document)dom);
        WMSStoreInfo loaded = (WMSStoreInfo)this.persister.load((InputStream)new ByteArrayInputStream(out.toByteArray()), WMSStoreInfo.class);
        Assert.assertEquals((Object)"password", (Object)loaded.getPassword());
    }

    @Test
    public void testWmsStoreBackwardsCompatibility() throws Exception {
        WMSStoreInfo wms = this.buildWmsStore();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.persister.setEncryptPasswordFields(false);
        this.persister.save((Object)wms, (OutputStream)out);
        Document dom = this.dom(new ByteArrayInputStream(out.toByteArray()));
        this.print(dom);
        XMLAssert.assertXpathExists((String)"/wmsStore/password", (Document)dom);
        XMLAssert.assertXpathExists((String)"/wmsStore[password = 'password']", (Document)dom);
        this.persister.setEncryptPasswordFields(true);
        WMSStoreInfo loaded = (WMSStoreInfo)this.persister.load((InputStream)new ByteArrayInputStream(out.toByteArray()), WMSStoreInfo.class);
        Assert.assertEquals((Object)"password", (Object)loaded.getPassword());
        this.persister.setEncryptPasswordFields(false);
        WMSStoreInfo loaded2 = (WMSStoreInfo)this.persister.load((InputStream)new ByteArrayInputStream(out.toByteArray()), WMSStoreInfo.class);
        Assert.assertEquals((Object)"password", (Object)loaded2.getPassword());
    }

    private WMSStoreInfo buildWmsStore() {
        GeoServerExtensionsHelper.setIsSpringContext(false);
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        WMSStoreInfo wms = cFactory.createWebMapServer();
        wms.setName("bar");
        wms.setWorkspace(ws);
        wms.setCapabilitiesURL("http://fake.host/wms?request=GetCapabilities&service=wms");
        wms.setUsername("user");
        wms.setPassword("password");
        return wms;
    }

    @Test
    public void testProxyUseHeaderMigrationOnRead() throws Exception {
        try (InputStream is = this.getClass().getResourceAsStream("global.xml");){
            GeoServerInfoImpl info = (GeoServerInfoImpl)this.persister.load(is, GeoServerInfoImpl.class);
            Assert.assertTrue((boolean)info.isUseHeadersProxyURL());
            Assert.assertTrue((boolean)info.getSettings().isUseHeadersProxyURL());
            Assert.assertNull((Object)info.getUseHeadersProxyURLRaw());
        }
    }

    @Test
    public void testProxyUseHeaderMigrationOnWrite() throws Exception {
        GeoServerInfoImpl info = new GeoServerInfoImpl();
        info.setUseHeadersProxyURLRaw(Boolean.valueOf(true));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.persister.save((Object)info, (OutputStream)bos);
        String xml = new String(bos.toByteArray(), StandardCharsets.UTF_8);
        Document doc = XMLUnit.buildTestDocument((String)xml);
        XMLAssert.assertXpathNotExists((String)"/global/useHeadersProxyURL", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/global/settings/useHeadersProxyURL", (Document)doc);
    }
}

