/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.impl.AuthorityURL;
import org.geoserver.config.util.AuthorityURLInfoInfoListConverter;
import org.junit.Assert;
import org.junit.Test;

public class AuthorityURLInfoInfoListConverterTest {
    @Test
    public void testFromString() {
        String serialized = "[{\"name\":\"auth1\",\"href\":\"http://geoserver.org/auth1?\"},{\"name\":\"auth2\",\"href\":\"http://geoserver.org/auth2;someparam=somevalue&\"}]";
        ArrayList<AuthorityURL> expected = new ArrayList<AuthorityURL>();
        AuthorityURL auth1 = new AuthorityURL();
        auth1.setName("auth1");
        auth1.setHref("http://geoserver.org/auth1?");
        expected.add(auth1);
        AuthorityURL auth2 = new AuthorityURL();
        auth2.setName("auth2");
        auth2.setHref("http://geoserver.org/auth2;someparam=somevalue&");
        expected.add(auth2);
        List actual = AuthorityURLInfoInfoListConverter.fromString((String)"[{\"name\":\"auth1\",\"href\":\"http://geoserver.org/auth1?\"},{\"name\":\"auth2\",\"href\":\"http://geoserver.org/auth2;someparam=somevalue&\"}]");
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testFromInvalidString() {
        String serialized = "[{\"name:\"auth1\",\"href\":\"http://geoserver.org/auth1?\"},]";
        try {
            AuthorityURLInfoInfoListConverter.fromString((String)"[{\"name:\"auth1\",\"href\":\"http://geoserver.org/auth1?\"},]");
            Assert.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testToString() {
        ArrayList<AuthorityURL> list = new ArrayList<AuthorityURL>();
        AuthorityURL auth1 = new AuthorityURL();
        auth1.setName("auth1");
        auth1.setHref("http://geoserver.org/auth1?");
        list.add(auth1);
        AuthorityURL auth2 = new AuthorityURL();
        auth2.setName("auth2");
        auth2.setHref("http://geoserver.org/auth2;someparam=somevalue&");
        list.add(auth2);
        String actual = AuthorityURLInfoInfoListConverter.toString(list);
        String expected = "[{\"name\":\"auth1\",\"href\":\"http://geoserver.org/auth1?\"},{\"name\":\"auth2\",\"href\":\"http://geoserver.org/auth2;someparam=somevalue&\"}]";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testToStringListWithNullElement() {
        ArrayList<AuthorityURL> list = new ArrayList<AuthorityURL>();
        AuthorityURL auth1 = new AuthorityURL();
        auth1.setName("auth1");
        auth1.setHref("http://geoserver.org/auth1?");
        list.add(auth1);
        list.add(null);
        String actual = AuthorityURLInfoInfoListConverter.toString(list);
        String expected = "[{\"name\":\"auth1\",\"href\":\"http://geoserver.org/auth1?\"}]";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testToStringListWithOnlyNullElements() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(null);
        list.add(null);
        list.add(null);
        Assert.assertNull((Object)AuthorityURLInfoInfoListConverter.toString(list));
    }

    @Test
    public void testToStringEmptyList() {
        ArrayList list = new ArrayList();
        String actual = AuthorityURLInfoInfoListConverter.toString(list);
        Assert.assertNull((Object)actual);
    }
}

