/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.datadir;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.geoserver.GeoServerConfigurationLock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.Info;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.datadir.DataDirectoryGeoServerLoader;
import org.geoserver.config.datadir.DataDirectoryLoaderTestSupport;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.TestSetup;
import org.geoserver.test.TestSetupFrequency;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

@TestSetup(run=TestSetupFrequency.REPEAT)
public class DefaultGeoServerLoaderCompatibilityTest
extends GeoServerSystemTestSupport {
    DataDirectoryLoaderTestSupport support;

    @BeforeClass
    public static void disableDatadirLoader() {
        System.setProperty("GEOSERVER_DATA_DIR_LOADER_ENABLED", "false");
    }

    @AfterClass
    public static void clearSystemProp() {
        System.clearProperty("GEOSERVER_DATA_DIR_LOADER_ENABLED");
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        Catalog catalog = this.getCatalog();
        GeoServer geoServer = this.getGeoServer();
        this.support = new DataDirectoryLoaderTestSupport(catalog, geoServer);
        this.support.setUpServiceLoaders();
        geoServer.add((ServiceInfo)this.support.serviceInfo1(null, "service1", geoServer));
        geoServer.add((ServiceInfo)this.support.serviceInfo2(null, "service2", geoServer));
    }

    @Before
    public void preflight() {
        Assert.assertNull((Object)GeoServerExtensions.bean(GeoServerLoader.class));
    }

    @After
    public void after() {
        this.support.tearDown();
    }

    private DataDirectoryGeoServerLoader newLoader() {
        GeoServerSecurityManager secManager = this.getSecurityManager();
        GeoServerConfigurationLock configLock = new GeoServerConfigurationLock();
        GeoServerDataDirectory dataDirectory = super.getDataDirectory();
        return new DataDirectoryGeoServerLoader(dataDirectory, secManager, configLock);
    }

    @Test
    public void testCatalogEquality() {
        Catalog defaultLoaderCatalog = super.getCatalog();
        this.addLayerGroup(defaultLoaderCatalog);
        DataDirectoryGeoServerLoader loader = this.newLoader();
        CatalogImpl datadirLoaderCatalog = new CatalogImpl();
        loader.postProcessBeforeInitialization((Object)datadirLoaderCatalog, "catalog");
        this.checkEquals(defaultLoaderCatalog.getWorkspaces(), datadirLoaderCatalog.getWorkspaces());
        this.checkEquals(defaultLoaderCatalog.getNamespaces(), datadirLoaderCatalog.getNamespaces());
        this.checkEquals(defaultLoaderCatalog.getStyles(), datadirLoaderCatalog.getStyles());
        this.checkEquals(defaultLoaderCatalog.getStores(StoreInfo.class), datadirLoaderCatalog.getStores(StoreInfo.class));
        this.checkEquals(defaultLoaderCatalog.getResources(ResourceInfo.class), datadirLoaderCatalog.getResources(ResourceInfo.class));
        this.checkEquals(defaultLoaderCatalog.getLayers(), datadirLoaderCatalog.getLayers());
        this.checkEquals(defaultLoaderCatalog.getLayerGroups(), datadirLoaderCatalog.getLayerGroups());
        Assert.assertEquals((Object)defaultLoaderCatalog.getDefaultWorkspace(), (Object)datadirLoaderCatalog.getDefaultWorkspace());
        Assert.assertEquals((Object)defaultLoaderCatalog.getDefaultNamespace(), (Object)datadirLoaderCatalog.getDefaultNamespace());
        for (WorkspaceInfo ws : defaultLoaderCatalog.getWorkspaces()) {
            DataStoreInfo expected = defaultLoaderCatalog.getDefaultDataStore(ws);
            DataStoreInfo actual = datadirLoaderCatalog.getDefaultDataStore(ws);
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    private void addLayerGroup(Catalog catalog) {
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.setName("lg1");
        lg.setTitle("lg1");
        lg.getLayers().addAll(catalog.getLayers());
        catalog.add(lg);
    }

    @Test
    public void testConfigEquality() {
        DataDirectoryGeoServerLoader loader = this.newLoader();
        CatalogImpl datadirLoaderCatalog = new CatalogImpl();
        loader.postProcessBeforeInitialization((Object)datadirLoaderCatalog, "catalog");
        GeoServerImpl datadirLoaderGeoServer = new GeoServerImpl();
        datadirLoaderGeoServer.setCatalog((Catalog)datadirLoaderCatalog);
        loader.postProcessBeforeInitialization((Object)datadirLoaderGeoServer, "geoServer");
        GeoServer defaultLoaderGeoServer = this.getGeoServer();
        Assert.assertEquals((Object)defaultLoaderGeoServer.getGlobal(), (Object)datadirLoaderGeoServer.getGlobal());
        Assert.assertEquals((Object)defaultLoaderGeoServer.getSettings(), (Object)datadirLoaderGeoServer.getSettings());
        Assert.assertEquals((Object)defaultLoaderGeoServer.getLogging(), (Object)datadirLoaderGeoServer.getLogging());
        this.checkEquals(defaultLoaderGeoServer.getServices(), datadirLoaderGeoServer.getServices());
    }

    private void checkEquals(Collection<? extends Info> expected, Collection<? extends Info> actual) {
        MatcherAssert.assertThat((Object)expected.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Map<String, Info> expectedMap = this.toIdMap(expected);
        Map<String, Info> actualMap = this.toIdMap(expected);
        Assert.assertEquals(expectedMap.keySet(), actualMap.keySet());
        for (Info e : expectedMap.values()) {
            Info a = actualMap.get(e.getId());
            e = (Info)ModificationProxy.unwrap((Object)e);
            a = (Info)ModificationProxy.unwrap((Object)a);
            Assert.assertEquals((Object)e, (Object)a);
        }
    }

    private Map<String, Info> toIdMap(Collection<? extends Info> infos) {
        return infos.stream().collect(Collectors.toMap(Info::getId, Function.identity()));
    }
}

