/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.datadir;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.geoserver.GeoServerConfigurationLock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.Info;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.catalog.impl.WMSStoreInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.GeoServerLoaderProxy;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.datadir.DataDirectoryGeoServerLoader;
import org.geoserver.config.datadir.DataDirectoryLoaderTestSupport;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.TestSetup;
import org.geoserver.test.TestSetupFrequency;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

@TestSetup(run=TestSetupFrequency.REPEAT)
public class DataDirectoryGeoServerLoaderTest
extends GeoServerSystemTestSupport {
    DataDirectoryLoaderTestSupport support;

    @Before
    public void preflight() {
        Assert.assertTrue((boolean)DataDirectoryGeoServerLoader.isEnabled((ApplicationContext)applicationContext));
        Logging.getLogger((String)DataDirectoryGeoServerLoader.class.getPackage().getName()).setLevel(Level.CONFIG);
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        Catalog catalog = this.getCatalog();
        GeoServer geoServer = this.getGeoServer();
        this.support = new DataDirectoryLoaderTestSupport(catalog, geoServer);
        this.support.setUpServiceLoaders();
    }

    @Override
    protected void onTearDown(SystemTestData testData) throws Exception {
        this.support.tearDown();
    }

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpDefault();
        testData.setUpDefaultRasterLayers();
    }

    @Test
    public void testCatalogLoaded() {
        Stream.concat(Arrays.stream(CiteTestData.TYPENAMES), Stream.of(CiteTestData.TASMANIA_DEM, CiteTestData.TASMANIA_BM, CiteTestData.ROTATED_CAD, CiteTestData.WORLD, SystemTestData.MULTIBAND)).forEach(this::assertLayerLoaded);
    }

    private void assertLayerLoaded(QName typeName) {
        Catalog catalog = this.getCatalog();
        String prefix = typeName.getPrefix();
        String name = typeName.getLocalPart();
        String prefixedName = String.format("%s:%s", prefix, name);
        Assert.assertNotNull((Object)catalog.getWorkspaceByName(prefix));
        Assert.assertNotNull((Object)catalog.getLayerByName(prefixedName));
    }

    private GeoServerLoaderProxy getLoader() {
        return (GeoServerLoaderProxy)GeoServerExtensions.bean(GeoServerLoaderProxy.class);
    }

    @Test
    public void reload() throws Exception {
        WorkspaceInfo ws1 = (WorkspaceInfo)this.getCatalog().getWorkspaces().get(0);
        GeoServerDataDirectory dataDirectory = this.getDataDirectory();
        dataDirectory.config(ws1).delete();
        this.getLoader().reload();
        Assert.assertNull((Object)this.getCatalog().getWorkspace(ws1.getId()));
    }

    @Test
    public void loadCatalog() {
        DataDirectoryGeoServerLoader loader = this.newLoader();
        CatalogImpl newCatalog = new CatalogImpl();
        loader.postProcessBeforeInitialization((Object)newCatalog, "catalog");
        Catalog catalog = super.getCatalog();
        this.assertSameSize(catalog.getWorkspaces(), newCatalog.getWorkspaces());
        this.assertSameSize(catalog.getNamespaces(), newCatalog.getNamespaces());
        this.assertSameSize(catalog.getStyles(), newCatalog.getStyles());
        this.assertSameSize(catalog.getStores(StoreInfo.class), newCatalog.getStores(StoreInfo.class));
        this.assertSameSize(catalog.getResources(ResourceInfo.class), newCatalog.getResources(ResourceInfo.class));
        this.assertSameSize(catalog.getLayers(), newCatalog.getLayers());
        this.assertSameSize(catalog.getLayerGroups(), newCatalog.getLayerGroups());
    }

    @Test
    public void loadCatalogResolvedCatalogProperties() {
        DataDirectoryGeoServerLoader loader = this.newLoader();
        CatalogImpl newCatalog = new CatalogImpl();
        loader.postProcessBeforeInitialization((Object)newCatalog, "catalog");
        newCatalog.getStores(StoreInfo.class).forEach(s -> Assert.assertSame((Object)newCatalog, (Object)s.getCatalog()));
        newCatalog.getResources(ResourceInfo.class).forEach(s -> Assert.assertSame((Object)newCatalog, (Object)s.getCatalog()));
        newCatalog.getStyles().forEach(s -> Assert.assertSame((Object)newCatalog, (Object)((StyleInfoImpl)ModificationProxy.unwrap((Object)s)).getCatalog()));
    }

    private void assertSameSize(Collection<? extends CatalogInfo> expected, Collection<? extends CatalogInfo> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
    }

    @Test
    public void loadCatalogDecryptsStoreInfoPasswords() {
        Catalog catalog = super.getCatalog();
        WorkspaceInfo testWs = this.support.addWorkspace("testWs1");
        DataStoreInfoImpl infoWithPassword = this.support.createPostgisStore(testWs);
        infoWithPassword.setEnabled(false);
        String pwdParam = JDBCDataStoreFactory.PASSWD.key;
        String plainPwd = (String)infoWithPassword.getConnectionParameters().get(pwdParam);
        catalog.add((StoreInfo)infoWithPassword);
        infoWithPassword = catalog.getDataStore(infoWithPassword.getId());
        this.assertPasswordEncrypted((DataStoreInfo)infoWithPassword);
        DataDirectoryGeoServerLoader loader = this.newLoader();
        CatalogImpl newCatalog = new CatalogImpl();
        loader.postProcessBeforeInitialization((Object)newCatalog, "catalog");
        DataStoreInfo depersistedWithDataDirLoader = newCatalog.getDataStore(infoWithPassword.getId());
        Assert.assertNotNull((Object)depersistedWithDataDirLoader);
        Assert.assertEquals((Object)plainPwd, depersistedWithDataDirLoader.getConnectionParameters().get(pwdParam));
    }

    @Test
    public void loadCatalogDecryptsHTTPStoreInfoPasswords() {
        Catalog catalog = super.getCatalog();
        String plainPassword = "passW0rd";
        WMSStoreInfo wmsstore = catalog.getFactory().createWebMapServer();
        wmsstore.setName("wmsstore");
        wmsstore.setCapabilitiesURL("http://localhost/wms?request=GetCapabilities");
        wmsstore.setUsername("user");
        wmsstore.setPassword("passW0rd");
        catalog.add((StoreInfo)wmsstore);
        WMSStoreInfo store = (WMSStoreInfo)catalog.getStore(wmsstore.getId(), WMSStoreInfo.class);
        this.assertPasswordEncrypted(store);
        DataDirectoryGeoServerLoader loader = this.newLoader();
        CatalogImpl newCatalog = new CatalogImpl();
        loader.postProcessBeforeInitialization((Object)newCatalog, "catalog");
        WMSStoreInfo depersistedWithDataDirLoader = (WMSStoreInfo)newCatalog.getStore(store.getId(), WMSStoreInfo.class);
        Assert.assertNotNull((Object)depersistedWithDataDirLoader);
        Assert.assertEquals((Object)"passW0rd", (Object)depersistedWithDataDirLoader.getPassword());
    }

    @Test
    public void loadConfig() {
        GeoServer geoServer = this.getGeoServer();
        WorkspaceInfo ws1 = this.support.addWorkspace("testWs1");
        WorkspaceInfo ws2 = this.support.addWorkspace("testWs2");
        geoServer.add(this.support.createSettings(ws1));
        geoServer.add(this.support.createSettings(ws2));
        geoServer.add((ServiceInfo)this.support.serviceInfo1(null, "service1", geoServer));
        geoServer.add((ServiceInfo)this.support.serviceInfo2(null, "service2", geoServer));
        geoServer.add((ServiceInfo)this.support.serviceInfo1(ws1, "service1", geoServer));
        geoServer.add((ServiceInfo)this.support.serviceInfo2(ws1, "service2", geoServer));
        geoServer.add((ServiceInfo)this.support.serviceInfo1(ws2, "service1", geoServer));
        geoServer.add((ServiceInfo)this.support.serviceInfo2(ws2, "service2", geoServer));
        DataDirectoryGeoServerLoader loader = this.newLoader();
        GeoServerImpl newGs = new GeoServerImpl();
        newGs.setCatalog((Catalog)new CatalogImpl());
        newGs.getCatalog().setResourceLoader(this.getCatalog().getResourceLoader());
        this.support.setUpServiceLoaders((GeoServer)newGs);
        loader.postProcessBeforeInitialization((Object)newGs.getCatalog(), "catalog");
        loader.postProcessBeforeInitialization((Object)newGs, "geoServer");
        Assert.assertEquals((Object)geoServer.getGlobal(), (Object)newGs.getGlobal());
        Assert.assertEquals((Object)geoServer.getSettings(), (Object)newGs.getSettings());
        Assert.assertEquals((Object)geoServer.getLogging(), (Object)newGs.getLogging());
        Assert.assertNotNull((Object)newGs.getService(DataDirectoryLoaderTestSupport.TestService1.class));
        Assert.assertNotNull((Object)newGs.getService(DataDirectoryLoaderTestSupport.TestService2.class));
        ws1 = Objects.requireNonNull(newGs.getCatalog().getWorkspaceByName(ws1.getName()));
        ws2 = Objects.requireNonNull(newGs.getCatalog().getWorkspaceByName(ws2.getName()));
        Assert.assertNotNull((Object)newGs.getSettings(ws1));
        Assert.assertNotNull((Object)newGs.getSettings(ws2));
        Assert.assertNotNull((Object)newGs.getService(DataDirectoryLoaderTestSupport.TestService1.class));
        Assert.assertNotNull((Object)newGs.getService(DataDirectoryLoaderTestSupport.TestService2.class));
        Assert.assertNotNull((Object)newGs.getService(ws1, DataDirectoryLoaderTestSupport.TestService1.class));
        Assert.assertNotNull((Object)newGs.getService(ws1, DataDirectoryLoaderTestSupport.TestService2.class));
        Assert.assertNotNull((Object)newGs.getService(ws2, DataDirectoryLoaderTestSupport.TestService1.class));
        Assert.assertNotNull((Object)newGs.getService(ws2, DataDirectoryLoaderTestSupport.TestService2.class));
    }

    @Test
    public void testAssignsDefaultWorkspace() throws Exception {
        this.deleteDefaultWorkspaceFile();
        Catalog catalog = this.getCatalog();
        this.getLoader().reload();
        Assert.assertNotNull((Object)catalog.getDefaultWorkspace());
    }

    @Test
    public void testAssignsDefaultWorkspaceIsPredictably() throws Exception {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo abc = this.addWorkspace("abc");
        SortBy sortByName = Predicates.sortBy((String)"name", (boolean)true);
        try (CloseableIterator list = catalog.list(WorkspaceInfo.class, Predicates.acceptAll(), Integer.valueOf(0), Integer.valueOf(1), sortByName);){
            Assert.assertTrue((boolean)list.hasNext());
            WorkspaceInfo ws = (WorkspaceInfo)list.next();
            Assert.assertEquals((Object)abc, (Object)ws);
        }
        this.deleteDefaultWorkspaceFile();
        this.assertDefaultWorkspace(abc);
        WorkspaceInfo aaa = this.addWorkspace("aaa");
        this.deleteDefaultWorkspaceFile();
        this.assertDefaultWorkspace(aaa);
        catalog.remove(catalog.getNamespaceByPrefix(aaa.getName()));
        catalog.remove(aaa);
        this.assertDefaultWorkspace(abc);
    }

    private void assertDefaultWorkspace(WorkspaceInfo expected) throws Exception {
        this.getLoader().reload();
        Catalog catalog = this.getCatalog();
        Assert.assertNotNull((Object)catalog.getWorkspaceByName(expected.getName()));
        Assert.assertEquals((Object)expected, (Object)catalog.getDefaultWorkspace());
    }

    private void deleteDefaultWorkspaceFile() {
        Resource defaultWorkspaceConfig = this.getDataDirectory().defaultWorkspaceConfig();
        Assert.assertTrue((boolean)defaultWorkspaceConfig.delete());
    }

    private WorkspaceInfo addWorkspace(String name) {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo ws = catalog.getFactory().createWorkspace();
        ws.setName(name);
        catalog.add(ws);
        NamespaceInfo ns = catalog.getFactory().createNamespace();
        ns.setPrefix(ws.getName());
        ns.setURI(ws.getName());
        catalog.add(ns);
        return ws;
    }

    @Test
    public void testGlobalStyleWithWorkspaceIgnored() throws Exception {
        Catalog catalog = this.getCatalog();
        StyleInfoImpl s = (StyleInfoImpl)ModificationProxy.unwrap((Object)catalog.getStyleByName("point"));
        String id = "testGlobalStyleWithWorkspaceIgnored";
        s.setId(id);
        s.setName(id);
        Resource globalStyleLocation = this.getDataDirectory().config((StyleInfo)s);
        s.setWorkspace((WorkspaceInfo)catalog.getWorkspaces().get(0));
        this.persist((Info)s, globalStyleLocation);
        this.getLoader().reload();
        Assert.assertNull((Object)catalog.getStyle(id));
        s.setWorkspace(null);
        this.persist((Info)s, globalStyleLocation);
        this.getLoader().reload();
        Assert.assertEquals((Object)s, (Object)catalog.getStyle(id));
    }

    @Test
    public void testWorkspaceStyleWithNullWorkspaceIgnored() throws Exception {
        StyleInfoImpl s = (StyleInfoImpl)ModificationProxy.unwrap((Object)this.getCatalog().getStyleByName("point"));
        String id = "testWorkspaceStyleWithNullWorkspaceIgnored";
        s.setId(id);
        s.setName(id);
        Catalog catalog = this.getCatalog();
        WorkspaceInfo workspace = (WorkspaceInfo)catalog.getWorkspaces().get(0);
        s.setWorkspace(workspace);
        Resource workspaceStyleLocation = this.getDataDirectory().config((StyleInfo)s);
        this.persist((Info)s, workspaceStyleLocation);
        this.getLoader().reload();
        Assert.assertEquals((Object)s, (Object)catalog.getStyle(id));
        s.setWorkspace(null);
        this.persist((Info)s, workspaceStyleLocation);
        this.getLoader().reload();
        Assert.assertNull((Object)catalog.getStyle(id));
    }

    @Test
    public void testMistmatchStyleWorkspaceIgnored() throws Exception {
        StyleInfoImpl s = (StyleInfoImpl)ModificationProxy.unwrap((Object)this.getCatalog().getStyleByName("point"));
        String id = "testMistmatchStyleWorkspaceIgnored";
        s.setId(id);
        s.setName(id);
        Catalog catalog = this.getCatalog();
        WorkspaceInfo workspace1 = Objects.requireNonNull(catalog.getWorkspaceByName("wcs"));
        WorkspaceInfo workspace2 = Objects.requireNonNull(catalog.getWorkspaceByName("cgf"));
        s.setWorkspace(workspace1);
        Resource workspaceStyleLocation = this.getDataDirectory().config((StyleInfo)s);
        this.persist((Info)s, workspaceStyleLocation);
        Assert.assertNull((Object)catalog.getStyle(id));
        this.getLoader().reload();
        Assert.assertEquals((Object)s, (Object)catalog.getStyle(id));
        s.setWorkspace(workspace2);
        this.persist((Info)s, workspaceStyleLocation);
        this.getLoader().reload();
        Assert.assertNull((Object)catalog.getStyle(id));
    }

    @Test
    public void testLayerGroupInfo() throws Exception {
        LayerGroupInfoImpl layerGroup = this.support.createLayerGroup("globalLG", this.getCatalog().getLayers());
        layerGroup.setId("testLayerGroupInfo");
        Catalog catalog = this.getCatalog();
        this.persist((Info)layerGroup, this.getDataDirectory().config((LayerGroupInfo)layerGroup));
        Assert.assertNull((Object)catalog.getLayerGroup(layerGroup.getId()));
        this.getLoader().reload();
        Assert.assertEquals((Object)layerGroup, (Object)this.getCatalog().getLayerGroup(layerGroup.getId()));
    }

    @Test
    public void testLayerGroupInfoWorkspace() throws Exception {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo ws = Objects.requireNonNull(catalog.getWorkspaceByName("cite"));
        LayerInfo l1 = Objects.requireNonNull(catalog.getLayerByName("cite:Bridges"));
        LayerInfo l2 = Objects.requireNonNull(catalog.getLayerByName("cite:Buildings"));
        LayerGroupInfoImpl layerGroup = this.support.createLayerGroup("workspaceLG", List.of(l1, l2));
        layerGroup.setId("testLayerGroupInfo");
        layerGroup.setWorkspace(ws);
        this.persist((Info)layerGroup, this.getDataDirectory().config((LayerGroupInfo)layerGroup));
        Assert.assertNull((Object)catalog.getLayerGroup(layerGroup.getId()));
        this.getLoader().reload();
        Assert.assertEquals((Object)layerGroup, (Object)catalog.getLayerGroup(layerGroup.getId()));
    }

    @Test
    public void testLayerGroupInfoWorkspaceWithLayersFromOtherWorkspaceIgnored() throws Exception {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo rightWorkspace = Objects.requireNonNull(catalog.getWorkspaceByName("cite"));
        WorkspaceInfo wrongWorkspace = Objects.requireNonNull(catalog.getWorkspaceByName("wcs"));
        LayerInfo l1 = Objects.requireNonNull(catalog.getLayerByName("cite:Bridges"));
        LayerInfo l2 = Objects.requireNonNull(catalog.getLayerByName("cite:Buildings"));
        LayerGroupInfoImpl layerGroup = this.support.createLayerGroup("workspaceLG", List.of(l1, l2));
        layerGroup.setId("testLayerGroupInfoWorkspaceWithLayersFromOtherWorkspaceIgnored");
        layerGroup.setWorkspace(rightWorkspace);
        Resource rightResource = this.getDataDirectory().config((LayerGroupInfo)layerGroup);
        layerGroup.setWorkspace(wrongWorkspace);
        this.persist((Info)layerGroup, rightResource);
        Assert.assertNull((Object)catalog.getLayerGroup(layerGroup.getId()));
        this.getLoader().reload();
        Assert.assertNull((Object)catalog.getLayerGroup(layerGroup.getId()));
        layerGroup.setWorkspace(rightWorkspace);
        this.persist((Info)layerGroup, rightResource);
        this.getLoader().reload();
        Assert.assertEquals((Object)layerGroup, (Object)catalog.getLayerGroup(layerGroup.getId()));
    }

    @Test
    public void unparseableDataStorePasswordDisablesIt() throws Exception {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo ws = Objects.requireNonNull(catalog.getWorkspaceByName("wcs"));
        DataStoreInfoImpl store = this.support.createPostgisStore(ws);
        store.setId("unparseableDataStorePasswordDisablesIt");
        store.setEnabled(true);
        String unparseablePasswd = "crypt1:non-sense";
        store.getConnectionParameters().put(JDBCDataStoreFactory.PASSWD.key, unparseablePasswd);
        Resource resource = this.getDataDirectory().config((DataStoreInfo)store);
        this.persist((Info)store, resource);
        Assert.assertNull((Object)catalog.getStore(store.getId(), StoreInfo.class));
        this.getLoader().reload();
        StoreInfo loaded = catalog.getStore(store.getId(), StoreInfo.class);
        Assert.assertNotNull((Object)loaded);
        Assert.assertFalse((boolean)loaded.isEnabled());
        store.setEnabled(false);
        Assert.assertEquals((Object)store, (Object)loaded);
    }

    @Test
    public void unparseableHttpStorePasswordDisablesIt() throws Exception {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo ws = Objects.requireNonNull(catalog.getWorkspaceByName("wcs"));
        WMSStoreInfoImpl store = this.support.createWmsStore(ws);
        store.setId("unparseableHttpStorePasswordDisablesIt");
        store.setEnabled(true);
        String unparseablePasswd = "crypt1:non-sense";
        store.setPassword(unparseablePasswd);
        Resource resource = this.getDataDirectory().config((WMSStoreInfo)store);
        this.persist((Info)store, resource);
        Assert.assertNull((Object)catalog.getStore(store.getId(), StoreInfo.class));
        this.getLoader().reload();
        StoreInfo loaded = catalog.getStore(store.getId(), StoreInfo.class);
        Assert.assertNotNull((Object)loaded);
        Assert.assertFalse((boolean)loaded.isEnabled());
        store.setEnabled(false);
        Assert.assertEquals((Object)store, (Object)loaded);
    }

    @Test
    public void settingsInfoWithNoWorkspaceIsIgnored() throws Exception {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo ws = Objects.requireNonNull(catalog.getWorkspaceByName("wcs"));
        SettingsInfo settings = this.support.createSettings(ws);
        Resource resource = this.getDataDirectory().config(settings);
        settings.setWorkspace(null);
        this.persist((Info)settings, resource);
        Assert.assertNull((Object)this.getGeoServer().getSettings(ws));
        this.getLoader().reload();
        Assert.assertNull((Object)this.getGeoServer().getSettings(ws));
        settings.setWorkspace(ws);
        this.persist((Info)settings, resource);
        this.getLoader().reload();
        Assert.assertEquals((Object)settings, (Object)this.getGeoServer().getSettings(ws));
    }

    @Test
    public void settingsInfoWithNonExistingWorkspaceIsIgnored() throws Exception {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo correctWs = Objects.requireNonNull(catalog.getWorkspaceByName("wcs"));
        SettingsInfo settings = this.support.createSettings(correctWs);
        Resource resource = this.getDataDirectory().config(settings);
        WorkspaceInfoImpl missingWs = this.support.createWorkspace("nonExistentWorkspace");
        missingWs.setId("invalid-ws-id");
        settings.setWorkspace((WorkspaceInfo)missingWs);
        this.persist((Info)settings, resource);
        Assert.assertNull((Object)this.getGeoServer().getSettings(correctWs));
        this.getLoader().reload();
        Assert.assertNull((Object)this.getGeoServer().getSettings(correctWs));
        settings.setWorkspace(correctWs);
        this.persist((Info)settings, resource);
        this.getLoader().reload();
        Assert.assertEquals((Object)settings, (Object)this.getGeoServer().getSettings(correctWs));
    }

    @Test
    public void settingsInfoWithNullWorkspaceIdIsIgnored() throws Exception {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo correctWs = Objects.requireNonNull(catalog.getWorkspaceByName("wcs"));
        SettingsInfo settings = this.support.createSettings(correctWs);
        Resource resource = this.getDataDirectory().config(settings);
        WorkspaceInfoImpl nullIdWorkspace = this.support.createWorkspace("nullIdWorkspace");
        nullIdWorkspace.setId(null);
        settings.setWorkspace((WorkspaceInfo)nullIdWorkspace);
        this.persist((Info)settings, resource);
        Assert.assertNull((Object)this.getGeoServer().getSettings(correctWs));
        this.getLoader().reload();
        Assert.assertNull((Object)this.getGeoServer().getSettings(correctWs));
        settings.setWorkspace(correctWs);
        this.persist((Info)settings, resource);
        this.getLoader().reload();
        Assert.assertEquals((Object)settings, (Object)this.getGeoServer().getSettings(correctWs));
    }

    @Test
    public void settingsInfoWithInvalidWorkspaceIsIgnored() throws Exception {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo correctWs = Objects.requireNonNull(catalog.getWorkspaceByName("wcs"));
        SettingsInfo settings = this.support.createSettings(correctWs);
        Resource resource = this.getDataDirectory().config(settings);
        WorkspaceInfo wrongWorkspace = Objects.requireNonNull(catalog.getWorkspaceByName("cite"));
        settings.setWorkspace(wrongWorkspace);
        this.persist((Info)settings, resource);
        Assert.assertNull((Object)this.getGeoServer().getSettings(correctWs));
        this.getLoader().reload();
        Assert.assertNull((Object)this.getGeoServer().getSettings(correctWs));
        settings.setWorkspace(correctWs);
        this.persist((Info)settings, resource);
        this.getLoader().reload();
        Assert.assertEquals((Object)settings, (Object)this.getGeoServer().getSettings(correctWs));
    }

    @Test
    public void testServiceInfoNullWorkspace() throws Exception {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo ws = Objects.requireNonNull(catalog.getWorkspaceByName("wcs"));
        GeoServer geoServer = this.getGeoServer();
        this.support.setUpServiceLoaders(geoServer);
        DataDirectoryLoaderTestSupport.TestService1 service = this.support.serviceInfo1(ws, this.username, geoServer);
        String filename = this.support.serviceLoader1.getFilename();
        Resource resource = this.getDataDirectory().getWorkspaces(new String[]{ws.getName(), filename});
        service.setWorkspace(null);
        this.persist((Info)service, resource);
        this.getLoader().reload();
        Assert.assertNull((Object)geoServer.getService(service.getId(), ServiceInfo.class));
        service.setWorkspace(ws);
        this.persist((Info)service, resource);
        this.getLoader().reload();
        ServiceInfo loaded = geoServer.getService(service.getId(), ServiceInfo.class);
        loaded = (ServiceInfo)ModificationProxy.unwrap((Object)loaded);
        Assert.assertEquals((Object)service, (Object)loaded);
    }

    @Test
    public void initializeDefaultStyle() throws Exception {
        GeoServerResourceLoader resourceLoader = this.getResourceLoader();
        Resource styles = resourceLoader.get("styles");
        Assert.assertTrue((boolean)styles.dir().isDirectory());
        this.deleteStyle("point", "default_point.sld");
        this.deleteStyle("line", "default_line.sld");
        this.deleteStyle("polygon", "default_polygon.sld");
        this.deleteStyle("raster", "default_raster.sld");
        this.deleteStyle("generic", "default_generic.sld");
        this.getLoader().reload();
        styles = resourceLoader.get("styles");
        Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)styles.get("point.xml").getType());
        Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)styles.get("default_point.sld").getType());
        Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)styles.get("line.xml").getType());
        Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)styles.get("default_line.sld").getType());
        Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)styles.get("polygon.xml").getType());
        Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)styles.get("default_polygon.sld").getType());
        Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)styles.get("raster.xml").getType());
        Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)styles.get("default_raster.sld").getType());
        Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)styles.get("generic.xml").getType());
        Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)styles.get("default_generic.sld").getType());
    }

    private void deleteStyle(String infoName, String sldFile) {
        GeoServerResourceLoader resourceLoader = this.getResourceLoader();
        Resource styles = resourceLoader.get("styles");
        Resource xml = styles.get(infoName + ".xml");
        Resource sld = styles.get(sldFile);
        Assert.assertTrue((!Resources.exists((Resource)xml) || xml.delete() ? 1 : 0) != 0);
        Assert.assertTrue((!Resources.exists((Resource)sld) || sld.delete() ? 1 : 0) != 0);
    }

    private void persist(Info info, Resource file) throws IOException {
        try (OutputStream out = file.out();){
            XStreamPersister persister = this.persister();
            persister.setEncryptPasswordFields(false);
            persister.save((Object)info, out);
        }
    }

    private XStreamPersister persister() {
        return new XStreamPersisterFactory().createXMLPersister();
    }

    private void assertPasswordEncrypted(DataStoreInfo store) {
        XStreamPersister persister = new XStreamPersisterFactory().createXMLPersister();
        persister.setEncryptPasswordFields(false);
        XStream xStream = persister.getXStream();
        Resource resource = super.getDataDirectory().config(store);
        DataStoreInfo depresisted = (DataStoreInfo)xStream.fromXML(resource.file());
        String pwdParam = JDBCDataStoreFactory.PASSWD.key;
        Serializable encodedPwd = (Serializable)depresisted.getConnectionParameters().get(pwdParam);
        String plainPassword = (String)store.getConnectionParameters().get(pwdParam);
        Assert.assertNotNull((Object)plainPassword);
        Assert.assertNotEquals((Object)plainPassword, (Object)encodedPwd);
    }

    private void assertPasswordEncrypted(WMSStoreInfo store) {
        XStreamPersister persister = new XStreamPersisterFactory().createXMLPersister();
        persister.setEncryptPasswordFields(false);
        XStream xStream = persister.getXStream();
        Resource resource = super.getDataDirectory().config(store);
        WMSStoreInfo depresisted = (WMSStoreInfo)xStream.fromXML(resource.file());
        String encodedPwd = depresisted.getPassword();
        Assert.assertNotNull((Object)encodedPwd);
        String plainPassword = store.getPassword();
        Assert.assertNotEquals((Object)plainPassword, (Object)encodedPwd);
    }

    private DataDirectoryGeoServerLoader newLoader() {
        GeoServerResourceLoader resourceLoader = this.getResourceLoader();
        GeoServerSecurityManager secManager = this.getSecurityManager();
        GeoServerConfigurationLock configLock = (GeoServerConfigurationLock)GeoServerExtensions.bean(GeoServerConfigurationLock.class);
        return this.newLoader(resourceLoader, secManager, configLock);
    }

    private DataDirectoryGeoServerLoader newLoader(GeoServerResourceLoader resourceLoader, GeoServerSecurityManager secManager, GeoServerConfigurationLock configLock) {
        GeoServerDataDirectory dataDirectory = new GeoServerDataDirectory(resourceLoader);
        return new DataDirectoryGeoServerLoader(dataDirectory, secManager, configLock);
    }
}

