/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.util.Collection;
import java.util.Collections;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerLoaderListener;
import org.geoserver.config.RootStartupListener;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class GeoServerRootStartupTest
extends GeoServerSystemTestSupport {
    private volatile Collection<? extends GrantedAuthority> catalogRoles = null;
    private volatile Collection<? extends GrantedAuthority> geoServerRoles = null;

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpDefault();
        RootStartupListener.setListener(new GeoServerLoaderListener(){

            public void loadGeoServer(GeoServer geoServer, XStreamPersister xp) {
                GeoServerRootStartupTest.this.catalogRoles = GeoServerRootStartupTest.getCurrentRoles();
            }

            public void loadCatalog(Catalog catalog, XStreamPersister xp) {
                GeoServerRootStartupTest.this.geoServerRoles = GeoServerRootStartupTest.getCurrentRoles();
            }
        });
    }

    @After
    public void onEnd() {
        RootStartupListener.setListener(GeoServerLoaderListener.EMPTY_LISTENER);
    }

    @Test
    public void testRootStartupCatalogLoad() {
        Assert.assertTrue((boolean)this.hasAdminRole(this.catalogRoles));
        Assert.assertTrue((boolean)this.hasAdminRole(this.geoServerRoles));
    }

    private boolean hasAdminRole(Collection<? extends GrantedAuthority> roles) {
        if (roles == null) {
            return false;
        }
        for (GrantedAuthority grantedAuthority : roles) {
            if (!GeoServerRole.ADMIN_ROLE.equals((Object)grantedAuthority) && !GeoServerRole.GROUP_ADMIN_ROLE.equals((Object)grantedAuthority)) continue;
            return true;
        }
        return false;
    }

    private static Collection<? extends GrantedAuthority> getCurrentRoles() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context == null || context.getAuthentication() == null) {
            return Collections.emptyList();
        }
        return context.getAuthentication().getAuthorities();
    }
}

