/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.List;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoLookup;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NamespaceInfoLookupTest {
    private static final String URI_1 = "http://gs.test.com/ns1";
    private static final String URI_2 = "http://gs.test.com/ns2";
    private NamespaceInfo uri1_1;
    private NamespaceInfo uri1_2;
    private NamespaceInfo uri2_1;
    private NamespaceInfo uri2_2;
    private NamespaceInfoLookup lookup;

    @Before
    public void setUp() {
        this.uri1_1 = this.create("uri1_1", URI_1);
        this.uri1_2 = this.create("uri1_2", URI_1);
        this.uri2_1 = this.create("uri2_1", URI_2);
        this.uri2_2 = this.create("uri2_2", URI_2);
        this.lookup = new NamespaceInfoLookup();
    }

    private NamespaceInfo create(String prefix, String uri) {
        NamespaceInfoImpl ns = new NamespaceInfoImpl();
        ns.setId(prefix + "-id");
        ns.setPrefix(prefix);
        ns.setURI(uri);
        return ns;
    }

    private void addAll(NamespaceInfo ... values) {
        for (NamespaceInfo ns : values) {
            this.lookup.add(ns);
        }
    }

    @Test
    public void testAdd() {
        this.lookup.add(this.uri1_2);
        Assert.assertEquals(List.of(this.uri1_2), (Object)this.lookup.valueList(URI_1, false));
        this.lookup.add(this.uri1_1);
        Assert.assertEquals(List.of(this.uri1_1, this.uri1_2), (Object)this.lookup.valueList(URI_1, false));
        Assert.assertSame((Object)this.uri1_1, (Object)this.lookup.findById(this.uri1_1.getId(), NamespaceInfo.class));
        Assert.assertSame((Object)this.uri1_2, (Object)this.lookup.findById(this.uri1_2.getId(), NamespaceInfo.class));
    }

    @Test
    public void testClear() {
        this.addAll(this.uri1_1, this.uri1_2, this.uri2_1, this.uri2_2);
        this.lookup.clear();
        Assert.assertEquals(List.of(), (Object)this.lookup.values());
    }

    @Test
    public void testRemove() {
        this.addAll(this.uri1_1, this.uri1_2, this.uri2_1, this.uri2_2);
        this.testRemove(this.uri1_1);
        this.testRemove(this.uri1_2);
        this.testRemove(this.uri2_1);
        this.testRemove(this.uri2_2);
        this.lookup.remove(this.uri1_1);
    }

    private void testRemove(NamespaceInfo ns) {
        NamespaceInfo current = (NamespaceInfo)this.lookup.findById(ns.getId(), NamespaceInfo.class);
        NamespaceInfo removed = this.lookup.remove(ns);
        Assert.assertSame((Object)current, (Object)removed);
        Assert.assertNull((Object)this.lookup.findById(ns.getId(), NamespaceInfo.class));
    }

    @Test
    public void testUpdate() {
        this.addAll(this.uri1_1, this.uri1_2, this.uri2_1, this.uri2_2);
        this.testUpdate(this.uri1_1, URI_2, List.of(this.uri1_1, this.uri2_1, this.uri2_2));
        this.testUpdate(this.uri2_2, URI_1, List.of(this.uri1_2, this.uri2_2));
    }

    private void testUpdate(NamespaceInfo ns, String newUri, List<NamespaceInfo> expected) {
        String oldUri = ns.getURI();
        Assert.assertTrue((boolean)this.lookup.valueList(oldUri, false).contains(ns));
        NamespaceInfo proxied = (NamespaceInfo)ModificationProxy.create((Object)ns, NamespaceInfo.class);
        proxied.setURI(newUri);
        this.lookup.update(proxied);
        ModificationProxy.handler((Object)proxied).commit();
        Assert.assertEquals(expected, (Object)this.lookup.valueList(newUri, false));
        Assert.assertFalse((boolean)this.lookup.valueList(oldUri, false).contains(ns));
    }

    @Test
    public void testFindAllByUri() {
        Assert.assertTrue((boolean)this.lookup.findAllByUri(URI_1).isEmpty());
        Assert.assertTrue((boolean)this.lookup.findAllByUri(URI_2).isEmpty());
        this.lookup.add(this.uri1_1);
        Assert.assertEquals(List.of(this.uri1_1), (Object)this.lookup.findAllByUri(URI_1));
        this.lookup.add(this.uri2_1);
        Assert.assertEquals(List.of(this.uri1_1), (Object)this.lookup.findAllByUri(URI_1));
        Assert.assertEquals(List.of(this.uri2_1), (Object)this.lookup.findAllByUri(URI_2));
        this.lookup.add(this.uri1_2);
        this.lookup.add(this.uri2_2);
        Assert.assertEquals(List.of(this.uri1_1, this.uri1_2), (Object)this.lookup.findAllByUri(URI_1));
        Assert.assertEquals(List.of(this.uri2_1, this.uri2_2), (Object)this.lookup.findAllByUri(URI_2));
    }

    @Test
    public void testFindAllByUri_stable_order() {
        this.addAll(this.uri1_1, this.uri1_2);
        List<NamespaceInfo> expected = List.of(this.uri1_1, this.uri1_2);
        Assert.assertEquals(expected, (Object)this.lookup.findAllByUri(URI_1));
        this.lookup.clear();
        Assert.assertTrue((boolean)this.lookup.findAllByUri(URI_1).isEmpty());
        this.addAll(this.uri1_2, this.uri1_1);
        Assert.assertEquals(expected, (Object)this.lookup.findAllByUri(URI_1));
    }
}

