/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import org.geoserver.catalog.impl.DataLinkInfoImpl;
import org.junit.Assert;
import org.junit.Test;

public class DataLinkInfoImplTest {
    @Test
    public void testSetAbsoluteHttp() {
        DataLinkInfoImpl info = new DataLinkInfoImpl();
        info.setContent("http://example.com/foo");
    }

    @Test
    public void testSetAbsoluteHttps() {
        DataLinkInfoImpl info = new DataLinkInfoImpl();
        info.setContent("https://example.com/foo");
    }

    @Test
    public void testSetAbsoluteFtp() {
        DataLinkInfoImpl info = new DataLinkInfoImpl();
        info.setContent("ftp://example.com/foo");
    }

    @Test
    public void testSetAbsoluteTelnet() {
        DataLinkInfoImpl info = new DataLinkInfoImpl();
        Assert.assertThrows(IllegalArgumentException.class, () -> info.setContent("telnet:example.com"));
    }

    @Test
    public void testSetRelativeUrlAbsolutePath() {
        DataLinkInfoImpl info = new DataLinkInfoImpl();
        info.setContent("/foo");
    }

    @Test
    public void testSetRelativeUrlRelativePath() {
        DataLinkInfoImpl info = new DataLinkInfoImpl();
        info.setContent("foo/bar");
    }

    @Test
    public void testSetRelativeUrlRelativeCurrentPath() {
        DataLinkInfoImpl info = new DataLinkInfoImpl();
        info.setContent("./foo");
    }

    @Test
    public void testSetRelativeUrlRelativeParentPath() {
        DataLinkInfoImpl info = new DataLinkInfoImpl();
        info.setContent("../foo");
    }

    @Test
    public void testSetNotAURL() {
        DataLinkInfoImpl info = new DataLinkInfoImpl();
        Assert.assertThrows(IllegalArgumentException.class, () -> info.setContent("::^%/[*] FOO ::"));
    }

    @Test
    public void testNotAURLButStartsOK() {
        DataLinkInfoImpl info = new DataLinkInfoImpl();
        Assert.assertThrows(IllegalArgumentException.class, () -> info.setContent("https://example.com/::^%/[*] FOO ::"));
    }
}

