/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.io.IOException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;

public class CascadeVisitorAbstractTest
extends GeoServerSystemTestSupport {
    protected static final String LAKES_GROUP = "lakesGroup";
    protected static final String NEST_GROUP = "nestGroup";
    protected static final String WS_STYLE = "wsStyle";

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        Catalog catalog = this.getCatalog();
        testData.addVectorLayer(CiteTestData.LAKES, catalog);
        testData.addVectorLayer(CiteTestData.BRIDGES, catalog);
        testData.addVectorLayer(CiteTestData.FORESTS, catalog);
        testData.addVectorLayer(CiteTestData.BUILDINGS, catalog);
        this.setupExtras(testData, catalog);
    }

    void setupExtras(SystemTestData testData, Catalog catalog) throws IOException {
        LayerInfo buildings = catalog.getLayerByName(this.getLayerId(CiteTestData.BUILDINGS));
        buildings.getStyles().add(catalog.getStyleByName(CiteTestData.LAKES.getLocalPart()));
        catalog.save(buildings);
        CatalogFactory factory = catalog.getFactory();
        LayerGroupInfo globalGroup = factory.createLayerGroup();
        globalGroup.setName(LAKES_GROUP);
        globalGroup.getLayers().add(catalog.getLayerByName(this.getLayerId(CiteTestData.LAKES)));
        globalGroup.getLayers().add(catalog.getLayerByName(this.getLayerId(CiteTestData.FORESTS)));
        globalGroup.getLayers().add(catalog.getLayerByName(this.getLayerId(CiteTestData.BRIDGES)));
        globalGroup.getStyles().add(null);
        globalGroup.getStyles().add(null);
        globalGroup.getStyles().add(null);
        catalog.add(globalGroup);
        LayerGroupInfo nestGroup = factory.createLayerGroup();
        nestGroup.setName(NEST_GROUP);
        nestGroup.getLayers().add(catalog.getLayerByName(this.getLayerId(CiteTestData.LAKES)));
        nestGroup.getLayers().add(globalGroup);
        nestGroup.getStyles().add(null);
        nestGroup.getStyles().add(null);
        catalog.add(nestGroup);
        WorkspaceInfo ws = catalog.getWorkspaceByName(CiteTestData.CITE_PREFIX);
        testData.addStyle(ws, WS_STYLE, "Streams.sld", SystemTestData.class, catalog);
    }
}

