/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.SystemTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SystemTest.class})
public class SchemaMappingTest
extends GeoServerSystemTestSupport {
    @Before
    public void removeMappings() throws IOException {
        File resourceDir = Resources.directory((Resource)this.getDataDirectory().get((ResourceInfo)this.getDividedRoutes(), new String[0]));
        new File(resourceDir, "schema.xsd").delete();
        new File(resourceDir, "schema.xml").delete();
    }

    @Test
    public void testNoMapping() throws Exception {
        this.reloadCatalogAndConfiguration();
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName("DividedRoutes");
        Assert.assertEquals((long)4L, (long)ft.attributes().size());
    }

    @Test
    public void testXsdMapping() throws Exception {
        Resources.copy((InputStream)this.getClass().getResourceAsStream("schema.xsd"), (Resource)this.getDataDirectory().get((ResourceInfo)this.getDividedRoutes(), new String[0]), (String)"schema.xsd");
        this.reloadCatalogAndConfiguration();
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName("DividedRoutes");
        Assert.assertEquals((long)3L, (long)ft.attributes().size());
    }

    @Test
    public void testXmlMapping() throws Exception {
        Resources.copy((InputStream)this.getClass().getResourceAsStream("schema.xml"), (Resource)this.getDataDirectory().get((ResourceInfo)this.getDividedRoutes(), new String[0]), (String)"schema.xml");
        this.reloadCatalogAndConfiguration();
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName("DividedRoutes");
        Assert.assertEquals((long)2L, (long)ft.attributes().size());
    }

    FeatureTypeInfo getDividedRoutes() {
        return this.getCatalog().getFeatureTypeByName("DividedRoutes");
    }
}

