/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.media.jai.PlanarImage;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeCallback;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.ResourcePoolInitializer;
import org.geoserver.catalog.ResourcePoolLatchedThread;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.TestDirectoryStoreFactorySpi;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.catalog.impl.WMSStoreInfoImpl;
import org.geoserver.catalog.util.ReaderUtils;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.data.test.TestData;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.RunTestSetup;
import org.geoserver.test.SystemTest;
import org.geoserver.util.IOUtils;
import org.geotools.api.coverage.grid.GridCoverageReader;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataAccessFinder;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureLocking;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Mark;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.directory.DirectoryDataStore;
import org.geotools.data.shapefile.ShapefileDirectoryFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.feature.collection.SortedSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.geometry.GeneralBounds;
import org.geotools.image.util.ImageUtilities;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.VirtualTable;
import org.geotools.jdbc.VirtualTableParameter;
import org.geotools.ows.ServiceException;
import org.geotools.referencing.CRS;
import org.geotools.styling.AbstractStyleVisitor;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.URLs;
import org.geotools.util.Version;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.locationtech.jts.geom.Point;
import org.springframework.test.util.ReflectionTestUtils;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@Category(value={SystemTest.class})
public class ResourcePoolTest
extends GeoServerSystemTestSupport {
    private static final String SQLVIEW_DATASTORE = "sqlviews";
    private static final String VT_NAME = "pgeo_view";
    private static final String HUMANS = "humans";
    private static final String BAD_CONN_DATASTORE = "bad_conn_data_store";
    public static final DataStoreFactorySpi TEST_DIRECTORY_STORE_FACTORY_SPI = new TestDirectoryStoreFactorySpi();
    private static File rockFillSymbolFile;
    protected static QName TIMERANGES;
    private static final String EXTERNAL_ENTITIES = "externalEntities";
    boolean cleared = false;
    boolean disposeCalled;

    @BeforeClass
    public static void registerTestDirectoryStore() {
        DataStoreFinder.registerFactory((DataStoreFactorySpi)TEST_DIRECTORY_STORE_FACTORY_SPI);
    }

    @AfterClass
    public static void deregisterTestDirectoryStore() {
        DataStoreFinder.deregisterFactory((DataStoreFactorySpi)TEST_DIRECTORY_STORE_FACTORY_SPI);
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle("relative", "se_relativepath.sld", ResourcePoolTest.class, catalog);
        testData.addStyle("relative_protocol", "se_relativepath_protocol.sld", ResourcePoolTest.class, catalog);
        testData.addStyle(HUMANS, "humans.sld", ResourcePoolTest.class, catalog);
        testData.addStyle(EXTERNAL_ENTITIES, "externalEntities.sld", TestData.class, catalog);
        StyleInfo style = catalog.getStyleByName("relative");
        style.setFormatVersion(new Version("1.1.0"));
        catalog.save(style);
        style = catalog.getStyleByName(HUMANS);
        style.setFormatVersion(new Version("1.1.0"));
        catalog.save(style);
        File images = new File(testData.getDataDirectoryRoot(), "styles/images");
        Assert.assertTrue((boolean)images.mkdir());
        File image = new File("./src/test/resources/org/geoserver/catalog/rockFillSymbol.png");
        Assert.assertTrue((boolean)image.exists());
        FileUtils.copyFileToDirectory((File)image, (File)images);
        rockFillSymbolFile = new File(images, image.getName()).getCanonicalFile();
        testData.addRasterLayer(TIMERANGES, "timeranges.zip", null, null, SystemTestData.class, catalog);
        FileUtils.copyFileToDirectory((File)new File("./src/test/resources/geoserver-environment.properties"), (File)testData.getDataDirectoryRoot());
        try (InputStream is = this.getClass().getResourceAsStream("mini-states.zip");){
            File dir = this.getDataDirectory().get(new String[]{"data/mini-states"}).dir();
            dir.mkdirs();
            IOUtils.decompress((InputStream)is, (File)dir);
        }
        CatalogBuilder cb = new CatalogBuilder(catalog);
        DataStoreInfo dataStoreInfo = cb.buildDataStore("mini-states");
        dataStoreInfo.setType("Shapefile");
        dataStoreInfo.getConnectionParameters().put("url", "file:data/mini-states/mini-states.shp");
        catalog.add((StoreInfo)dataStoreInfo);
        DataStore ds = (DataStore)dataStoreInfo.getDataStore(null);
        cb.setStore((StoreInfo)dataStoreInfo);
        FeatureTypeInfo typeInfo = cb.buildFeatureType((FeatureSource)ds.getFeatureSource(ds.getTypeNames()[0]));
        List attributes = catalog.getResourcePool().getAttributes(typeInfo);
        typeInfo.getAttributes().addAll(attributes);
        catalog.add((ResourceInfo)typeInfo);
        LayerInfo layerInfo = cb.buildLayer(typeInfo);
        catalog.add(layerInfo);
    }

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpWcs11RasterLayers();
    }

    @Test
    public void testFeatureTypeCacheInstance() throws Exception {
        ResourcePool pool = ResourcePool.create((Catalog)this.getCatalog());
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        FeatureType ft1 = pool.getFeatureType(info);
        FeatureType ft2 = pool.getFeatureType(info);
        FeatureType ft3 = pool.getFeatureType(info);
        Assert.assertSame((Object)ft1, (Object)ft2);
        Assert.assertSame((Object)ft1, (Object)ft3);
    }

    @Test
    public void testAttributeCache() throws Exception {
        Catalog catalog = this.getCatalog();
        ResourcePool pool = ResourcePool.create((Catalog)catalog);
        FeatureTypeInfo oldInfo = catalog.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        List layers = catalog.getLayers((ResourceInfo)oldInfo);
        for (LayerInfo layerInfo : layers) {
            catalog.remove(layerInfo);
        }
        catalog.remove((ResourceInfo)oldInfo);
        CatalogBuilder builder = new CatalogBuilder(catalog);
        builder.setStore(catalog.getStoreByName(MockData.CITE_PREFIX, MockData.CITE_PREFIX, DataStoreInfo.class));
        FeatureTypeInfo info = builder.buildFeatureType((Name)new NameImpl(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart()));
        List att1 = pool.getAttributes(info);
        List att2 = pool.getAttributes(info);
        Assert.assertNotSame((Object)att1, (Object)att2);
        Assert.assertEquals((Object)att1, (Object)att2);
        catalog.add((ResourceInfo)info);
        List att3 = pool.getAttributes(info);
        List att4 = pool.getAttributes(info);
        Assert.assertSame((Object)att3, (Object)att4);
        Assert.assertNotSame((Object)att1, (Object)att3);
        Assert.assertEquals((Object)att1, (Object)att3);
    }

    @Test
    public void testCacheClearing() throws IOException {
        this.cleared = false;
        ResourcePool pool = new ResourcePool(this.getCatalog()){

            public void clear(FeatureTypeInfo info) {
                ResourcePoolTest.this.cleared = true;
                super.clear(info);
            }
        };
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        Assert.assertNotNull((Object)pool.getFeatureType(info));
        info.setTitle("changed");
        Assert.assertFalse((boolean)this.cleared);
        this.getCatalog().save((ResourceInfo)info);
        Assert.assertTrue((boolean)this.cleared);
        this.cleared = false;
        Assert.assertNotNull((Object)pool.getFeatureType(info));
        for (LayerInfo l : this.getCatalog().getLayers((ResourceInfo)info)) {
            this.getCatalog().remove(l);
        }
        this.getCatalog().remove((ResourceInfo)info);
        Assert.assertTrue((boolean)this.cleared);
    }

    @Test
    public void testDispose() throws IOException {
        this.disposeCalled = false;
        Catalog catalog = this.getCatalog();
        class ResourcePool2
        extends ResourcePool {
            public ResourcePool2(Catalog catalog) {
                super(catalog);
                this.dataStoreCache = new ResourcePool.DataStoreCache(){

                    protected void dispose(String name, DataAccess dataStore) {
                        ResourcePoolTest.this.disposeCalled = true;
                        super.dispose(name, dataStore);
                    }
                };
            }
        }
        ResourcePool2 pool = new ResourcePool2(catalog);
        catalog.setResourcePool((ResourcePool)pool);
        DataStoreInfo info = (DataStoreInfo)catalog.getDataStores().get(0);
        DataAccess dataStore = pool.getDataStore(info);
        Assert.assertNotNull((Object)dataStore);
        Assert.assertFalse((boolean)this.disposeCalled);
        pool.clear(info);
        Assert.assertTrue((boolean)this.disposeCalled);
        dataStore = pool.getDataStore(info);
        Assert.assertNotNull((Object)dataStore);
        this.disposeCalled = false;
        pool.dispose();
        Assert.assertTrue((boolean)this.disposeCalled);
    }

    @Test
    public void testConfigureFeatureTypeCacheSize() {
        GeoServer gs = this.getGeoServer();
        GeoServerInfo global = gs.getGlobal();
        global.setFeatureTypeCacheSize(200);
        gs.save(global);
        Catalog catalog = this.getCatalog();
        Assert.assertEquals((long)400L, (long)((SoftValueHashMap)catalog.getResourcePool().getFeatureTypeCache()).getHardReferencesCount());
    }

    @Test
    public void testDropCoverageStore() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        CoverageStoreInfo store = cb.buildCoverageStore("dem");
        store.setURL(MockData.class.getResource("tazdem.tiff").toExternalForm());
        store.setType("GeoTIFF");
        cat.add((StoreInfo)store);
        cb.setStore((StoreInfo)store);
        CoverageInfo ci = cb.buildCoverage();
        cat.add((ResourceInfo)ci);
        LayerInfo layer = cb.buildLayer(ci);
        cat.add(layer);
        ci.getGridCoverage(null, null);
        ci.getGridCoverageReader(null, GeoTools.getDefaultHints());
        CascadeDeleteVisitor visitor = new CascadeDeleteVisitor(cat);
        visitor.visit(store);
        this.getGeoServer().reload();
    }

    @Test
    public void testNativeCoverageName() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        CoverageStoreInfo store = cb.buildCoverageStore("geotiff");
        store.setURL(MockData.class.getResource("/org/geoserver/data/test/tazdem.tiff").toExternalForm());
        store.setType("GeoTIFF");
        cat.add((StoreInfo)store);
        cb.setStore((StoreInfo)store);
        CoverageInfo ci = cb.buildCoverage();
        ci.setNativeCoverageName("geotiff_coverage");
        cat.add((ResourceInfo)ci);
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, GeoTools.getDefaultHints());
        GeneralBounds envelop = reader.getOriginalEnvelope();
        Assert.assertNotNull((Object)ci);
        Assert.assertTrue((boolean)(reader.getFormat() instanceof GeoTiffFormat));
        Assert.assertNotNull((Object)envelop);
        Assert.assertEquals((Object)"tazdem", (Object)ci.getNativeCoverageName());
    }

    @RunTestSetup
    @Test
    public void testGeoServerReload() throws Exception {
        Catalog cat = this.getCatalog();
        FeatureTypeInfo lakes = cat.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        Assert.assertNotEquals((Object)"foo", (Object)lakes.getTitle());
        GeoServerDataDirectory dd = new GeoServerDataDirectory(this.getResourceLoader());
        File info = dd.config(lakes).file();
        try (FileReader in = new FileReader(info);){
            Element dom = ReaderUtils.parse((Reader)in);
            Element title = ReaderUtils.getChildElement((Element)dom, (String)"title");
            title.getFirstChild().setNodeValue("foo");
            try (FileOutputStream output = new FileOutputStream(info);){
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(dom), new StreamResult(output));
            }
            this.getGeoServer().reload();
            lakes = cat.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
            Assert.assertEquals((Object)"foo", (Object)lakes.getTitle());
        }
    }

    @Test
    public void testSEStyleWithRelativePath() throws IOException {
        StyleInfo si = this.getCatalog().getStyleByName("relative");
        Assert.assertNotNull((Object)si);
        Style style = si.getStyle();
        PolygonSymbolizer ps = (PolygonSymbolizer)((Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        ExternalGraphic eg = (ExternalGraphic)ps.getFill().getGraphicFill().graphicalSymbols().get(0);
        URI uri = eg.getOnlineResource().getLinkage();
        Assert.assertNotNull((Object)uri);
        File actual = URLs.urlToFile((URL)uri.toURL()).getCanonicalFile();
        Assert.assertEquals((Object)rockFillSymbolFile, (Object)actual);
    }

    @Test
    public void testSEStyleWithRelativePathProtocol() throws IOException {
        StyleInfo si = this.getCatalog().getStyleByName("relative_protocol");
        Assert.assertNotNull((Object)si);
        Style style = si.getStyle();
        PolygonSymbolizer ps = (PolygonSymbolizer)((Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        ExternalGraphic eg = (ExternalGraphic)ps.getFill().getGraphicFill().graphicalSymbols().get(0);
        URI uri = eg.getOnlineResource().getLinkage();
        Assert.assertNotNull((Object)uri);
        File actual = URLs.urlToFile((URL)uri.toURL()).getCanonicalFile();
        Assert.assertEquals((Object)rockFillSymbolFile, (Object)actual);
    }

    @Test
    public void testPreserveStructuredReader() throws IOException {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(TIMERANGES));
        Assert.assertTrue((boolean)(ci.getGridCoverageReader(null, null) instanceof StructuredGridCoverage2DReader));
        String name = ci.getGridCoverageReader(null, null).getGridCoverageNames()[0];
        ci.setNativeCoverageName(name);
        this.getCatalog().save((ResourceInfo)ci);
        ci = this.getCatalog().getCoverageByName(this.getLayerId(TIMERANGES));
        Assert.assertTrue((boolean)(ci.getGridCoverageReader(null, null) instanceof StructuredGridCoverage2DReader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingNullValuesInCoverageDimensions() throws IOException {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        List dimensions = ci.getDimensions();
        ((CoverageDimensionInfo)dimensions.get(0)).getNullValues().clear();
        this.getCatalog().save((ResourceInfo)ci);
        ci = this.getCatalog().getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        GridCoverageReader reader = ci.getGridCoverageReader(null, null);
        GridCoverage2D gc = null;
        try {
            gc = (GridCoverage2D)reader.read(null);
            Assert.assertEquals((double)-9999.0, (double)CoverageUtilities.getNoDataProperty((GridCoverage2D)gc).getAsSingleValue(), (double)0.0);
        }
        finally {
            if (gc != null) {
                RenderedImage ri = gc.getRenderedImage();
                if (gc instanceof GridCoverage2D) {
                    gc.dispose(true);
                }
                if (ri instanceof PlanarImage) {
                    ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RunTestSetup
    @Test
    public void testEnvParametrizationValues() throws Exception {
        GeoServerEnvironment gsEnvironment = (GeoServerEnvironment)GeoServerExtensions.bean(GeoServerEnvironment.class);
        DataStoreInfo ds = this.getCatalog().getFactory().createDataStore();
        ds.getConnectionParameters().put("host", "${jdbc.host}");
        ds.getConnectionParameters().put("port", "${jdbc.port}");
        try {
            String dsName = "GS-ENV-TEST-DS";
            ds.setName("GS-ENV-TEST-DS");
            this.getCatalog().save((StoreInfo)ds);
            ds = this.getCatalog().getDataStoreByName("GS-ENV-TEST-DS");
            DataStoreInfo expandedDs = this.getCatalog().getResourcePool().clone(ds, true);
            Assert.assertEquals((Object)"${jdbc.host}", ds.getConnectionParameters().get("host"));
            Assert.assertEquals((Object)"${jdbc.port}", ds.getConnectionParameters().get("port"));
            if (GeoServerEnvironment.allowEnvParametrization()) {
                Assert.assertEquals(expandedDs.getConnectionParameters().get("host"), (Object)gsEnvironment.resolveValue((Object)"${jdbc.host}"));
                Assert.assertEquals(expandedDs.getConnectionParameters().get("port"), (Object)gsEnvironment.resolveValue((Object)"${jdbc.port}"));
            } else {
                Assert.assertEquals((Object)"${jdbc.host}", expandedDs.getConnectionParameters().get("host"));
                Assert.assertEquals((Object)"${jdbc.port}", expandedDs.getConnectionParameters().get("port"));
            }
        }
        finally {
            this.getCatalog().remove((StoreInfo)ds);
        }
    }

    @Test
    public void testCloneStoreInfo() throws Exception {
        Catalog catalog = this.getCatalog();
        DataStoreInfo source1 = (DataStoreInfo)catalog.getDataStores().get(0);
        DataStoreInfo clonedDs = catalog.getResourcePool().clone(source1, false);
        Assert.assertNotNull((Object)source1);
        Assert.assertNotNull((Object)clonedDs);
        Assert.assertEquals((Object)source1, (Object)clonedDs);
        CoverageStoreInfo source2 = (CoverageStoreInfo)catalog.getCoverageStores().get(0);
        CoverageStoreInfo clonedCs = catalog.getResourcePool().clone(source2, false);
        Assert.assertNotNull((Object)source2);
        Assert.assertNotNull((Object)clonedCs);
        Assert.assertEquals((Object)source2, (Object)clonedCs);
    }

    @Test
    public void testAddFilePathWithSpaces() throws Exception {
        ((ResourcePoolInitializer)GeoServerExtensions.extensions(ResourcePoolInitializer.class).get(0)).initialize(this.getGeoServer());
        ResourcePool rp = this.getCatalog().getResourcePool();
        CoverageStoreInfo info = this.getCatalog().getFactory().createCoverageStore();
        info.setName("spaces");
        info.setType("ImagePyramid");
        info.setEnabled(true);
        info.setURL("file://./src/test/resources/data_dir/nested_layer_groups/data/pyramid with space");
        try {
            rp.getGridCoverageReader(info, null);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "", e);
            Assert.fail((String)"Unable to add an imagepyramid with a space in it's name");
        }
        rp.dispose();
    }

    @Test
    public void testWmsCascadeEntityExpansion() throws Exception {
        Exception cause;
        SAXException saxException;
        ServiceException serviceException;
        ((ResourcePoolInitializer)GeoServerExtensions.extensions(ResourcePoolInitializer.class).get(0)).initialize(this.getGeoServer());
        ResourcePool rp = this.getCatalog().getResourcePool();
        WMSStoreInfo info = this.getCatalog().getFactory().createWebMapServer();
        ((WMSStoreInfoImpl)info).setId(UUID.randomUUID().toString());
        URL url = this.getClass().getResource("1.3.0Capabilities-xxe.xml");
        info.setCapabilitiesURL(url.toExternalForm());
        info.setEnabled(true);
        info.setUseConnectionPooling(false);
        try {
            rp.getWebMapServer(info);
            Assert.fail((String)"WebMapServer instantiation should fail");
        }
        catch (IOException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(ServiceException.class));
            serviceException = (ServiceException)e.getCause();
            MatcherAssert.assertThat((Object)serviceException.getMessage(), (Matcher)CoreMatchers.containsString((String)"Error while parsing XML"));
            saxException = (SAXException)serviceException.getCause();
            cause = saxException.getException();
            Assert.assertFalse((String)"Expect external entity cause", (cause != null && cause instanceof FileNotFoundException ? 1 : 0) != 0);
        }
        this.getGeoServer().reload();
        rp = this.getCatalog().getResourcePool();
        try {
            rp.getWebMapServer(info);
            Assert.fail((String)"WebMapServer instantiation should fail");
        }
        catch (IOException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(ServiceException.class));
            serviceException = (ServiceException)e.getCause();
            MatcherAssert.assertThat((Object)serviceException.getMessage(), (Matcher)CoreMatchers.containsString((String)"Error while parsing XML"));
            saxException = (SAXException)serviceException.getCause();
            cause = saxException.getException();
            Assert.assertFalse((String)"Expect external entity cause", (cause != null && cause instanceof FileNotFoundException ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWfsCascadeEntityExpansion() throws Exception {
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        DataStoreInfo ds = cb.buildDataStore("wfs-xxe");
        URL url = this.getClass().getResource("wfs1.1.0Capabilities-xxe.xml");
        ds.getConnectionParameters().put(WFSDataStoreFactory.URL.key, url);
        ds.getConnectionParameters().put("TESTING", Boolean.TRUE);
        ResourcePool rp = this.getCatalog().getResourcePool();
        try {
            rp.getDataStore(ds);
            Assert.fail((String)"Store creation should have failed to to XXE attack");
        }
        catch (Exception e) {
            String message = e.getMessage();
            MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"Entity resolution disallowed"));
            MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"file:///file/not/there"));
        }
    }

    @Test
    public void testStyleWithExternalEntities() throws Exception {
        StyleInfo si = this.getCatalog().getStyleByName(EXTERNAL_ENTITIES);
        try {
            si.getStyle();
            Assert.fail((String)"Should have failed with a parse error");
        }
        catch (Exception e) {
            String message = e.getMessage();
            MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"Entity resolution disallowed"));
            MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"/this/file/does/not/exist"));
        }
    }

    @Test
    public void testWriteStyleThatFails() throws Exception {
        StyleInfo style = this.getCatalog().getFactory().createStyle();
        style.setName("foo");
        style.setFilename("foo.sld");
        style.setFormat(null);
        ((StyleInfoImpl)style).setId(UUID.randomUUID().toString());
        File sldFile = new File(((SystemTestData)this.getTestData()).getDataDirectoryRoot().getAbsolutePath(), "styles/foo.sld");
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        try {
            ResourcePool pool = new ResourcePool(this.getCatalog());
            pool.writeSLD(style, sld);
            Assert.fail((String)"Should fail with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertFalse((String)"foo.sld should not exist on disk after a failure.", (boolean)sldFile.exists());
    }

    @Test(expected=FileNotFoundException.class)
    public void testMissingStyleThrowsException() throws IOException {
        Catalog catalog = this.getCatalog();
        StyleInfo missing = catalog.getFactory().createStyle();
        missing.setName("missing");
        missing.setFilename("missing.sld");
        ResourcePool pool = new ResourcePool(catalog);
        try (BufferedReader ignored = pool.readStyle(missing);){
            Assert.fail((String)"FileNotFoundException expected for missing style files");
        }
    }

    @Test
    public void testParseExternalMark() throws Exception {
        StyleInfo si = this.getCatalog().getStyleByName(HUMANS);
        Style s = si.getStyle();
        s.accept((StyleVisitor)new AbstractStyleVisitor(){

            public void visit(Mark mark) {
                Assert.assertEquals((Object)"ttf://Webdings", (Object)mark.getExternalMark().getOnlineResource().getLinkage().toASCIIString());
            }
        });
    }

    @Test
    public void testSourceIsNotIncorrectlyWrappedAndCanLock() throws IOException {
        Catalog cat = this.getCatalog();
        ResourcePool resourcePool = cat.getResourcePool();
        FeatureTypeInfo featureTypeInfo = cat.getFeatureTypeByName("Lines");
        featureTypeInfo.getAttributes().addAll(featureTypeInfo.attributes());
        FeatureSource source = resourcePool.getFeatureSource(featureTypeInfo, null);
        Assert.assertTrue((boolean)(source instanceof SimpleFeatureLocking));
    }

    @Test
    public void testDataStoreScan() throws Exception {
        Catalog catalog = this.getCatalog();
        Catalog cat = this.getCatalog();
        DataStoreInfo ds = cat.getFactory().createDataStore();
        ds.setName(SQLVIEW_DATASTORE);
        WorkspaceInfo ws = cat.getDefaultWorkspace();
        ds.setWorkspace(ws);
        ds.setEnabled(true);
        Map params = ds.getConnectionParameters();
        params.put("dbtype", "h2");
        File dbFile = new File(((SystemTestData)this.getTestData()).getDataDirectoryRoot().getAbsolutePath(), "data/h2test");
        params.put("database", dbFile.getAbsolutePath());
        cat.add((StoreInfo)ds);
        SimpleFeatureSource fsp = this.getFeatureSource(SystemTestData.PRIMITIVEGEOFEATURE);
        DataStore store = (DataStore)ds.getDataStore(null);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init((SimpleFeatureType)fsp.getSchema());
        tb.remove("surfaceProperty");
        tb.remove("curveProperty");
        tb.remove("uriProperty");
        tb.setName("pgeo");
        SimpleFeatureType schema = tb.buildFeatureType();
        store.createSchema((FeatureType)schema);
        SimpleFeatureStore featureStore = (SimpleFeatureStore)store.getFeatureSource("pgeo");
        featureStore.addFeatures((FeatureCollection)fsp.getFeatures());
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)ds);
        FeatureTypeInfo tft = cb.buildFeatureType((FeatureSource)featureStore);
        cat.add((ResourceInfo)tft);
        JDBCDataStore jds = (JDBCDataStore)ds.getDataStore(null);
        VirtualTable vt = new VirtualTable(VT_NAME, "select \"name\", \"pointProperty\" from \"pgeo\" where \"booleanProperty\" = %bool% and \"name\" = '%name%'");
        vt.addParameter(new VirtualTableParameter("bool", "true"));
        vt.addParameter(new VirtualTableParameter("name", "name-f001"));
        vt.addGeometryMetadatata("pointProperty", Point.class, 4326);
        jds.createVirtualTable(vt);
        FeatureTypeInfo vft = cb.buildFeatureType((FeatureSource)jds.getFeatureSource(vt.getName()));
        vft.getMetadata().put("JDBC_VIRTUAL_TABLE", (Serializable)vt);
        cat.add((ResourceInfo)vft);
        final AtomicInteger counter = new AtomicInteger();
        ResourcePool testPool = new ResourcePool(){

            protected Name getTemporaryName(FeatureTypeInfo info, DataAccess<? extends FeatureType, ? extends Feature> dataAccess, FeatureTypeCallback initializer) throws IOException {
                if (ResourcePoolTest.VT_NAME.equals(info.getNativeName())) {
                    counter.incrementAndGet();
                }
                return super.getTemporaryName(info, dataAccess, initializer);
            }
        };
        testPool.setCatalog(catalog);
        FeatureTypeInfo ft = catalog.getFeatureTypeByName(VT_NAME);
        testPool.getFeatureSource(ft, null);
        Assert.assertEquals((long)0L, (long)counter.get());
        ft.setName("foobar");
        testPool.getFeatureSource(ft, null);
        MatcherAssert.assertThat((Object)counter.get(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testRepositoryHints() throws Exception {
        Catalog catalog = this.getCatalog();
        ResourcePool pool = new ResourcePool(catalog){

            public CoverageStoreInfo clone(CoverageStoreInfo source, boolean allowEnvParametrization) {
                return source;
            }
        };
        String url = "http://www.geoserver.org/mock/format";
        AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)EasyMock.createNiceMock((String)"theReader", AbstractGridCoverage2DReader.class);
        EasyMock.replay((Object[])new Object[]{reader});
        AbstractGridFormat format = (AbstractGridFormat)EasyMock.createNiceMock((String)"theFormat", AbstractGridFormat.class);
        Capture capturedHints = Capture.newInstance((CaptureType)CaptureType.LAST);
        EasyMock.expect((Object)format.getReader(EasyMock.eq((Object)"http://www.geoserver.org/mock/format"), (Hints)EasyMock.capture((Capture)capturedHints))).andReturn((Object)reader).anyTimes();
        EasyMock.replay((Object[])new Object[]{format});
        CoverageStoreInfo storeInfo = (CoverageStoreInfo)EasyMock.createNiceMock((String)"storeInfo", CoverageStoreInfo.class);
        EasyMock.expect((Object)storeInfo.getURL()).andReturn((Object)"http://www.geoserver.org/mock/format").anyTimes();
        EasyMock.expect((Object)storeInfo.getFormat()).andReturn((Object)format).anyTimes();
        EasyMock.replay((Object[])new Object[]{storeInfo});
        GridCoverageReader returnedReader = pool.getGridCoverageReader(storeInfo, null);
        MatcherAssert.assertThat((Object)reader, (Matcher)Matchers.equalTo((Object)returnedReader));
        Hints hints1 = (Hints)capturedHints.getValue();
        MatcherAssert.assertThat((Object)hints1, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)hints1, (Matcher)Matchers.hasEntry((Object)Hints.REPOSITORY, (Object)pool.repository));
        capturedHints.reset();
        GridCoverageReader returnedReader2 = pool.getGridCoverageReader(storeInfo, new Hints(Hints.KEY_ANTIALIASING, Hints.VALUE_ANTIALIAS_ON));
        MatcherAssert.assertThat((Object)reader, (Matcher)Matchers.equalTo((Object)returnedReader2));
        Hints hints2 = (Hints)capturedHints.getValue();
        MatcherAssert.assertThat((Object)hints2, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)hints2, (Matcher)Matchers.hasEntry((Object)Hints.REPOSITORY, (Object)pool.repository));
        MatcherAssert.assertThat((Object)hints2, (Matcher)Matchers.hasEntry((Object)Hints.KEY_ANTIALIASING, (Object)Hints.VALUE_ANTIALIAS_ON));
    }

    @Test
    public void testGetParamsFixesDatabaseFilePath() {
        Catalog catalog = this.getCatalog();
        ResourcePool pool = new ResourcePool(catalog);
        DataStoreInfo ds = this.getCatalog().getFactory().createDataStore();
        ds.getConnectionParameters().put("database", "file:data/test.gpkg");
        Map newParams = ResourcePool.getParams((Map)ds.getConnectionParameters(), (GeoServerResourceLoader)this.getResourceLoader());
        GeoServerDataDirectory dataDir = new GeoServerDataDirectory(this.getResourceLoader());
        String absolutePath = dataDir.get(new String[]{"data/test.gpkg"}).dir().getAbsolutePath();
        Assert.assertNotEquals(newParams.get("database"), (Object)"file:data/test.gpkg");
        Assert.assertTrue((boolean)((String)newParams.get("database")).contains(absolutePath));
    }

    @Test
    public void testGetParamsFixesCSVFilePath() {
        Catalog catalog = this.getCatalog();
        ResourcePool pool = new ResourcePool(catalog);
        DataStoreInfo ds = this.getCatalog().getFactory().createDataStore();
        ds.getConnectionParameters().put("file", "file:data/locations.csv");
        Map newParams = ResourcePool.getParams((Map)ds.getConnectionParameters(), (GeoServerResourceLoader)this.getResourceLoader());
        GeoServerDataDirectory dataDir = new GeoServerDataDirectory(this.getResourceLoader());
        String absolutePath = dataDir.get(new String[]{"data/locations.csv"}).file().getAbsolutePath();
        Assert.assertNotEquals(newParams.get("file"), (Object)"file:locations.csv");
        Assert.assertTrue((boolean)((String)newParams.get("file")).contains(absolutePath));
    }

    @Test
    public void testEmptySort() throws IOException, IllegalAccessException {
        SimpleFeatureSource fsp = this.getFeatureSource(SystemTestData.PRIMITIVEGEOFEATURE);
        Query q = new Query();
        q.setSortBy(SortBy.UNSORTED);
        SimpleFeatureCollection fc = fsp.getFeatures(q);
        while (fc instanceof DecoratingFeatureCollection) {
            MatcherAssert.assertThat((Object)fc, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(SortedSimpleFeatureCollection.class)));
            Field field = FieldUtils.getDeclaredField(SortedSimpleFeatureCollection.class, (String)"delegate");
            field.setAccessible(true);
            Object delegate = field.get(fc);
            fc = (SimpleFeatureCollection)delegate;
        }
    }

    @Test
    public void testDefaultGeometry() throws IOException {
        FeatureTypeInfo featureType = (FeatureTypeInfo)this.getCatalog().getResourceByName("cdf", "Nulls", FeatureTypeInfo.class);
        GeometryDescriptor schemaDefaultGeometry = featureType.getFeatureType().getGeometryDescriptor();
        try (FeatureIterator i = featureType.getFeatureSource(null, null).getFeatures().features();){
            GeometryDescriptor featureDefaultGeometry = i.next().getDefaultGeometryProperty().getDescriptor();
            Assert.assertNotNull((Object)schemaDefaultGeometry);
            Assert.assertNotNull((Object)featureDefaultGeometry);
            Assert.assertEquals((Object)"pointProperty", (Object)schemaDefaultGeometry.getLocalName());
            Assert.assertEquals((Object)schemaDefaultGeometry, (Object)featureDefaultGeometry);
        }
    }

    @Test
    public void testCoverageReaderInputConverter() throws IOException {
        Catalog catalog = this.getCatalog();
        ResourcePool pool = new ResourcePool(catalog);
        CoverageStoreInfo info = catalog.getFactory().createCoverageStore();
        info.setType("ImagePyramid");
        info.setURL("file://./src/test/resources/data_dir/nested_layer_groups/data/pyramid%20with%20space");
        GridCoverageReader reader = pool.getGridCoverageReader(info, null);
        Assert.assertTrue((boolean)(reader.getSource() instanceof File));
    }

    @Test
    public void testCoverageReaderInputConverterInvalidURI() throws IOException {
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_WINDOWS);
        Object fileURL = MockData.class.getResource("tazdem.tiff").getFile().replace("/", "\\");
        fileURL = "file://" + (String)fileURL;
        Catalog catalog = this.getCatalog();
        ResourcePool pool = new ResourcePool(catalog);
        CoverageStoreInfo info = catalog.getFactory().createCoverageStore();
        info.setType("GeoTIFF");
        info.setURL((String)fileURL);
        GridCoverageReader reader = pool.getGridCoverageReader(info, null);
        Assert.assertTrue((boolean)(reader.getSource() instanceof File));
    }

    @Test
    public void testCoverageReaderInputConverterFilePath() throws IOException {
        String fileURL = MockData.class.getResource("tazdem.tiff").getFile();
        Catalog catalog = this.getCatalog();
        ResourcePool pool = new ResourcePool(catalog);
        CoverageStoreInfo info = catalog.getFactory().createCoverageStore();
        info.setType("GeoTIFF");
        info.setURL(fileURL);
        GridCoverageReader reader = pool.getGridCoverageReader(info, null);
        Assert.assertTrue((boolean)(reader.getSource() instanceof File));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDataStoreConcurrency() throws Exception {
        ResourcePool pool = null;
        List<ResourcePoolLatchedThread<DataStoreInfo, DataAccess>> threads = null;
        try {
            Catalog catalog = this.getCatalog();
            DataStoreInfo ds = this.storeInfo(catalog, "concurrencyTest1");
            pool = new ResourcePool(this.getCatalog());
            ResourcePoolLatchedThread.PoolBiFunction<DataStoreInfo, DataAccess> function = (resPool, info) -> resPool.getDataStore(info);
            CountDownLatch taskLatch = new CountDownLatch(1);
            int numberOfThreads = 5;
            CountDownLatch completeLatch = new CountDownLatch(numberOfThreads);
            threads = this.getLatchedThreads(taskLatch, completeLatch, numberOfThreads, pool, ds, function);
            threads.forEach(t -> t.start());
            taskLatch.countDown();
            completeLatch.await(60L, TimeUnit.SECONDS);
            DataAccess dA = (DataAccess)pool.dataStoreCache.get((Object)ds.getId());
            Assert.assertNotNull((Object)dA);
            for (ResourcePoolLatchedThread<DataStoreInfo, DataAccess> t2 : threads) {
                Assert.assertSame((Object)dA, (Object)t2.getResult());
                Assert.assertTrue((boolean)t2.getErrors().isEmpty());
            }
        }
        finally {
            if (pool != null) {
                pool.dispose();
            }
            this.killThreads(threads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonBlockingThreadOnGetStore() throws Exception {
        ResourcePool resPool = null;
        ResourcePoolLatchedThread<DataStoreInfo, DataAccess> latchedThread1 = null;
        ResourcePoolLatchedThread<DataStoreInfo, DataAccess> latchedThread2 = null;
        try {
            Catalog catalog = this.getCatalog();
            final DataStoreInfo ds = this.storeInfo(catalog, "concurrencyTest2");
            DataStoreInfo ds2 = this.storeInfo(catalog, "concurrencyTest3");
            CountDownLatch taskLatch = new CountDownLatch(1);
            final CountDownLatch taskLatch2 = new CountDownLatch(1);
            resPool = new ResourcePool(catalog){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected DataAccess<? extends FeatureType, ? extends Feature> createDataAccess(DataStoreInfo info, DataStoreInfo expandedStore) throws IOException {
                    if (ds.getId().equalsIgnoreCase(info.getId())) {
                        Thread thread;
                        Thread thread2 = thread = Thread.currentThread();
                        synchronized (thread2) {
                            try {
                                taskLatch2.countDown();
                                thread.wait(60000L);
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    return super.createDataAccess(info, expandedStore);
                }
            };
            ResourcePoolLatchedThread.PoolBiFunction<DataStoreInfo, DataAccess> function = (pool, info) -> pool.getDataStore(info);
            CountDownLatch completeLatch = new CountDownLatch(2);
            latchedThread1 = new ResourcePoolLatchedThread<DataStoreInfo, DataAccess>(taskLatch, completeLatch, resPool, ds, function);
            latchedThread2 = new ResourcePoolLatchedThread<DataStoreInfo, DataAccess>(taskLatch2, completeLatch, resPool, ds2, function);
            latchedThread1.start();
            latchedThread2.start();
            taskLatch.countDown();
            latchedThread2.join(60000L);
            DataAccess access = (DataAccess)resPool.dataStoreCache.get((Object)ds2.getId());
            Assert.assertSame((Object)access, (Object)latchedThread2.getResult());
            Assert.assertNull((Object)latchedThread1.getResult());
            ResourcePoolLatchedThread<DataStoreInfo, DataAccess> resourcePoolLatchedThread = latchedThread1;
            synchronized (resourcePoolLatchedThread) {
                latchedThread1.notify();
            }
            completeLatch.await(60L, TimeUnit.SECONDS);
            DataAccess dA = (DataAccess)resPool.dataStoreCache.get((Object)ds.getId());
            Assert.assertNotNull((Object)dA);
            Assert.assertSame((Object)dA, (Object)latchedThread1.getResult());
        }
        finally {
            if (resPool != null) {
                resPool.dispose();
            }
            this.killThread(latchedThread1);
            this.killThread(latchedThread2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrencyOnFeatureTypeCache() throws Exception {
        ResourcePool pool = null;
        List<ResourcePoolLatchedThread<FeatureTypeInfo, FeatureType>> threads = null;
        try {
            pool = ResourcePool.create((Catalog)this.getCatalog());
            FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
            CountDownLatch taskLatch = new CountDownLatch(1);
            int numberOfThreads = 5;
            CountDownLatch completeLatch = new CountDownLatch(numberOfThreads);
            ResourcePoolLatchedThread.PoolBiFunction<FeatureTypeInfo, FeatureType> function = (rl, fti) -> rl.getFeatureType(info, false);
            threads = this.getLatchedThreads(taskLatch, completeLatch, numberOfThreads, pool, info, function);
            threads.forEach(t -> t.start());
            taskLatch.countDown();
            completeLatch.await(60L, TimeUnit.SECONDS);
            FeatureType featureType = pool.getFeatureType(info, false);
            for (ResourcePoolLatchedThread<FeatureTypeInfo, FeatureType> t2 : threads) {
                Assert.assertSame((Object)featureType, (Object)t2.getResult());
                Assert.assertTrue((boolean)t2.getErrors().isEmpty());
            }
        }
        finally {
            if (pool != null) {
                pool.dispose();
            }
            this.killThreads(threads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrencyOnCRSCache() throws Exception {
        ResourcePool pool = null;
        List<ResourcePoolLatchedThread<String, CoordinateReferenceSystem>> threads = null;
        try {
            pool = ResourcePool.create((Catalog)this.getCatalog());
            String srs = "EPSG:4326";
            CountDownLatch taskLatch = new CountDownLatch(1);
            int numberOfThreads = 5;
            CountDownLatch completeLatch = new CountDownLatch(numberOfThreads);
            ResourcePoolLatchedThread.PoolBiFunction<String, CoordinateReferenceSystem> function = (rl, srsName) -> rl.getCRS(srsName);
            threads = this.getLatchedThreads(taskLatch, completeLatch, numberOfThreads, pool, srs, function);
            threads.forEach(t -> t.start());
            taskLatch.countDown();
            completeLatch.await(60L, TimeUnit.SECONDS);
            CoordinateReferenceSystem crs = (CoordinateReferenceSystem)pool.getCrsCache().get(srs);
            for (ResourcePoolLatchedThread<String, CoordinateReferenceSystem> t2 : threads) {
                Assert.assertSame((Object)crs, (Object)t2.getResult());
                Assert.assertTrue((boolean)t2.getErrors().isEmpty());
            }
        }
        finally {
            if (pool != null) {
                pool.dispose();
            }
            this.killThreads(threads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrencyOnStyleCache() throws Exception {
        ResourcePool pool = null;
        List<ResourcePoolLatchedThread<StyleInfo, Style>> threads = null;
        try {
            pool = ResourcePool.create((Catalog)this.getCatalog());
            StyleInfo info = this.getCatalog().getStyleByName(HUMANS);
            CountDownLatch taskLatch = new CountDownLatch(1);
            int numberOfThreads = 5;
            CountDownLatch completeLatch = new CountDownLatch(numberOfThreads);
            ResourcePoolLatchedThread.PoolBiFunction<StyleInfo, Style> function = (rl, styleInfo) -> rl.getStyle(styleInfo);
            threads = this.getLatchedThreads(taskLatch, completeLatch, numberOfThreads, pool, info, function);
            threads.forEach(t -> t.start());
            taskLatch.countDown();
            completeLatch.await();
            Style style = (Style)pool.getStyleCache().get(info.getId());
            for (ResourcePoolLatchedThread<StyleInfo, Style> t2 : threads) {
                Assert.assertSame((Object)style, (Object)t2.getResult());
                Assert.assertTrue((boolean)t2.getErrors().isEmpty());
            }
        }
        finally {
            if (pool != null) {
                pool.dispose();
            }
            this.killThreads(threads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrencyOnSLDCache() throws Exception {
        ResourcePool pool = null;
        List<ResourcePoolLatchedThread<StyleInfo, StyledLayerDescriptor>> threads = null;
        try {
            pool = ResourcePool.create((Catalog)this.getCatalog());
            StyleInfo info = this.getCatalog().getStyleByName(HUMANS);
            CountDownLatch taskLatch = new CountDownLatch(1);
            int numberOfThreads = 5;
            CountDownLatch completeLatch = new CountDownLatch(numberOfThreads);
            ResourcePoolLatchedThread.PoolBiFunction<StyleInfo, StyledLayerDescriptor> function = (rl, styleInfo) -> rl.getSld(styleInfo);
            threads = this.getLatchedThreads(taskLatch, completeLatch, numberOfThreads, pool, info, function);
            threads.forEach(t -> t.start());
            taskLatch.countDown();
            completeLatch.await();
            StyledLayerDescriptor sld = (StyledLayerDescriptor)pool.getSldCache().get(info.getId());
            for (ResourcePoolLatchedThread<StyleInfo, StyledLayerDescriptor> t2 : threads) {
                Assert.assertSame((Object)sld, (Object)t2.getResult());
                Assert.assertTrue((boolean)t2.getErrors().isEmpty());
            }
        }
        finally {
            if (pool != null) {
                pool.dispose();
            }
            this.killThreads(threads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrencyOnFeatureTypeAttrsCache() throws Exception {
        ResourcePool pool = null;
        List<ResourcePoolLatchedThread<FeatureTypeInfo, List>> threads = null;
        try {
            pool = ResourcePool.create((Catalog)this.getCatalog());
            FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
            CountDownLatch taskLatch = new CountDownLatch(1);
            int numberOfThreads = 5;
            CountDownLatch completeLatch = new CountDownLatch(numberOfThreads);
            ResourcePoolLatchedThread.PoolBiFunction<FeatureTypeInfo, List> function = (rl, fti) -> rl.getAttributes(info);
            threads = this.getLatchedThreads(taskLatch, completeLatch, numberOfThreads, pool, info, function);
            threads.forEach(t -> t.start());
            taskLatch.countDown();
            completeLatch.await(60L, TimeUnit.SECONDS);
            List list = pool.getAttributes(info);
            for (ResourcePoolLatchedThread<FeatureTypeInfo, List> t2 : threads) {
                Assert.assertSame((Object)list, (Object)t2.getResult());
                Assert.assertTrue((boolean)t2.getErrors().isEmpty());
            }
        }
        finally {
            if (pool != null) {
                pool.dispose();
            }
            this.killThreads(threads);
        }
    }

    private DataStoreInfo storeInfo(Catalog catalog, String name) {
        DataStoreInfoImpl ds = new DataStoreInfoImpl(catalog);
        ds.setId(UUID.randomUUID().toString());
        ds.setName(name);
        WorkspaceInfo ws = catalog.getDefaultWorkspace();
        ds.setWorkspace(ws);
        ds.setEnabled(true);
        Map params = ds.getConnectionParameters();
        params.put("dbtype", "h2");
        File dbFile = new File(((SystemTestData)this.getTestData()).getDataDirectoryRoot().getAbsolutePath(), "data/h2test");
        params.put("database", dbFile.getAbsolutePath());
        catalog.add((StoreInfo)ds);
        return ds;
    }

    private <P, R> List<ResourcePoolLatchedThread<P, R>> getLatchedThreads(CountDownLatch taskLatch, CountDownLatch completeLatch, int numberOfThreads, ResourcePool resourcePool, P funParam, ResourcePoolLatchedThread.PoolBiFunction<P, R> function) {
        ArrayList<ResourcePoolLatchedThread<P, R>> threads = new ArrayList<ResourcePoolLatchedThread<P, R>>(numberOfThreads);
        for (int i = 0; i < numberOfThreads; ++i) {
            threads.add(new ResourcePoolLatchedThread<P, R>(taskLatch, completeLatch, resourcePool, funParam, function));
        }
        return threads;
    }

    private void killThreads(List threads) {
        if (threads != null && !threads.isEmpty()) {
            for (Object thread : threads) {
                if (!(thread instanceof Thread)) continue;
                this.killThread((Thread)thread);
            }
        }
    }

    private void killThread(Thread thread) {
        if (thread != null && thread.isAlive()) {
            thread.interrupt();
        }
    }

    @Test
    public void testAutodisableOnConnfailure() {
        Catalog cat = this.getCatalog();
        DataStoreInfo ds = cat.getFactory().createDataStore();
        ds.setName(BAD_CONN_DATASTORE);
        WorkspaceInfo ws = cat.getDefaultWorkspace();
        ds.setWorkspace(ws);
        ds.setEnabled(true);
        ds.setDisableOnConnFailure(true);
        ds.setType("H2");
        Map params = ds.getConnectionParameters();
        params.put("dbtype", "h2");
        params.put("database", "");
        cat.add((StoreInfo)ds);
        DataStoreInfo dsi = cat.getDataStoreByName(ds.getName());
        Assert.assertTrue((boolean)dsi.isEnabled());
        ResourcePool resourcePool = ResourcePool.create((Catalog)cat);
        DataAccess access = null;
        try {
            access = resourcePool.getDataStore(dsi);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertNull((Object)access);
        DataStoreInfo storeInfo = cat.getDataStoreByName(dsi.getName());
        Assert.assertFalse((boolean)storeInfo.isEnabled());
    }

    @Test
    public void testWmsCascadeAutoDisable() throws Exception {
        ((ResourcePoolInitializer)GeoServerExtensions.extensions(ResourcePoolInitializer.class).get(0)).initialize(this.getGeoServer());
        ResourcePool rp = this.getCatalog().getResourcePool();
        WMSStoreInfo info = this.getCatalog().getFactory().createWebMapServer();
        info.setName("TestAutoDisableWMSStore");
        URL url = this.getClass().getResource("1.3.0Capabilities-xxe.xml");
        info.setCapabilitiesURL(url.toExternalForm());
        info.setEnabled(true);
        info.setDisableOnConnFailure(true);
        info.setUseConnectionPooling(false);
        this.getCatalog().add((StoreInfo)info);
        WMSStoreInfo wmsStore = this.getCatalog().getWMSStoreByName(info.getName());
        Assert.assertTrue((boolean)wmsStore.isEnabled());
        try {
            rp.getWebMapServer(wmsStore);
        }
        catch (IOException e) {
            wmsStore = this.getCatalog().getWMSStoreByName(info.getName());
        }
        Assert.assertFalse((boolean)wmsStore.isEnabled());
    }

    @Test
    public void testWmtsCascadeAutoDisable() throws Exception {
        ((ResourcePoolInitializer)GeoServerExtensions.extensions(ResourcePoolInitializer.class).get(0)).initialize(this.getGeoServer());
        ResourcePool rp = this.getCatalog().getResourcePool();
        WMTSStoreInfo info = this.getCatalog().getFactory().createWebMapTileServer();
        info.setName("TestAutoDisableWMTSStore");
        URL url = this.getClass().getResource("1.3.0Capabilities-xxe.xml");
        info.setCapabilitiesURL(url.toExternalForm());
        info.setEnabled(true);
        info.setDisableOnConnFailure(true);
        info.setUseConnectionPooling(false);
        this.getCatalog().add((StoreInfo)info);
        WMTSStoreInfo wmtsStore = this.getCatalog().getWMTSStoreByName(info.getName());
        Assert.assertTrue((boolean)wmtsStore.isEnabled());
        try {
            rp.getWebMapTileServer(wmtsStore);
        }
        catch (IOException e) {
            wmtsStore = this.getCatalog().getWMTSStoreByName(info.getName());
        }
        Assert.assertFalse((boolean)wmtsStore.isEnabled());
    }

    @Test
    public void testCoverageStoreInfoAutodisable() throws Exception {
        ((ResourcePoolInitializer)GeoServerExtensions.extensions(ResourcePoolInitializer.class).get(0)).initialize(this.getGeoServer());
        ResourcePool rp = this.getCatalog().getResourcePool();
        CoverageStoreInfo info = this.getCatalog().getFactory().createCoverageStore();
        info.setName("TestCoverageAutoDisable");
        info.setType("ImagePyramid");
        info.setEnabled(true);
        info.setDisableOnConnFailure(true);
        info.setURL("file://./src/test/resources/not-existing.tif");
        this.getCatalog().add((StoreInfo)info);
        CoverageStoreInfo storeInfo = this.getCatalog().getCoverageStoreByName(info.getName());
        Assert.assertTrue((boolean)storeInfo.isEnabled());
        try {
            rp.getGridCoverageReader(storeInfo, null);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "", e);
            storeInfo = this.getCatalog().getCoverageStoreByName(info.getName());
        }
        Assert.assertFalse((boolean)storeInfo.isEnabled());
        rp.dispose();
    }

    @Test
    public void testEPSGLookup() throws Exception {
        String wkt = "PROJCS[\"WGS 84 / UTM zone 32N\",\n    GEOGCS[\"WGS 84\",\n        DATUM[\"WGS_1984\",\n            SPHEROID[\"WGS 84\",6378137,298.257223563,\n                AUTHORITY[\"EPSG\",\"7030\"]]],\n        PRIMEM[\"Greenwich\",0,\n            AUTHORITY[\"EPSG\",\"8901\"]],\n        UNIT[\"degree\",0.0174532925199433,\n            AUTHORITY[\"EPSG\",\"9122\"]]],\n    PROJECTION[\"Transverse_Mercator\"],\n    PARAMETER[\"latitude_of_origin\",0],\n    PARAMETER[\"central_meridian\",9],\n    PARAMETER[\"scale_factor\",0.9996],\n    PARAMETER[\"false_easting\",500000],\n    PARAMETER[\"false_northing\",0],\n    UNIT[\"metre\",1,\n        AUTHORITY[\"EPSG\",\"9001\"]],\n    AXIS[\"Easting\",EAST],\n    AXIS[\"Northing\",NORTH]]";
        CoordinateReferenceSystem crs = CRS.parseWKT((String)wkt);
        Assert.assertEquals((Object)"EPSG:32632", (Object)ResourcePool.lookupIdentifier((CoordinateReferenceSystem)crs, (boolean)true));
    }

    @Test
    public void testIAULookup() throws Exception {
        String wkt = "GEOGCS[\"Sun (2015) - Sphere / Ocentric\",\n    DATUM[\"Sun (2015) - Sphere\",\n        SPHEROID[\"Sun (2015) - Sphere\",695700000,0,\n            AUTHORITY[\"IAU\",\"1000\"]],\n        AUTHORITY[\"IAU\",\"1000\"]],\n    PRIMEM[\"Reference Meridian\",0,\n        AUTHORITY[\"IAU\",\"1000\"]],\n    UNIT[\"degree\",0.0174532925199433,\n        AUTHORITY[\"EPSG\",\"9122\"]]]";
        CoordinateReferenceSystem crs = CRS.parseWKT((String)wkt);
        Assert.assertEquals((Object)"IAU:1000", (Object)ResourcePool.lookupIdentifier((CoordinateReferenceSystem)crs, (boolean)true));
    }

    @Test
    public void testCustomizeAttributesCRS() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo fti = catalog.getFeatureTypeByName("mini-states");
        SimpleFeatureType schema = (SimpleFeatureType)fti.getFeatureType();
        CoordinateReferenceSystem crs = schema.getCoordinateReferenceSystem();
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326", (boolean)true), (Object)crs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAcceptAllStore() throws Exception {
        ShapefileDirectoryFactory shapeDirectorFactory = null;
        TestDirectoryStoreFactorySpi testDirectoryFactory = null;
        Iterator factoryIterator = DataStoreFinder.getAllDataStores();
        while (factoryIterator.hasNext()) {
            DataStoreFactorySpi spi = (DataStoreFactorySpi)factoryIterator.next();
            if (spi instanceof TestDirectoryStoreFactorySpi) {
                testDirectoryFactory = (TestDirectoryStoreFactorySpi)spi;
                continue;
            }
            if (!(spi instanceof ShapefileDirectoryFactory)) continue;
            shapeDirectorFactory = (ShapefileDirectoryFactory)spi;
        }
        Assert.assertNotNull(shapeDirectorFactory);
        Assert.assertNotNull(testDirectoryFactory);
        Class<DataAccessFinder> clazz = DataAccessFinder.class;
        synchronized (DataAccessFinder.class) {
            FactoryRegistry registry = (FactoryRegistry)ReflectionTestUtils.invokeMethod(DataStoreFinder.class, (String)"getServiceRegistry", (Object[])new Object[0]);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            registry.setOrdering(DataStoreFactorySpi.class, (Object)testDirectoryFactory, (Object)shapeDirectorFactory);
            Catalog catalog = this.getCatalog();
            CatalogBuilder cb = new CatalogBuilder(catalog);
            DataStoreInfo dataStoreInfo = cb.buildDataStore("mini-states-dir");
            dataStoreInfo.setType("Directory of spatial files (shapefiles)");
            dataStoreInfo.getConnectionParameters().put("url", "file:data/mini-states");
            catalog.add((StoreInfo)dataStoreInfo);
            DataStore ds = (DataStore)dataStoreInfo.getDataStore(null);
            MatcherAssert.assertThat((Object)ds, (Matcher)Matchers.instanceOf(DirectoryDataStore.class));
            return;
        }
    }

    static {
        System.setProperty("ALLOW_ENV_PARAMETRIZATION", "true");
        TIMERANGES = new QName(MockData.SF_URI, "timeranges", MockData.SF_PREFIX);
    }
}

