/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.MockTestData;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.test.GeoServerMockTestSupport;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.mockito.Mockito;

public class LayerGroupHelperTest
extends GeoServerMockTestSupport {
    private LayerGroupInfo lakesNeatline;
    private LayerGroupInfo ponds;
    private LayerGroupInfo nested;
    private LayerGroupInfo loop1;
    private LayerGroupInfo loop2;
    private LayerGroupInfo loop2Child;
    private LayerGroupInfo container;
    private LayerGroupInfo containerParent;
    private LayerInfo lakesLayer;
    private LayerInfo neatlineLayer;
    private LayerInfo pondsLayer;
    private LayerInfo forestLayer;
    private LayerInfo buildingsLayer;
    private LayerInfo roadSegmentsLayer;
    private StyleInfo lineStyle;
    private StyleInfo polygonStyle;
    private StyleInfo pointStyle;

    @Override
    protected MockTestData createTestData() throws Exception {
        MockTestData testData = new MockTestData();
        testData.setIncludeRaster(true);
        return testData;
    }

    private LayerGroupInfo buildGroup(String name, PublishedInfo ... publisheds) {
        LayerGroupInfoImpl group = (LayerGroupInfoImpl)this.getCatalog().getFactory().createLayerGroup();
        group.setId(name);
        group.setName(name);
        group.getLayers().addAll(Arrays.asList(publisheds));
        return group;
    }

    private LayerInfo buildLayer(QName resourceName) throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        DataStoreInfo store = cat.getDataStoreByName(resourceName.getPrefix());
        cb.setStore((StoreInfo)store);
        FeatureTypeInfo ri = cb.buildFeatureType(this.toName(resourceName));
        ri.setSRS("EPSG:4326");
        cb.setupBounds((ResourceInfo)ri);
        LayerInfo layer = cat.getFactory().createLayer();
        layer.setResource((ResourceInfo)ri);
        layer.setName(ri.getName());
        layer.setEnabled(true);
        layer.setType(PublishedType.VECTOR);
        return layer;
    }

    @Before
    public void buildTestNestedGroup() throws Exception {
        this.lineStyle = this.getCatalog().getStyleByName("Streams");
        this.polygonStyle = this.getCatalog().getStyleByName("Buildings");
        this.pointStyle = this.getCatalog().getStyleByName("Bridges");
        this.lakesLayer = this.buildLayer(MockData.LAKES);
        this.neatlineLayer = this.buildLayer(MockData.MAP_NEATLINE);
        this.lakesNeatline = this.buildGroup("lakesNeatline", new PublishedInfo[]{this.lakesLayer, this.neatlineLayer});
        this.lakesNeatline.setMode(LayerGroupInfo.Mode.EO);
        this.roadSegmentsLayer = this.buildLayer(MockData.ROAD_SEGMENTS);
        this.lakesNeatline.setRootLayer(this.roadSegmentsLayer);
        this.lakesNeatline.setRootLayerStyle(this.lineStyle);
        this.lakesNeatline.getStyles().add(this.polygonStyle);
        this.lakesNeatline.getStyles().add(this.pointStyle);
        this.pondsLayer = this.buildLayer(MockData.PONDS);
        this.ponds = this.buildGroup("ponds", new PublishedInfo[]{this.pondsLayer});
        this.ponds.getStyles().add(null);
        this.forestLayer = this.buildLayer(MockData.FORESTS);
        this.buildingsLayer = this.buildLayer(MockData.BUILDINGS);
        this.nested = this.buildGroup("nested", new PublishedInfo[]{this.forestLayer, this.lakesNeatline, this.buildingsLayer, this.ponds});
        this.nested.getStyles().add(this.polygonStyle);
        this.nested.getStyles().add(null);
        this.nested.getStyles().add(this.polygonStyle);
        this.nested.getStyles().add(null);
        this.loop1 = this.buildGroup("loop1", new PublishedInfo[]{this.forestLayer});
        this.loop1.getLayers().add(this.loop1);
        this.loop1.getStyles().add(null);
        this.loop1.getStyles().add(null);
        this.loop2 = this.buildGroup("loop2", new PublishedInfo[]{this.forestLayer});
        this.loop2Child = this.buildGroup("ponds", new PublishedInfo[]{this.pondsLayer, this.loop2});
        this.loop2Child.getStyles().add(null);
        this.loop2Child.getStyles().add(null);
        this.loop2.getLayers().add(this.loop2Child);
        this.loop2.getStyles().add(null);
        this.loop2.getStyles().add(null);
        this.container = this.buildGroup("container", new PublishedInfo[]{this.forestLayer});
        this.container.getStyles().add(this.polygonStyle);
        this.container.setMode(LayerGroupInfo.Mode.CONTAINER);
        this.containerParent = this.buildGroup("containerParent", new PublishedInfo[]{this.container});
        this.containerParent.getStyles().add(null);
    }

    @Test
    public void testSimpleLoop() {
        Assert.assertNull((Object)new LayerGroupHelper(this.nested).checkLoops());
        LayerGroupHelper helper = new LayerGroupHelper(this.loop1);
        Stack path = helper.checkLoops();
        Assert.assertNotNull((Object)path);
        Assert.assertEquals((Object)"/loop1/loop1", (Object)helper.getLoopAsString(path));
        helper = new LayerGroupHelper(this.loop2);
        path = helper.checkLoops();
        Assert.assertNotNull((Object)path);
        Assert.assertEquals((Object)"/loop2/ponds/loop2", (Object)helper.getLoopAsString(path));
    }

    @Test
    public void testSimpleLoopWithNotEqualGroups() {
        LayerGroupInfo myLoop = this.buildGroup("myLoop", new PublishedInfo[]{this.forestLayer});
        myLoop.getStyles().add(null);
        LayerGroupInfo loopClone = this.buildGroup("myLoop", new PublishedInfo[]{this.forestLayer});
        loopClone.getStyles().add(null);
        Assert.assertEquals((Object)myLoop, (Object)loopClone);
        myLoop.setTitle("new title");
        Assert.assertNotEquals((Object)myLoop, (Object)loopClone);
        myLoop.getLayers().add(loopClone);
        myLoop.getStyles().add(null);
        LayerGroupHelper helper = new LayerGroupHelper(myLoop);
        Stack path = helper.checkLoops();
        Assert.assertNotNull((Object)path);
        Assert.assertEquals((Object)"/myLoop/myLoop", (Object)helper.getLoopAsString(path));
    }

    @Test
    public void testAllLayers() {
        this.assertExpectedLayers(Arrays.asList(this.pondsLayer), this.ponds);
        this.assertExpectedLayers(Arrays.asList(this.roadSegmentsLayer, this.lakesLayer, this.neatlineLayer), this.lakesNeatline);
        this.assertExpectedLayers(Arrays.asList(this.forestLayer, this.roadSegmentsLayer, this.lakesLayer, this.neatlineLayer, this.buildingsLayer, this.pondsLayer), this.nested);
        this.assertExpectedLayers(Arrays.asList(this.forestLayer), this.container);
        this.assertExpectedLayers(Arrays.asList(this.forestLayer), this.containerParent);
    }

    @Test
    public void testAllGroups() {
        this.assertExpectedGroups(Arrays.asList(this.nested, this.lakesNeatline, this.ponds), this.nested);
    }

    private void assertExpectedLayers(List<LayerInfo> expected, LayerGroupInfo group) {
        List layers = new LayerGroupHelper(group).allLayers();
        Assert.assertEquals(expected, (Object)layers);
    }

    private void assertExpectedGroups(List<LayerGroupInfo> expected, LayerGroupInfo group) {
        List layers = new LayerGroupHelper(group).allGroups();
        Assert.assertEquals(expected, (Object)layers);
    }

    @Test
    public void testAllLayersForRendering() {
        this.assertExpectedRenderingLayers(Arrays.asList(this.pondsLayer), this.ponds);
        this.assertExpectedRenderingLayers(Arrays.asList(this.roadSegmentsLayer), this.lakesNeatline);
        this.assertExpectedRenderingLayers(Arrays.asList(this.forestLayer, this.roadSegmentsLayer, this.buildingsLayer, this.pondsLayer), this.nested);
        try {
            this.assertExpectedRenderingLayers(Arrays.asList(this.forestLayer), this.container);
            Assert.fail((String)"Unsupported Operation...");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.assertExpectedRenderingLayers(Arrays.asList(this.forestLayer), this.containerParent);
    }

    private void assertExpectedRenderingLayers(List<LayerInfo> expected, LayerGroupInfo group) {
        List layers = new LayerGroupHelper(group).allLayersForRendering();
        Assert.assertEquals(expected, (Object)layers);
    }

    @Test
    public void testAllStyles() {
        this.assertExpectedStyles(Arrays.asList(new StyleInfo[]{null}), this.ponds);
        this.assertExpectedStyles(Arrays.asList(this.lineStyle, this.polygonStyle, this.pointStyle), this.lakesNeatline);
        this.assertExpectedStyles(Arrays.asList(this.polygonStyle, this.lineStyle, this.polygonStyle, this.pointStyle, this.polygonStyle, null), this.nested);
        this.assertExpectedStyles(Arrays.asList(this.polygonStyle), this.container);
        this.assertExpectedStyles(Arrays.asList(this.polygonStyle), this.containerParent);
    }

    private void assertExpectedStyles(List<StyleInfo> expected, LayerGroupInfo group) {
        List styles = new LayerGroupHelper(group).allStyles();
        Assert.assertEquals(expected, (Object)styles);
    }

    @Test
    public void testAllStylesForRendering() {
        this.assertExpectedRenderingStyles(Arrays.asList(new StyleInfo[]{null}), this.ponds);
        this.assertExpectedRenderingStyles(Arrays.asList(this.lineStyle), this.lakesNeatline);
        this.assertExpectedRenderingStyles(Arrays.asList(this.polygonStyle, this.lineStyle, this.polygonStyle, null), this.nested);
        try {
            this.assertExpectedRenderingStyles(Arrays.asList(this.polygonStyle), this.container);
            Assert.fail((String)"Unsupported Operation...");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.assertExpectedRenderingStyles(Arrays.asList(this.polygonStyle), this.containerParent);
    }

    private void assertExpectedRenderingStyles(List<StyleInfo> expected, LayerGroupInfo group) {
        List styles = new LayerGroupHelper(group).allStylesForRendering();
        Assert.assertEquals(expected, (Object)styles);
    }

    @Test
    public void testBounds() throws Exception {
        new LayerGroupHelper(this.ponds).calculateBounds();
        Assert.assertEquals((Object)this.ponds.getBounds(), (Object)this.ponds.getBounds());
        ReferencedEnvelope eoExpected = this.aggregateEnvelopes(this.roadSegmentsLayer, this.lakesLayer, this.neatlineLayer);
        new LayerGroupHelper(this.lakesNeatline).calculateBounds();
        ReferencedEnvelope eoActual = this.lakesNeatline.getBounds();
        Assert.assertEquals((Object)eoExpected, (Object)eoActual);
        ReferencedEnvelope nestedExpected = this.aggregateEnvelopes(this.forestLayer, this.roadSegmentsLayer, this.lakesLayer, this.neatlineLayer, this.buildingsLayer, this.pondsLayer);
        new LayerGroupHelper(this.nested).calculateBounds();
        Assert.assertEquals((Object)nestedExpected, (Object)this.nested.getBounds());
    }

    @Test
    public void testBoundsCRS() throws Exception {
        CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:32628", (boolean)true);
        ReferencedEnvelope nestedExpected = this.aggregateEnvelopes(this.forestLayer, this.roadSegmentsLayer, this.lakesLayer, this.neatlineLayer, this.buildingsLayer, this.pondsLayer);
        nestedExpected = nestedExpected.transform(targetCRS, true);
        new LayerGroupHelper(this.nested).calculateBounds(targetCRS);
        Assert.assertEquals((Object)nestedExpected, (Object)this.nested.getBounds());
    }

    @Test
    public void testUseCRSBounds() throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:4326");
        LayerGroupHelper helper = new LayerGroupHelper(this.nested);
        helper.calculateBoundsFromCRS(targetCRS);
        Assert.assertEquals((Object)this.nested.getBounds(), (Object)new ReferencedEnvelope(CRS.getEnvelope((CoordinateReferenceSystem)targetCRS)));
        helper.calculateBoundsFromCRS(null);
        Assert.assertNull((Object)this.nested.getBounds());
    }

    @Test
    public void testUseProvidedCatalog() {
        Catalog catalog = (Catalog)Mockito.mock(Catalog.class);
        LayerGroupHelper helper = new LayerGroupHelper(catalog, this.container);
        Assert.assertSame((Object)catalog, (Object)helper.catalog);
    }

    @Test
    public void testDefaultsToCatalogBean() {
        Catalog catalog = (Catalog)Mockito.mock(Catalog.class);
        GeoServerExtensionsHelper.singleton("catalog", catalog, Catalog.class);
        try {
            LayerGroupHelper helper = new LayerGroupHelper(this.container);
            Assert.assertSame((Object)catalog, (Object)helper.catalog);
        }
        finally {
            GeoServerExtensionsHelper.init(null);
        }
    }

    private ReferencedEnvelope aggregateEnvelopes(LayerInfo ... layers) {
        ReferencedEnvelope eoExpected = new ReferencedEnvelope((Envelope)layers[0].getResource().getNativeBoundingBox(), layers[0].getResource().getCRS());
        for (int i = 1; i < layers.length; ++i) {
            eoExpected.expandToInclude((Envelope)layers[i].getResource().getNativeBoundingBox());
        }
        return eoExpected;
    }
}

