/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver;

import org.geoserver.config.impl.GeoServerLifecycleHandler;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class GeoServerLifecycleTestSupport
extends GeoServerSystemTestSupport {
    @Override
    protected void onSetUp(SystemTestData data) throws Exception {
        super.onSetUp(data);
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        beanFactory.registerSingleton("lifecycleWatcher", (Object)new LifecycleWatcher());
    }

    protected LifecycleWatcher getLifecycleWatcher() {
        return (LifecycleWatcher)applicationContext.getBean(LifecycleWatcher.class);
    }

    @Override
    protected void destroyGeoServer() {
        LifecycleWatcher watcher = this.getLifecycleWatcher().reset();
        super.destroyGeoServer();
        Assert.assertTrue((boolean)watcher.didDispose);
    }

    protected static class LifecycleWatcher
    implements GeoServerLifecycleHandler {
        boolean didReload = false;
        boolean didBeforeReload = false;
        boolean didReset = false;
        boolean didDispose = false;

        protected LifecycleWatcher() {
        }

        public LifecycleWatcher reset() {
            this.didBeforeReload = false;
            this.didReload = false;
            this.didReset = false;
            this.didDispose = false;
            return this;
        }

        public void onReset() {
            this.didReset = true;
        }

        public void onReload() {
            this.didReload = true;
        }

        public void onDispose() {
            this.didDispose = true;
        }

        public void beforeReload() {
            this.didBeforeReload = true;
        }
    }
}

